.TH libInterViews 3I "31 July 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
libInterViews \- base InterViews library
.SH SYNOPSIS
.B #include <InterViews/\fIclass\fP.h>
.br
.B "CC ... \-lInterViews \-lX \-lm"
.SH DESCRIPTION
InterViews is a collection of C++ classes
for implementing user interfaces.
All interactive objects are derived directly or indirectly from the
.B Interactor
class.
All composite interactive objects are derived directly or indirectly from the
.B Scene
class,
which itself is derived from
.B Interactor.
Subclasses
include Box(3I) and Glue(3I) for tiling interactors,
Tray(3I) for overlapping/aligning,
Frame(3I) for decorating a single interactor,
Deck(3I) for paging through a list of interactors
(one visible at a time), Viewport(3I) for scrolling/panning
around a larger interactor,
Scroller(3I) for a simple scrollbar,
Panner(3I) for 2-D scrolling and zooming, and
Menu(3I) for simple pop-up menus.
An instance of the World(3I) subclass
is used to map interactors onto a display.
.PP
A number of classes are provided for graphics input and output.
These include Canvas(3I) for display regions;
Painter(3I) for drawing operations;
Brush(3I), Color(3I), Font(3I), and Pattern(3I)
for controlling graphics characteristics;
Cursor(3I) for the screen appearance of a pointing device;
Event(3I) for input events, and
Sensor(3I) for expressing interest in a set of possible events;
Rubberband(3I) objects for
interactive dragging and placement.
.PP
The basic InterViews library includes the above classes.
The \fIlibgraphic\fP(3I) library provides an additional set of classes
for defining structured graphics and storing graphical objects in files.
The \fIlibtext\fP(3I) library provides classes for manipulating
structured and unstructured text objects.
.PP
All InterViews header files include
the following definitions from ``<InterViews/defs.h>'':
.TP
.B typedef int Coord;
Display coordinates are represented uniformly as 32-bit integers;
however, the units depend on context because
of the possibility of coordinate transformations
(see Painter(3I)).
The predefined variables
.B cm, inches, pixels,
and
.B points
should be used as units if no transformations are present
(e.g., ``Coord\ x\ =\ 3*inches'').
This convention makes the coordinate values independent of screen resolution.
The variables
.B inch
and
.B point
are also provided as synonyms for
.B inches
and
.B points,
respectively.
.TP
.B "typedef enum { true = 1, false = 0 } boolean;"
.TP
.B "typedef enum {"
.ns
.TP
.B "	TopLeft, TopCenter, TopRight"
.ns
.TP
.B "	CenterLeft, Center, CenterRight"
.ns
.TP
.B "	BottomLeft, BottomCenter, BottomRight"
.ns
.TP
.B "	Left, Right, Top, Bottom"
.ns
.TP
.B "} Alignment;"
.TP
.B "#define nil 0"
.TP
.B int min(int, int), int max(int, int)
Return the minimum and maximum of two integers, respectively.
.TP
.B int round(double)
Return the integer closest to its argument.
.SH SEE ALSO
libgraphic(3I), libtext(3I)
