/*
  pipeLib.c

  by Simon Clift
  University of Waterloo, CS Dept., SciCom Group

  Use this at your own risk.

  A small library of functions to allow FORTRAN 77 on the Sun to use
  pipes to talk to other programs interactively.

*/

#include <stdio.h>


/*
  Allow an array of file descriptors
*/

#define	MaxPipes		20
#define	PipeOpen		-1
#define	PipeClosed		0

FILE		*pipes[MaxPipes];
int		pipes_open[MaxPipes];		/* status */

/*
  plinit_

  Initialize pipes system
*/

void plinit_( void )
{
	int 	i;

	for( i=0 ; i < MaxPipes ; i++ ) {
		pipes_open[i] = PipeClosed;
	}
}

/*
  plopen_

  Open a pipe to a program given the startup command, and either "r" or "w"

  Status variable   stat = Pipe number on successful open, -1 otherwise
*/

void plopen_( char * command, char * mode, int * stat )
{
	int	i;

	for( i=0 ; i < MaxPipes ; i++ ) {
		if( pipes_open[i] == PipeClosed ) {
			break;
		}
	}

	if( i == MaxPipes ) {
		*stat = -1;
	} else {
		pipes[i] = popen( command, mode );
		*stat = (i+1);
	}
}

/* 
  plwrit_

  Write a string to a pipe.

*/

void plwrit_( int * pipeNum, char * stringOut )
{
	fprintf( pipes[*pipeNum-1], "%s\n", stringOut );
}

/*
  plflus_

  Flush a pipe's output
*/

void plflus_( int *pipeNum )
{
	fflush( pipes[ *pipeNum - 1 ] );
}

/*
  plclos_

  Close a pipe
*/

void plclos_( int * pipeNum )
{
	pclose( pipes[*pipeNum-1] );
}
