
/*  *************************************************************************
    macmenu2.c -- The Macintosh menu functions code (part 2 of 2) for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Desk.h>
#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macqd.h"
#include "macmenu.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define SUBRS(x)								    \
x("menu-item-disable",	    m_i_dis,	MENUINT_FUNC,		DisableItem)	    \
x("menu-item-enable",	    m_i_ena,	MENUINT_FUNC,		EnableItem)	    \
x("menu-item-delete",	    m_i_del,	MENUINT_FUNC,		DelMenuItem)	    \
x("menu-item-insert",	    m_i_ins,	MENUSTRINGINT_FUNC,	InsMenuItem)	    \
x("menu-item-set",	    m_i_s,	MENUINTSTRING_FUNC,	SetItem)	    \
x("menu-item-get",	    m_i_g,	MENUINT_STRING_FUNC,	GetItem)	    \
x("menu-item-check",	    m_i_ch,	MENUINTBOOL_FUNC,	CheckItem)	    \
x("menu-item-set-mark",	    m_i_s_m,	MENUINT2_FUNC,		SetItemMark)	    \
x("menu-item-set-icon",	    m_i_s_i,	MENUINT2_FUNC,		SetItemIcon)	    \
x("menu-item-set-style",    m_i_s_s,	MENUINT2_FUNC,		SetItemStyle)	    \
x("menu-item-set-cmd",	    m_i_s_c,	MENUINT2_FUNC,		SetItemCmd)	    \
x("menu-item-get-mark",	    m_i_g_m,	MENUINT_INT_FUNC,	GetItemMark)	    \
x("menu-item-get-icon",	    m_i_g_i,	MENUINT_INT_FUNC,	GetItemIcon)	    \
x("menu-item-get-style",    m_i_g_s,	MENUINT_INT_FUNC,	GetItemStyle)	    \
x("menu-item-get-cmd",	    m_i_g_c,	MENUINT_INT_FUNC,	GetItemCmd)	    \


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_menu2)


/*  ************************************************************************/
