#ifndef __macqd_h__
#define __macqd_h__

/*  *************************************************************************
    macctrl.h -- The Macintosh QuickDraw functions header for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#define _PT_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)		    \
{					    \
  Point p;				    \
					    \
  CHECK_NULL(s_args, ARG1, S_MAC_(name));   \
  call(&p);				    \
					    \
  return (make_macpt(&p));		    \
}

#define PT_PT_FUNC(name, call)				    \
SCM MAC_(name)(SCM s_args)					    \
{								    \
  Point p;							    \
								    \
  GET_NEXT_MACPT(p, s_args, ARG1, S_MAC_(name));		    \
  call(&p);							    \
								    \
  return (make_macpt(&p));					    \
}

#define PT_INT_FUNC(name, call)					    \
SCM MAC_(name)(SCM s_args)					    \
{								    \
  Point p;							    \
								    \
  GET_NEXT_MACPT(p, s_args, ARG1, S_MAC_(name));		    \
								    \
  return MAKINUM (call(p));					    \
}

#define PT2_BOOL_FUNC(name, call)				    \
SCM MAC_(name)(SCM s_args)					    \
{								    \
  Point p1, p2;							    \
								    \
  GET_NEXT_MACPT(p1, s_args, ARG1, S_MAC_(name));		    \
  GET_NEXT_MACPT(p2, s_args, ARG2, S_MAC_(name));		    \
								    \
  return call(p1, p2) ? BOOL_T : BOOL_F;			    \
}

#define PTRECT_BOOL_FUNC(name, call)				    \
SCM MAC_(name)(SCM s_args)					    \
{								    \
  Point p;							    \
  Rect r;							    \
								    \
  GET_NEXT_MACPT(p, s_args, ARG1, S_MAC_(name));		    \
  GET_NEXT_MACRECT(r, s_args, ARG2, S_MAC_(name));		    \
								    \
  return call(p, &r) ? BOOL_T : BOOL_F;				    \
}

#define RECT_FUNC(name, call)						\
SCM MAC_(name)(SCM s_args)						\
{									\
  Rect r;								\
									\
  GET_NEXT_MACRECT(r, s_args, ARG1, S_MAC_(name));			\
  call(&r);								\
									\
  return UNSPECIFIED;							\
}

#define RECT_INT_FUNC(name, call)					\
SCM MAC_(name)(SCM s_args)						\
{									\
  Rect r;								\
									\
  GET_NEXT_MACRECT(r, s_args, ARG1, S_MAC_(name));			\
									\
  return MAKINUM (call(r));						\
}

#define RECTINT2_FUNC(name, call)					\
SCM MAC_(name)(SCM s_args)						\
{									\
  Rect r;								\
  long x, y;								\
									\
  GET_NEXT_MACRECT(r, s_args, ARG1, S_MAC_(name));			\
  GET_NEXT_INT(x, s_args, ARG2, S_MAC_(name));				\
  GET_NEXT_INT(y, s_args, ARG3, S_MAC_(name));				\
  call(&r, x, y);							\
									\
  return UNSPECIFIED;							\
}

#define RECTINT2_RECT_FUNC(name, call)					\
SCM MAC_(name)(SCM s_args)						\
{									\
  Rect r;								\
  long x, y;								\
									\
  GET_NEXT_MACRECT(r, s_args, ARG1, S_MAC_(name));			\
  GET_NEXT_INT(x, s_args, ARG2, S_MAC_(name));				\
  GET_NEXT_INT(y, s_args, ARG3, S_MAC_(name));				\
  call(&r, x, y);							\
									\
  return make_macrect(&r);						\
}


/*  ************************************************************************/

#endif /* __macqd_h__ */
