#ifndef __macscm_h__
#define __macscm_h__

/*  *************************************************************************
    macscm.h -- The main header for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


extern SCM mark_no_further();

#ifdef __STDC__
# define TOKEN_PASTE(a,b) a##b
#else
# define TOKEN_PASTE(a,b) TOKEN_PASTE_(a)b
# define TOKEN_PASTE_(a) a
#endif


/*  *************************************************************************
    Here is a collection of definitions for selection macros.
    ************************************************************************/


#define S_2_0(a,b)
#define S_2_1(a,b)	    a
#define S_2_2(a,b)	    b
#define S_6_0(a,b,c,d,e,f)
#define S_6_1(a,b,c,d,e,f)  a
#define S_6_2(a,b,c,d,e,f)  b
#define S_6_3(a,b,c,d,e,f)  c
#define S_6_4(a,b,c,d,e,f)  d
#define S_6_5(a,b,c,d,e,f)  e
#define S_6_6(a,b,c,d,e,f)  f


/*  *************************************************************************
    Here is a collection of macros for prepending identifiers.
    ************************************************************************/


#define PRINT_(x)	TOKEN_PASTE(print_,x)
#define TC16_(x)	TOKEN_PASTE(tc16_,x)
#define SMOB(x)		TOKEN_PASTE(smob,x)
#define MAKE_(x)	TOKEN_PASTE(make_,x)
#define FREE_(x)	TOKEN_PASTE(free_,x)
#define S_(x)		TOKEN_PASTE(s_,x)
#define S_MAC_(x)	TOKEN_PASTE(s_mac_,x)
#define MAC_(x)		TOKEN_PASTE(mac_,x)


/*  *************************************************************************
    Misc. definitions.
    ************************************************************************/


#define SUBPAIR(x)	{ S_(x), x }
#define M_SUBPAIR(x)	SUBPAIR(MAC_(x))
#define BOOLP(x) 1
#define IDENTITY(x) x


/*  *************************************************************************
    Predicates for testing the Macintosh types of SCM objects.
    ************************************************************************/


#define MACMBARP(x) (TYP16(x) == tc16_macmbar)
#define MACWINDP(x) (TYP16(x) == tc16_macwind)
#define MACRECTP(x) (TYP16(x) == tc16_macrect)
#define MACPTP(x)   (TYP16(x) == tc16_macpt)
#define MACPATP(x)  (TYP16(x) == tc16_macpat)
#define MACCURSP(x) (TYP16(x) == tc16_maccurs)
#define MACEVTP(x)  (TYP16(x) == tc16_macevt)
#define MACCTRLP(x) (TYP16(x) == tc16_macctrl)
#define MACMENUP(x) (TYP16(x) == tc16_macmenu)
#define MACTEP(x)   (TYP16(x) == tc16_macte)


/*  *************************************************************************
    Macros for extracting data from the Macintosh types of SCM objects.
    ************************************************************************/


#define MACMBAR(x)  ((Handle)		CDR(x))
#define MACWIND(x)  ((WindowPtr)	CDR(x))
#define MACCTRL(x)  ((ControlHandle)	CDR(x))
#define MACMENU(x)  ((MenuHandle)	CDR(x))
#define MACTE(x)    ((TEHandle)		CDR(x))
#define MACRECT(x)  (*((Rect *)		CDR(x)))
#define MACPT(x)    (*((Point *)	CDR(x)))
#define MACPAT(x)   (*((Pattern *)	CDR(x)))
#define MACCURS(x)  (*((Cursor *)	CDR(x)))
#define MACEVT(x)   (*((EventRecord *)	CDR(x)))


/*  *************************************************************************
    Here is a list of 6-tuples that describe the characteristics of
    various SCM objects for the Macintosh.
    ************************************************************************/

#define TSCM(x)	    x(0, SCM, 0, BOOLP, IDENTITY, 0)
#define TINT(x)	    x(0, long, 0, INUMP, INUM, 0)
#define TBOOL(x)    x(0, char, 0, BOOLP, NFALSEP, 0)
#define TSTRING(x)  x(0, (char *), 0, STRINGP, CHARS, 0)
#define TMACWIND(x) x(macwind, WindowPtr, "window", MACWINDP, MACWIND, S_2_1)
#define TMACCTRL(x) x(macctrl, ControlHandle, "control", MACCTRLP, MACCTRL, S_2_1)
#define TMACMENU(x) x(macmenu, MenuHandle, "menu", MACMENUP, MACMENU, S_2_1)
#define TMACMBAR(x) x(macmbar, Handle, "menu bar", MACMBARP, MACMBAR, S_2_1)
#define TMACTE(x)   x(macte, Handle, "textedit", MACTEP, MACTE, S_2_1)
#define TMACPT(x)   x(macpt, Point, "point", MACPTP, MACPT, S_2_2)
#define TMACRECT(x) x(macrect, Rect, "rect", MACRECTP, MACRECT, S_2_2)
#define TMACCURS(x) x(maccurs, Cursor, "cursor", MACCURSP, MACCURS, S_2_2)
#define TMACPAT(x)  x(macpat, Pattern, "pattern", MACPATP, MACPAT, S_2_2)
#define TMACEVT(x)  x(macevt, EventRecord, "event", MACEVTP, MACEVT, S_2_2)


/*  *************************************************************************
    Here is a list of macro definitions that extract information
    from the SCM object descriptor tuples.
    ************************************************************************/


#define TYPE_MAKE(x) x(S_6_1)
#define TYPE_CTYP(x) x(S_6_2)
#define TYPE_NAME(x) x(S_6_3)
#define TYPE_PRED(x) x(S_6_4)
#define TYPE_CONV(x) x(S_6_5)
#define TYPE_ALLC(x) x(S_6_6)


/*  *************************************************************************
    Here is the list of Macintosh SCM objects.
    ************************************************************************/


#define MAC_SMOBS(x)	\
    x(TMACWIND)		\
    x(TMACCTRL)		\
    x(TMACMENU)		\
    x(TMACMBAR)		\
    x(TMACTE)		\
    x(TMACPT)		\
    x(TMACRECT)		\
    x(TMACCURS)		\
    x(TMACPAT)		\
    x(TMACEVT)		\


/*  *************************************************************************
    Here is a macro to turn the SCM object list into a list of declarations.
    ************************************************************************/

#define DECL_EXTERN(type)					\
    TYPE_ALLC(type)(						\
	extern long TC16_(TYPE_MAKE(type));			\
	extern long MAKE_(TYPE_MAKE(type))(TYPE_CTYP(type));	\
    ,								\
	extern long TC16_(TYPE_MAKE(type));			\
	extern long MAKE_(TYPE_MAKE(type))(TYPE_CTYP(type) *);	\
	extern sizet FREE_(TYPE_MAKE(type))(SCM);		\
    )

MAC_SMOBS(DECL_EXTERN)


/*  *************************************************************************
    Here is a macro to turn a list of SCM functions into a list of
    prototypes, functions, and SCM procedure declarations, respectively.
    ************************************************************************/


#define DECL_PROTOS(strg,name,func,call)			\
    static char S_MAC_(name)[] = "mac:" strg;			\
    static SCM MAC_(name)(SCM s_args);
#define DECL_FUNCS(strg,name,func,call) func(name,call)
#define DECL_SUBRS(strg,name,func,call) M_SUBPAIR(name),


/*  *************************************************************************
    Here are some macros to extract arguments from a SCM argument list.
    ************************************************************************/


#define CHECK_NULL(args, err, rtn)  ASSERT(NULLP(args), args, err, rtn);

#define GET_NEXT_(result, args, err, rtn, pred, conv)				\
    ASSERT(NIMP(args) && CONSP(args) && pred(CAR(args)), args, err, rtn);	\
    result = conv(CAR(args));							\
    args = CDR(args);

#define GET_NEXT_TYPE(type, result, args, err, rtn)				\
    GET_NEXT_(result, args, err, rtn, TYPE_PRED(type), TYPE_CONV(type))

#define GET_NEXT_SCM(a,b,c,d)	    GET_NEXT_TYPE(TSCM, a,b,c,d)
#define GET_NEXT_INT(a,b,c,d)	    GET_NEXT_TYPE(TINT, a,b,c,d)
#define GET_NEXT_BOOL(a,b,c,d)	    GET_NEXT_TYPE(TBOOL, a,b,c,d)
#define GET_NEXT_STRING(a,b,c,d)    GET_NEXT_TYPE(TSTRING, a,b,c,d)
#define GET_NEXT_MACRECT(a,b,c,d)   GET_NEXT_TYPE(TMACRECT, a,b,c,d)
#define GET_NEXT_MACMENU(a,b,c,d)   GET_NEXT_TYPE(TMACMENU, a,b,c,d)
#define GET_NEXT_MACMBAR(a,b,c,d)   GET_NEXT_TYPE(TMACMBAR, a,b,c,d)
#define GET_NEXT_MACWIND(a,b,c,d)   GET_NEXT_TYPE(TMACWIND, a,b,c,d)
#define GET_NEXT_MACCTRL(a,b,c,d)   GET_NEXT_TYPE(TMACCTRL, a,b,c,d)
#define GET_NEXT_MACTE(a,b,c,d)	    GET_NEXT_TYPE(TMACTE, a,b,c,d)
#define GET_NEXT_MACEVT(a,b,c,d)    GET_NEXT_TYPE(TMACEVT, a,b,c,d)
#define GET_NEXT_MACPT(a,b,c,d)	    GET_NEXT_TYPE(TMACPT, a,b,c,d)


/*  *************************************************************************
    Here are some macros for particular types of SCM functions.
    ************************************************************************/


#define _UNSPEC_FUNC(name, call)	    \
SCM MAC_(name)(SCM s_args)		    \
{					    \
  CHECK_NULL(s_args, ARG1, S_MAC_(name));   \
  call;					    \
					    \
  return UNSPECIFIED;			    \
}

#define _INT_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)		    \
{					    \
  CHECK_NULL(s_args, ARG1, S_MAC_(name));   \
					    \
  return MAKINUM((long) call());	    \
}

#define BOOL_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)			\
{						\
  char b;					\
						\
  GET_NEXT_BOOL(b, s_args, ARG1, S_MAC_(name)); \
						\
  return UNSPECIFIED;				\
}

#define _BOOL_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)		    \
{					    \
  CHECK_NULL(s_args, ARG1, S_MAC_(name));   \
					    \
  return call() ? BOOL_T : BOOL_F;	    \
}

#define INT_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)			\
{						\
  long x;					\
						\
  GET_NEXT_INT(x, s_args, ARG1, S_MAC_(name));	\
  call(x);					\
						\
  return UNSPECIFIED;				\
}

#define INT_INT_FUNC(name, call)		\
SCM MAC_(name)(SCM s_args)			\
{						\
  long x;					\
						\
  GET_NEXT_INT(x, s_args, ARG1, S_MAC_(name));	\
						\
  return MAKINUM((long) call(x));		\
}

#define INT2_FUNC(name, call)			\
SCM MAC_(name)(SCM s_args)			\
{						\
  long x, y;					\
						\
  GET_NEXT_INT(x, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(y, s_args, ARG2, S_MAC_(name));	\
  call(x, y);					\
						\
  return UNSPECIFIED;				\
}

#define INT2_BOOL_FUNC(name, call)		\
SCM MAC_(name)(SCM s_args)			\
{						\
  long x, y;					\
						\
  GET_NEXT_INT(x, s_args, ARG1, S_MAC_(name));	\
  GET_NEXT_INT(y, s_args, ARG2, S_MAC_(name));	\
						\
  return (call(x, y)) ? BOOL_T : BOOL_F;	\
}

#define _STRING_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  char *pc;					    \
						    \
  pc = call;					    \
						    \
  return makfromstr(pc, strlen(pc));		    \
}

#define STRING_FUNC(name, call)			    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  char *pc;					    \
						    \
  GET_NEXT_STRING(pc, s_args, ARG1, S_MAC_(name));  \
  c2pstr (strncpy((char *) GStr255, pc, 255));	    \
  call(&GStr255);				    \
						    \
  return UNSPECIFIED;				    \
}

#define STRING_INT_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  char *pc;					    \
						    \
  GET_NEXT_STRING(pc, s_args, ARG1, S_MAC_(name));  \
  c2pstr (strncpy((char *) GStr255, pc, 255));	    \
						    \
  return MAKINUM((long) call(&GStr255));	    \
}

#define STRING_INT_FUNC2(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  char *pc;					    \
  long n;					    \
						    \
  GET_NEXT_STRING(pc, s_args, ARG1, S_MAC_(name));  \
  c2pstr (strncpy((char *) GStr255, pc, 255));	    \
  call(GStr255, &n);				    \
						    \
  return MAKINUM(n);				    \
}

#define INT_STRING_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  long n;					    \
  char *pc;					    \
						    \
  GET_NEXT_INT(n, s_args, ARG1, S_MAC_(name));	    \
  call(n, &GStr255);				    \
  pc = p2cstr((char *) GStr255);		    \
						    \
  return makfromstr(pc, strlen(pc));		    \
}


/*  *************************************************************************
    This is a definition for a non-standard function in a SCM function
    list.
    ************************************************************************/


#define SPECIAL_FUNC(name,call)


/*  *************************************************************************
    This is a macro for declaring a list of SCM functions.
    ************************************************************************/


#define DECLARE_FUNCS(SUBRS, init_name)		\
    SUBRS(DECL_PROTOS)				\
    SUBRS(DECL_FUNCS)				\
						\
    static iproc mac_lsubr1s[] = {		\
      SUBRS(DECL_SUBRS)				\
      {0, 0}					\
    };						\
						\
    void init_name()				\
    {						\
      init_iprocs(mac_lsubr1s,	tc7_lsubr);	\
    }						\

#endif /* __macscm_h__ */
