#ifndef __macwind_h__
#define __macwind_h__

/*  *************************************************************************
    macctrl.h -- The Macintosh window functions header for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#define WIND_FUNC(name, call)			    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  call(w);					    \
						    \
  return UNSPECIFIED;				    \
}

#define WIND_INT_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
						    \
  return MAKINUM(call(w));			    \
}

#define WIND_RECT_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  Rect x;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  x = call(w);					    \
						    \
  return make_macrect(&x);			    \
}

#define WIND_PT_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  Point x;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  x = call(w);					    \
						    \
  return make_macpt(&x);			    \
}

#define WIND_PAT_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  Pattern x;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
						    \
  return make_macpat(&call(w));			    \
}

#define WIND_BOOL_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
						    \
  return (call(w)) ? BOOL_T : BOOL_F;		    \
}

#define _WIND_FUNC2(name, call)			    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
						    \
  CHECK_NULL(s_args, ARG1, S_MAC_(name));	    \
  call(&w);					    \
						    \
  if (w)					    \
    return make_macwind(w);			    \
  else						    \
    return BOOL_F;				    \
}

#define WIND2_FUNC(name, call)			    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w, x;				    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  GET_NEXT_MACWIND(x, s_args, ARG2, S_MAC_(name));  \
  call(w,x);					    \
						    \
  return UNSPECIFIED;				    \
}

#define _WIND_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)		    \
{					    \
  WindowPtr w;				    \
					    \
  CHECK_NULL(s_args, ARG1, S_MAC_(name));   \
  w = call();				    \
					    \
  if (w)				    \
    return make_macwind(w);		    \
  else					    \
    return BOOL_F;			    \
}

#define WINDBOOL_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  char b;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  GET_NEXT_BOOL(b, s_args, ARG2, S_MAC_(name));	    \
  call(w,b);					    \
						    \
  return UNSPECIFIED;				    \
}

#define WINDINTBOOL_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  long n;					    \
  char b;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  GET_NEXT_INT(n, s_args, ARG3, S_MAC_(name));	    \
  GET_NEXT_BOOL(b, s_args, ARG4, S_MAC_(name));	    \
  call(w,n,b);					    \
						    \
  return UNSPECIFIED;				    \
}

#define WINDINT2BOOL_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  long m,n;					    \
  char b;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  GET_NEXT_INT(m, s_args, ARG2, S_MAC_(name));	    \
  GET_NEXT_INT(n, s_args, ARG3, S_MAC_(name));	    \
  GET_NEXT_BOOL(b, s_args, ARG4, S_MAC_(name));	    \
  call(w,m,n,b);				    \
						    \
  return UNSPECIFIED;				    \
}

#define WINDSTRING_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  char *pc;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  GET_NEXT_STRING(pc, s_args, ARG2, S_MAC_(name));  \
  c2pstr (strncpy((char *) GStr255, pc, 255));	    \
  call (w, &GStr255);				    \
						    \
  return UNSPECIFIED;				    \
}

#define WIND_STRING_FUNC(name, call)		    \
SCM MAC_(name)(SCM s_args)			    \
{						    \
  WindowPtr w;					    \
  char *pc;					    \
						    \
  GET_NEXT_MACWIND(w, s_args, ARG1, S_MAC_(name));  \
  call(w, &GStr255);				    \
  pc = p2cstr((char *) GStr255);		    \
						    \
  return makfromstr(pc, strlen(pc));		    \
}


/*  ************************************************************************/

#endif /* __macwind_h__ */
