%{
/* Conversion of files between different charsets and usages.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1988.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define STEP	latex_ascii

extern int diacritics_only;

%}

After			[ \t]*(\{\})?

%%
\\#			{ if (diacritics_only) ECHO; else output ('#'); }
\\\$			{ if (diacritics_only) ECHO; else output ('$'); }
\\%			{ if (diacritics_only) ECHO; else output ('%'); }
\\&			{ if (diacritics_only) ECHO; else output ('&'); }
\\_			{ if (diacritics_only) ECHO; else output ('_'); }
\\\{			{ if (diacritics_only) ECHO; else output ('{'); }
\\\}			{ if (diacritics_only) ECHO; else output ('}'); }

\\backslash{After}	{ if (diacritics_only) ECHO; else output ('\\'); }


\\['`^"]\{\\i\}		{ output ('i'); output ('\b'); output (yytext[1]); }
\\['`^"]\\i{After}	{ output ('i'); output ('\b'); output (yytext[1]); }
\\['`^"]\{.\}		{ output (yytext[3]); output ('\b');
			  output (yytext[1]); }
\\['`^"].		{ output (yytext[2]); output ('\b');
			  output (yytext[1]); }

\\c\{.\}		{ output (','); output ('\b'); output (yytext[3]); }
\\c[ /t/n]+.		{ output (','); output ('\b');
			  output (yytext[yyleng-1]); }
