
/*  *************************************************************************
    macsmobs.c -- The Macintosh SCM object code for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "version.h"


/*  *************************************************************************
    Here define macros used to create declarations and definitions from the
    Macintosh SCM object descriptor list.
    ************************************************************************/


#define DECL_PRINT(type) DECL_PRINT2(type,TYPE_MAKE(type))
#define DECL_PRINT2(type,make)					\
    long TC16_(make);						\
    static int PRINT_(make)(SCM, FILE *, int);			\
    static smobfuns SMOB(make) = {				\
	mark_no_further,					\
	TYPE_ALLC(type)(free0, FREE_(make)),			\
	PRINT_(make)						\
    };

#define DECL_TYPENUMS(type)	DECL_TYPENUMS2(TYPE_MAKE(type))
#define DECL_TYPENUMS2(make)	TC16_(make) = newsmob(&SMOB(make));

#define SMOB_MAKE(type)						    \
    SMOB_MAKE2(type,TYPE_MAKE(type),TYPE_CTYP(type),TYPE_NAME(type))
#define SMOB_MAKE2(type,make,ctyp,name)				    \
    TYPE_ALLC(type)(						    \
	SCM MAKE_(make) (ctyp x)				    \
	{							    \
	    SCM w;						    \
	    NEWCELL(w);						    \
	    DEFER_INTS;						    \
	    CAR(w) = TC16_(make);				    \
	    SETCDR(w,x);					    \
	    ALLOW_INTS;						    \
	    return w;						    \
	}							    \
    ,								    \
	SCM MAKE_(make) (ctyp *x)				    \
	{							    \
	    SCM w;						    \
	    ctyp *y;						    \
	    y = (ctyp *) must_malloc(sizeof(ctyp), "make_" name);   \
	    memcpy(y, x, sizeof(ctyp));				    \
	    NEWCELL(w);						    \
	    DEFER_INTS;						    \
	    CAR(w) = TC16_(make);				    \
	    SETCDR(w,y);					    \
	    ALLOW_INTS;						    \
	    return w;						    \
	}							    \
	sizet FREE_(make) (w)					    \
	SCM w;							    \
	{							    \
	    free(CHARS(w));					    \
	    return sizeof(ctyp);				    \
	}							    \
    )

#define SMOB_PRINT(type) SMOB_PRINT2(type,TYPE_MAKE(type),TYPE_NAME(type))
#define SMOB_PRINT2(type,make,name)				    \
    static int PRINT_(make)(SCM exp, FILE *f, int writing) {	    \
	TYPE_ALLC(type)(					    \
	    lputs("#<Mac " name " #", f);			    \
	    intprint((long) CDR(exp), 16, f);			    \
	    lputc('>', f);					    \
	,							    \
	    lputs("#<Mac " name ">", f);			    \
	)							    \
	return 1;						    \
    }


/*  *************************************************************************
    Here declare all of the Macintosh SCM object printing functions.
    ************************************************************************/


MAC_SMOBS(DECL_PRINT)


/*
 * GC mark function that just marks this cell and returns BOOL_F,
 * as there are no further objects off this one
 */

SCM mark_no_further(ptr)
SCM ptr;
{
    assert(TYP7(ptr) == tc7_smob);
    SETGC8MARK(ptr);
    return BOOL_F;
}


/*  *************************************************************************
    Here we have all of the definitions for Macintosh SCM object
    construction, destruction, and printing functions.
    ************************************************************************/


MAC_SMOBS(SMOB_MAKE)
MAC_SMOBS(SMOB_PRINT)


/*  *************************************************************************
    This is the function called to initialize all of the Object types.
    ************************************************************************/


void init_mac_smobs()
{
    MAC_SMOBS(DECL_TYPENUMS)
}
