
/*  *************************************************************************
    macte.c -- The Macintosh textedit functions code (part 1 of 2) for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macte.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";


/*  ************************************************************************/


#define TE_KEY(t,a)		TEKey((a),(t))
#define TE_UPDATE(t,r)		TEUpdate((r),(t))
#define TE_SCROLL(t,a,b)	TEScroll((a),(b),(t))
#define TE_PINSCROLL(t,a,b)	TEPinScroll((a),(b),(t))
#define TE_INSERT(t,s)		TEInsert((s),strlen(s),(t))
#define TE_AUTOVIEW(t,b)	TEAutoView((b),(t))
#define TE_FINDOFFSET(t,p)	TEGetOffset((p),(t))
#define TE_FINDPT(t,n)		TEGetPoint((n),(t))
#define TE_CLICK(t,p,b)		TEClick((p),(b),(t))


/*  ************************************************************************/


#define SUBRS(x)								\
x("te-new",		te_new,		    RECT2_TE_FUNC,	TENew)		\
x("te-dispose",		te_dispose,	    TE_FUNC,		TEDispose)	\
x("te-idle",		te_idle,	    TE_FUNC,		TEIdle)		\
x("te-activate",	te_activate,	    TE_FUNC,		TEActivate)	\
x("te-deactivate",	te_deactivate,	    TE_FUNC,		TEDeactivate)	\
x("te-cut",		te_cut,		    TE_FUNC,		TECut)		\
x("te-copy",		te_copy,	    TE_FUNC,		TECopy)		\
x("te-paste",		te_paste,	    TE_FUNC,		TEPaste)	\
x("te-delete",		te_delete,	    TE_FUNC,		TEDelete)	\
x("te-insert",		te_insert,	    TESTRING_FUNC,	TE_INSERT)	\
x("te-select-view",	te_sel_view,	    TE_FUNC,		TESelView)	\
x("te-calc-text",	te_calc_text,	    TE_FUNC,		TECalText)	\
x("te-auto-view",	te_auto_view,	    TEBOOL_FUNC,	TE_AUTOVIEW)	\
x("te-click",		te_click,	    TEPTBOOL_FUNC,	TE_CLICK)	\
x("te-key",		te_key,		    TEINT_FUNC,		TE_KEY)		\
x("te-update",		te_update,	    TERECT_FUNC,	TE_UPDATE)	\
x("te-scroll",		te_scroll,	    TEINT2_FUNC,	TE_SCROLL)	\
x("te-pin-scroll",	te_pin_scroll,	    TEINT2_FUNC,	TE_PINSCROLL)	\
x("te-find-offset",	te_find_offset,	    TEPT_INT_FUNC,	TE_FINDOFFSET)	\
x("te-find-pt",		te_find_pt,	    TEINT_PT_FUNC,	TE_FINDPT)	\
x("text-box",		text_box,	    SPECIAL_FUNC,	SPECIAL_FUNC)	\


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_te)


/*  ************************************************************************/


SCM mac_text_box(SCM s_args)
{
  char *pc;
  Rect r;
  long n;

  GET_NEXT_STRING(pc, s_args, ARG1, s_mac_text_box);
  GET_NEXT_MACRECT(r, s_args, ARG2, s_mac_text_box);
  GET_NEXT_INT(n, s_args, ARG3, s_mac_text_box);
  TextBox(pc, strlen(pc), &r, n);

  return UNSPECIFIED;
}


/*  ************************************************************************/
