;; $Id: i960.md,v 1.11 89/11/30 23:31:43 mcg Exp $
;;
;;- Machine description for Intel 80960 chip for GNU C compiler
;;   Copyright (C) 1988 Free Software Foundation, Inc.
;;
;;   Contributed by Steven McGeady, Intel Corp.
;;   Additional work by Glenn Colon-Bonet, Jonathan Shapiro, Andy Wilson

;; This file is part of GNU CC.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU CC General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU CC, but only under the conditions described in the
;; GNU CC General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU CC so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.


(define_insn "i960_rcs_id"
  [(match_operand:SI 0 "" "")]
  "(0)"
  "@(#) $Id: i960.md,v 1.11 89/11/30 23:31:43 mcg Exp $";
  "C_NOP, R_NOP")

;; Compare instructions.
;; This controls RTL generation and register allocation.


;; - instruction definitions for branch-on-bit-set and clear insns
;; - mcg, 1/29/89

(define_insn ""
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
		[(sign_extract:SI (match_operand:SI 1 "register_operand" "d")
		      (const_int 1)
		      (match_operand:SI 2 "literal" "I"))
		(const_int 0)])
	 (label_ref (match_operand 3 "" ""))
	 (pc)))]
  ""
  "*{	/* CC_STATUS_INIT; */
	if(GET_CODE(operands[0]) == NE)
		return \"bbs%P3	%2,%1,%l3	# pat1a\";
	return \"bbc%P3	%2,%1,%l3	# pat 1a\";
   }"
"C_BR, R_BR")

(define_insn ""
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
		[(sign_extract:SI (match_operand:SI 1 "register_operand" "d")
		      (const_int 1)
		      (match_operand:SI 2 "literal" "I"))
		 (const_int 0)])
	 (pc)
	 (label_ref (match_operand 3 "" ""))))]
  ""
  "*{
	CC_STATUS_INIT;
	if (GET_CODE(operands[0]) == NE)
		return \"bbc%P3 %2,%1,%l3	# pat1b\";
	return \"bbs%P3 %2,%1,%l3	# pat1b\";
   }"
"C_BR, R_BR")

;;

;; (define_insn ""
;;   [(set (pc)
;; 	(if_then_else
;; 	 (match_operator 0 "eq_or_neq"
;; 		[(sign_extract:SI (match_operand:SI 1 "general_operand" "d")
;; 		      (const_int 1)
;; 		      (match_operand:SI 2 "literal" "I"))
;; 		 (const_int 0)])
;; 	 (pc)
;; 	 (label_ref (match_operand 3 "" ""))))]
;;   ""
;;   "*{
;; 	CC_STATUS_INIT;
;; 	if (GET_CODE(operands[0]) == NE)
;; 		return \"bbc	%2,%1,%l3	# pat4a\";
;; 	return \"bbs	%2,%1,%l3	# pat4a\";
;;    }"
;;"C_ALU, R_ALU")

(define_insn "bbs_bbc"
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
		[(and:SI (match_operand:SI 1 "register_operand" "d")
		     (match_operand:SI 2 "power2_operand" "n"))
		 (const_int 0)])
	 (label_ref (match_operand 3 "" ""))
	 (pc)))]
  ""
  "*{
	CC_STATUS_INIT;
	operands[2] = gen_rtx(CONST_INT, VOIDmode, bitpos(INTVAL(operands[2])));
	if (GET_CODE(operands[0]) == EQ)
		return \"bbc%P3	%2,%1,%l3	# pat2b\";
	return \"bbs%P3	%2,%1,%l3	# pat2b\";
   }"
"C_BR, R_BR")

(define_insn ""
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
		[(and:SI (match_operand:SI 1 "register_operand" "d")
		     (match_operand:SI 2 "power2_operand" "n"))
		 (const_int 0)])
	 (pc)
	 (label_ref (match_operand 3 "" ""))))]
  ""
  "*{
	CC_STATUS_INIT;
	operands[2] = gen_rtx (CONST_INT,VOIDmode,bitpos(INTVAL(operands[2])));
	if (GET_CODE(operands[0]) == EQ)
		return \"bbs%P3	%2,%1,%l3	# pat2a\";
	return \"bbc%P3	%2,%1,%l3	# pat2a\";
   }"
"C_BR, R_BR")

;;

(define_insn ""
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
		[(and:SI (match_operand:SI 1 "register_operand" "d")
		     (const_int 1))
		 (const_int 0)])
	 (label_ref (match_operand 2 "" ""))
	 (pc)))]
  ""
  "*{
	CC_STATUS_INIT;
	if (GET_CODE(operands[0]) == NE)
		return \"bbs%P3	0,%1,%l2	# pat5a\";
	return \"bbc%P3	0,%1,%l2	# pat5a\";
    }"
"C_BR, R_BR")

(define_insn ""
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
	      [(and:SI (match_operand:SI 1 "register_operand" "d")
	          (const_int 1))
	       (const_int 0)])
	 (pc)
	 (label_ref (match_operand 2 "" ""))))]
  ""
  "*{
	CC_STATUS_INIT;
	if (GET_CODE(operands[0]) == NE)
		return \"bbc%P3	0,%0,%l1	# pat5b\";
	return \"bbs%P3	0,%0,%l1	# pat5b\";
   }"
"C_BR, R_BR")

;; bit 31 optimizations

(define_insn ""
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
		[(and:SI (match_operand:SI 0 "register_operand" "d")
		     (not:SI (const_int -2)))
	     (const_int 0)])
	 (label_ref (match_operand 1 "" ""))
	 (pc)))]
  ""
  "*{
	CC_STATUS_INIT;
	if (GET_CODE(operands[0]) == NE)
		return \"bbs%P3	0,%1,%l2	# pat6a\";
	return \"bbc%P3	0,%1,%l2	# pat6a\";
   }"
"C_BR, R_BR")

(define_insn ""
  [(set (pc)
	(if_then_else
	 (match_operator 0 "eq_or_neq"
		[(and:SI (match_operand:SI 0 "register_operand" "d")
		     (not:SI (const_int -2)))
	     (const_int 0)])
	 (pc)
	 (label_ref (match_operand 1 "" ""))))]
  ""
  "*{
	CC_STATUS_INIT;
	if (GET_CODE(operands[0]) == NE)
		return \"bbc%P3	0,%0,%l1	# pat6b\";
	return \"bbs%P3	0,%0,%l1	# pat6b\";
    }"
"C_BR, R_BR")

(define_insn ""
  [(set (cc0)
	(and:SI (match_operand:SI 0 "arith_operand" "dI%")
		(match_operand:SI 1 "power2_operand" "n")))]
  ""
  "*
   {
	cc_status.flags |= CC_BITTEST;
	if (GET_CODE(operands[0]) == CONST_INT) {
		operands[0] = gen_rtx(CONST_INT, VOIDmode,
				bitpos(INTVAL(operands[0])));
		return \"chkbit	%0,%1	# c-pat 1\";
	}
	if (GET_CODE(operands[1]) == CONST_INT) {
		operands[1] = gen_rtx(CONST_INT, VOIDmode,
				bitpos(INTVAL(operands[1])));
		return \"chkbit	%1,%0	# c-pat 1\";
	}
	fatal(\"internal error: invalid operand to chkbit operation\");
  }"
"C_CMP, R_ALU"
)

(define_insn ""
  [(set (cc0)
	(and:SI (match_operand:SI 0 "arith_operand" "dI")
	  (ashift:SI (const_int 1) (match_operand:SI 1 "arith_operand" "dI"))))]
  ""
  "*{
	cc_status.flags |= CC_BITTEST;
	return \"chkbit	%1,%0	# c-pat 3a\";
  }"
"C_CMP, R_ALU"
)
(define_insn ""
  [(set (cc0)
	(and:SI
	  (ashift:SI (const_int 1) (match_operand:SI 0 "arith_operand" "dI"))
	  (match_operand:SI 1 "arith_operand" "dI")))]
  ""
  "*{
	cc_status.flags |= CC_BITTEST;
  	return \"chkbit	%0,%1	# c-pat 3b\";
  }"
"C_CMP, R_ALU"
)

(define_insn ""
  [(set (cc0)
	(compare (and:SI (match_operand:SI 0 "arith_operand" "dI%")
		(match_operand:SI 1 "power2_operand" "n"))
	       (match_dup 1)))]
  ""
  "*{
	operands[1] = gen_rtx(CONST_INT, VOIDmode,bitpos(INTVAL(operands[1])));
	cc_status.flags |= CC_BITTEST;
	return \"chkbit	%1,%0	# c-pat 4\";
  }"
"C_CMP, R_ALU"
)
(define_insn ""
  [(set (cc0)
	(compare (and:SI (match_operand:SI 0 "arith_operand" "dI%")
	  (ashift:SI (const_int 1) (match_operand:SI 1 "arith_operand" "dI")))
	  (ashift:SI (const_int 1) (match_dup 1))))]
  ""
  "*{
	cc_status.flags |= CC_BITTEST;
	return \"chkbit	%1,%0	# c-pat 5a\";
  }"
"C_CMP, R_ALU"
)
(define_insn ""
  [(set (cc0)
	(compare (and:SI (ashift:SI (const_int 1)
			(match_operand:SI 0 "arith_operand" "dI"))
		    (match_operand:SI 1 "arith_operand" "dI"))
	  (ashift:SI (const_int 1) (match_dup 0))))]
  ""
  "*{
	cc_status.flags |= CC_BITTEST;
	return \"chkbit	%1,%0	# c-pat 5b\";
  }"
"C_CMP, R_ALU"
)

(define_peephole
  [(set (cc0)
	(and:SI (match_operand:SI 0 "arith_operand" "dI%")
		(match_operand:SI 1 "power2_operand" "n")))
   (set (match_operand:SI 2 "general_operand" "=d")
	(eq (cc0) (const_int 0)))]
  "((bitpos(INTVAL(operands[1])) == 0) || (bitpos(INTVAL(operands[1])) == 31))"
  "*{
	/* case 'r = (i&1) == 0' becomes 'r = (~i)&1' */
	if (bitpos(INTVAL(operands[1])) == 0) {
		return \"andnot	%0,1,%2	# peep-1\";
	}
	/* case 'r = (i&(1<<31)) == 0' becomes 'r = i>>31' */
	if (bitpos(INTVAL(operands[1])) == 31) {
		return \"shro	31,%0,%2	# peep-1\;xor	%2,1,%2\";
	}
	fatal(\"internal error: invalid operand to single-bit test operation\");
   }"
)

(define_peephole
  [(set (cc0)
	(and:SI (match_operand:SI 0 "arith_operand" "dI%")
		(match_operand:SI 1 "power2_operand" "n")))
   (set (match_operand:SI 2 "general_operand" "=d")
	(ne (cc0) (const_int 0)))]
  "((bitpos(INTVAL(operands[1])) == 0) || (bitpos(INTVAL(operands[1])) == 31))"
  "*{
	if (bitpos(INTVAL(operands[1])) == 0) {
		return \"and	%0,1,%2	# peep-2\";
	}
	if (bitpos(INTVAL(operands[1])) == 31) {
		return \"shro	31,%0,%2	# peep-2\";
	}
	fatal(\"internal error: invalid operand to single-bit test operation\");
   }"
)

(define_peephole
  [(set (cc0)
	(compare (and:SI (match_operand:SI 0 "arith_operand" "dI%")
		(match_operand:SI 1 "power2_operand" "n"))
	       (match_dup 1)))
   (set (match_operand:SI 2 "general_operand" "=d")
	(eq (cc0) (const_int 0)))]
  "((bitpos(INTVAL(operands[1])) == 0) || (bitpos(INTVAL(operands[1])) == 31))"
  "*{
	/* case 'r = (i&1) == 1' becomes 'r = i&1' */
	if (bitpos(INTVAL(operands[1])) == 0) {
		return \"and	%0,1,%2	# peep-3\";
	}
	/* case 'r = (i&(1<<31)) == (1<<31)' becomes 'r = i>>31' */
	if (bitpos(INTVAL(operands[1])) == 31) {
		return \"shro	31,%0,%2	# peep-3\";
	}
	fatal(\"internal error: invalid operand to single-bit test operation\");
  }"
)

(define_peephole
  [(set (cc0)
	(compare (and:SI (match_operand:SI 0 "arith_operand" "dI%")
		(match_operand:SI 1 "power2_operand" "n"))
	       (match_dup 1)))
   (set (match_operand:SI 2 "general_operand" "=d")
	(ne (cc0) (const_int 0)))]
  "((bitpos(INTVAL(operands[1])) == 0) || (bitpos(INTVAL(operands[1])) == 31))"
  "*{
	/* case 'r = (i&1) != 1' becomes 'r = (~i)&1' */
	if (bitpos(INTVAL(operands[1])) == 0) {
		return \"andnot	%0,1,%2	# peep-3\";
	}
	/* case 'r = (i&(1<<31)) == (1<<31)' becomes 'r = !(i>>31)' */
	if (bitpos(INTVAL(operands[1])) == 31) {
		return \"shro	31,%0,%2	# peep-3\;xor	%2,1,%2\";
	}
	fatal(\"internal error: illegal operand to single-bit test operation\");
  }"
)

;; if ((i&0x100)a == 0) { ... }

(define_insn ""
  [(set (cc0)
	(compare (and:SI (match_operand:SI 0 "arith_operand" "=d")
			 (match_operand:SI 1 "mask_operand" "n"))
		 (const_int 0)))]
  ""
  "*{
	int s,e;

	if ((INTVAL(operands[1]) < 32) && (INTVAL(operands[2]) >= 0)) {
		return \"and	%1,%0,%0\;cmpi	0,%0\";
	}

	if (!bitstr(INTVAL(operands[1]),&s,&e)) {
		fatal(\"internal error: non-bitsring operand to bitstring compare\");
	}
	/* if it starts at 0, just mask top bits */
	if (s == 0) {
		operands[1] = gen_rtx(CONST_INT,VOIDmode, 31 - e);
		return \"shlo	%1,%0,%0\;cmpi	0,%0\";
	}
	/* if it starts at 31, just mask bottom bits */
	if (e == 31) {
		operands[1] = gen_rtx(CONST_INT,VOIDmode, s);
		return \"shro	%1,%0,%0\;cmpi	0,%0\";
	}
	/* otherwise mask both top and bottom */
	operands[1] = gen_rtx(CONST_INT,VOIDmode, 31 - e);
	output_asm_insn(\"shlo	%1,%0,%0\",operands);
	operands[1] = gen_rtx(CONST_INT,VOIDmode, 31 - e + s);
	output_asm_insn(\"shro	%1,%0,%0\",operands);
	return \"cmpi	0,%0\";
  }"
"C_ALUSEQ, R_ALU"
)


;;
;; this will probably never happen - bit serves as a reminder to make it work
;;
(define_insn ""
  [(set (cc0)
	(compare (match_operand:SI 0 "arith_operand" "dI")
	       (match_operand:SI 1 "arith_operand" "d")))
   (set (match_dup 1) (plus:SI (match_dup 1) (const_int 1)))]
  ""
  "* { register rtx x = next_branch_insn(insn);
	if(unsigned_condjump_p(x) || unsigned_condset_p(x))
		return \"cmpinco	%0,%1\";
	return \"cmpinci	%0,%1\";
  }"
"C_CMP, R_ALU"
)

(define_insn ""
  [(set (cc0)
	(compare (match_operand:SI 0 "arith_operand" "dI")
	       (match_operand:SI 1 "arith_operand" "d")))
   (set (match_dup 1) (minus:SI (match_dup 1) (const_int 1)))]
  ""
  "* { register rtx x = next_branch_insn(insn);
	if(unsigned_condjump_p(x) || unsigned_condset_p(x))
		return \"cmpdeco	%0,%1\";
	return \"cmpdeco	%0,%1\";
  }"
"C_CMP, R_ALU"
)

;;
;;

;; (define_insn "cmpqi"
;;   [(set (cc0)
;; 	(compare (match_operand:QI 0 "arith_operand" "dI")
;; 	       (match_operand:QI 1 "arith_operand" "dI")))]
;;   "(0)"
;;   "*
;;   { register rtx x = next_branch_insn(insn);
;;     if(unsigned_condjump_p(x) || unsigned_condset_p(x))
;;       return \"cmpo	%0,%1	# cmpqi\";
;;     return \"cmpi	%0,%1	# cmpqi\";
;;   }"
;; "C_CMP, R_ALU")
;;  
;; (define_insn "cmphi"
;;   [(set (cc0)
;; 	(compare (match_operand:HI 0 "arith_operand" "dI")
;; 	       (match_operand:HI 1 "arith_operand" "dI")))]
;;   "(0)"
;;   "*
;;   { register rtx x = next_branch_insn(insn);
;;     if(unsigned_condjump_p(x) || unsigned_condset_p(x))
;;       return \"cmpo	%0,%1	# cmphi\";
;;     return \"cmpi	%0,%1	# cmphi\";
;;   }"
;; "C_CMP, R_ALU")
  
(define_insn "cmpsi"
  [(set (cc0)
	(compare (match_operand:SI 0 "arith_operand" "dI")
	       (match_operand:SI 1 "arith_operand" "dI")))]
  ""
  "*
  { register rtx x = next_branch_insn(insn);
    if(unsigned_condjump_p(x) || unsigned_condset_p(x))
      return \"cmpo	%0,%1\";
    return \"cmpi	%0,%1\";
  }"
"C_CMP, R_ALU")

;;
;; strength-reduction and/or loop optimization seem to generate this
;;

(define_insn "cmpdf"
  [(set (cc0)
	(compare (match_operand:DF 0 "register_operand" "r")
		  (match_operand:DF 1 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "cmprl	%0,%1"
"C_FCMP, R_FCMP"
)

(define_insn "cmpsf"
  [(set (cc0)
	(compare (match_operand:SF 0 "register_operand" "r")
		  (match_operand:SF 1 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "cmpr	%0,%1"
"C_FCMP, R_FCMP"
)

;; We have to have these because cse can optimize the previous patterns
;; into this one.

(define_insn "tstqi"
  [(set (cc0)
	(match_operand:QI 0 "nonmemory_operand" "dIn"))]
  "(0)"
  "*
  { register rtx x = next_branch_insn(insn);
    if(unsigned_condjump_p(x) || unsigned_condset_p(x))
      return \"cmpo	%0,0	# tstqi-u\";
    return \"cmpi	%0,0	# tstqi-s\";
  }"
"C_CMP, R_ALU"
)
(define_insn "tsthi"
  [(set (cc0)
	(match_operand:HI 0 "nonmemory_operand" "dIn"))]
  "(0)"
  "*
  { register rtx x = next_branch_insn(insn);
    if(unsigned_condjump_p(x) || unsigned_condset_p(x))
      return \"cmpo	%0,0	# cmphi-u\";
    return \"cmpi	%0,0	# cmphi-s\";
  }"
"C_CMP, R_ALU"
)

(define_insn "tstsi"
  [(set (cc0)
	(match_operand:SI 0 "nonmemory_operand" "dIn"))]
  ""
  "*
  { register rtx x = next_branch_insn(insn);
    if(unsigned_condjump_p(x) || unsigned_condset_p(x))
      return \"cmpo	%0,0\";
    return \"cmpi	%0,0\";
  }"
"C_CMP, R_ALU"
)

;; Peepholes for compare and branches when first RTL is a test and not
;; a compare - both normal and inverted branches - mcg, 1/15/89



(define_peephole
  [(set (cc0)
	(match_operand:SI 0 "register_operand" "d"))
   (set (pc)
	(if_then_else (match_operator 1 "relop" [(cc0) (const_int 0)])
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "*{ /* CC_STATUS_INIT; */ return \"cmp%S1%B2%R1%P2	0,%0,%l2\"; }"
)

(define_peephole
  [(set (cc0)
	(match_operand:SI 0 "register_operand" "d"))
   (set (pc)
	(if_then_else (match_operator 1 "relop" [(cc0) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "*{ CC_STATUS_INIT; /* INVERTED */ return \"cmp%S1%B2%X1%P2	0,%0,%l2\"; }"
)


;; - Floating-point tests

(define_insn "tstdf"
  [(set (cc0)
	(match_operand:DF 0 "register_operand" "r"))]
  "TARGET_FLOAT"
  "cmprl	%0,0f0.0"
"C_FCMP, R_FCMP"
)

(define_insn "tstsf"
  [(set (cc0)
	(match_operand:SF 0 "register_operand" "r"))]
  "TARGET_FLOAT"
  "cmpr	%0,0f0.0"
"C_FCMP, R_FCMP"
)

;; templates to store result of condition
;; '1' is stored if condition is true
;; '0' is stored if condition is false
;; These should use predicate "general_operand", since
;; gcc seems to be creating mem references which uses these
;; templates.


(define_insn "seq"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(eq (cc0) (const_int 0)))]
  ""
  "*{	register rtx x = prev_cc0_insn(insn);
	if (chkbit_insn_p(x)) {
		return \"testno	%0	# testf\";
	}
	return \"teste	%0\";
    }"
"C_ALU, R_ALU"
)

(define_insn "sne"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(ne (cc0) (const_int 0)))]
  ""
  "*{	register rtx x = prev_cc0_insn(insn);
	if (chkbit_insn_p(x)) {
		return \"teste	%0	# testt\";
	}
	return \"testne	%0\";
    }"
"C_ALU, R_ALU"
)

(define_insn "sgt"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(gt (cc0) (const_int 0)))]
  ""
  "testg	%0"
"C_ALU, R_ALU"
)

(define_insn "sgtu"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(gtu (cc0) (const_int 0)))]
  ""
  "testg	%0"
"C_ALU, R_ALU"
)

(define_insn "slt"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(lt (cc0) (const_int 0)))]
  ""
  "testl	%0"
"C_ALU, R_ALU"
)

(define_insn "sltu"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(ltu (cc0) (const_int 0)))]
  ""
  "testl	%0"
"C_ALU, R_ALU"
)

(define_insn "sge"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(ge (cc0) (const_int 0)))]
  ""
  "testge	%0"
"C_ALU, R_ALU"
)

(define_insn "sgeu"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(geu (cc0) (const_int 0)))]
  ""
  "testge	%0"
"C_ALU, R_ALU"
)

(define_insn "sle"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(le (cc0) (const_int 0)))]
  ""
  "testle	%0"
"C_ALU, R_ALU"
)

(define_insn "sleu"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(leu (cc0) (const_int 0)))]
  ""
  "testle	%0"
"C_ALU, R_ALU"
)

;; These control RTL generation for conditional jump insns
;; and match them for register allocation.

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* {
	register rtx x = prev_cc0_insn(insn);
	if (chkbit_insn_p(x)) {
		return \"bf%P0	%l0	# bt/bf pat2\";
	}
	return \"be%P0	%l0\";
  }"
"C_BR, R_BR"
)

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "arith_operand" "dI")
	       (match_operand:SI 1 "arith_operand" "dI")))
   (set (pc)
	(if_then_else (match_operator 2 "relop" [(cc0) (const_int 0)])
		      (label_ref (match_operand 3 "" ""))
		      (pc)))]
  ""
  "*
  {
	rtx xops[2]; int vals[2]; unsigned int uvals[2];
	extern rtx operand_constant_p();
	/* CC_STATUS_INIT; */
	if ((xops[0] = operand_constant_p(insn,operands[0])) &&
	    (xops[1] = operand_constant_p(insn,operands[1]))) {
		uvals[0] = vals[0] = INTVAL(xops[0]);
		uvals[1] = vals[1] = INTVAL(xops[1]);

		switch(GET_CODE(operands[2])) {
		case EQ: return (vals[1] == vals[0] ? \"\" : \"b	%l3\");
		case NE: return (vals[1] != vals[0] ? \"\" : \"b	%l3\");
		case GT: return (vals[1] > vals[0] ? \"\" : \"b	%l3\");
		case GE: return (vals[1] >= vals[0] ? \"\" : \"b	%l3\");
		case LT: return (vals[1] < vals[0] ? \"\" : \"b	%l3\");
		case LE: return (vals[1] >= vals[0] ? \"\" : \"b	%l3\");
		case GTU:return (uvals[1] > uvals[0] ? \"\" : \"b	%l3\");
		case GEU:return (uvals[1] >= uvals[0] ? \"\" : \"b	%l3\");
		case LTU:return (uvals[1] < uvals[0] ? \"\" : \"b	%l3\");
		case LEU:return (uvals[1] <= uvals[0] ? \"\" : \"b	%l3\");

		}
	}
	if (GET_CODE(operands[1]) == CONST_INT)
		return \"cmp%S2%B2%R2%P3	%1,%0,%l3\";
	return \"cmp%S2%B2%C2%P3	%0,%1,%l3\";
  }")


(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* {
	register rtx x = prev_cc0_insn(insn);
	if (chkbit_insn_p(x)) {
		return \"be%P0	%l0	# bt/bf pat3\";	/* because chkbit checks for 1 */
	}
	return \"bne%P0	%l0\";
  }"
"C_BR, R_BR"
)



(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bg%P0	%l0"
"C_BR, R_BR"
)


(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bg%P0	%l0"
"C_BR, R_BR"
)


(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bl%P0	%l0"
"C_BR, R_BR"
)

(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bl%P0	%l0"
"C_BR, R_BR"
)


(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bge%P0	%l0"
"C_BR, R_BR"
)

(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "bge%P0	%l0"
"C_BR, R_BR"
)

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ble%P0	%l0"
"C_BR, R_BR"
)

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "ble%P0	%l0"
"C_BR, R_BR"
)


;; These match inverted jump insns for register allocation.
;;	- compare-and-branch peepholes added 1/15/89 - mcg

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "relop" [(cc0) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 1 "" ""))))]
  ""
  "* {
	if ((GET_CODE(operands[0]) == EQ) || (GET_CODE(operands[0]) == NE)) {
		register rtx x = prev_cc0_insn(insn);
		if (chkbit_insn_p(x)) {
			if (GET_CODE(operands[0]) == EQ)
				return \"bf	%l1	# bt/bf pat 1\";
			return \"be	%l1	# bt/bf pat 1\";
		}
	}
	/* INVERTED branch */
	return \"b%I0%P1	%l1\";
	
  }"
"C_BR, R_BR"
)

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "arith_operand" "dI")
	       (match_operand:SI 1 "arith_operand" "dI")))
   (set (pc)
	(if_then_else (match_operator 2 "relop" [(cc0) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 3 "" ""))))]
  ""
  "*
  {
	rtx xops[2]; int vals[2]; unsigned int uvals[2];
	extern rtx operand_constant_p();
	/* CC_STATUS_INIT; */
	if ((xops[0] = operand_constant_p(insn,operands[0])) &&
	    (xops[1] = operand_constant_p(insn,operands[1]))) {
		uvals[0] = vals[0] = INTVAL(xops[0]);
		uvals[1] = vals[1] = INTVAL(xops[1]);

		/* inverted conditions */
		switch(GET_CODE(operands[2])) {
		case EQ: return (vals[1] == vals[0] ? \"\" : \"b	%l3\");
		case NE: return (vals[1] != vals[0] ? \"\" : \"b	%l3\");
		case GT: return (vals[1] <= vals[0] ? \"\" : \"b	%l3\");
		case GE: return (vals[1] < vals[0] ? \"\" : \"b	%l3\");
		case LT: return (vals[1] >= vals[0] ? \"\" : \"b	%l3\");
		case LE: return (vals[1] > vals[0] ? \"\" : \"b	%l3\");
		case GTU:return (uvals[1] <= uvals[0] ? \"\" : \"b	%l3\");
		case GEU:return (uvals[1] < uvals[0] ? \"\" : \"b	%l3\");
		case LTU:return (uvals[1] >= uvals[0] ? \"\" : \"b	%l3\");
		case LEU:return (uvals[1] > uvals[0] ? \"\" : \"b	%l3\");

		}
	}
	if (GET_CODE(operands[1]) == CONST_INT)
		return \"cmp%S2%B2%X2%P3	%1,%0,%l3\";
	return \"cmp%S2%B2%I2%P3	%0,%1,%l3\";
  }")


;; Move instructions

(define_insn "swapsi"
  [(set (match_operand:SI 0 "register_operand" "+d")
	(match_operand:SI 1 "register_operand" "+d"))
   (set (match_dup 1) (match_dup 0))]
  ""
  "xor	%0,%1,%0\;xor	%1,%0,%1\;xor	%0,%1,%0")

;;
;; pipeline & st fifo optimization for memory swap
;;

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "d")
	(match_operand:SI 1 "memory_operand" "m"))
   (set (match_operand:SI 2 "register_operand" "d")
	(match_operand:SI 3 "memory_operand" "m"))
   (set (match_dup 3) (match_dup 0))
   (set (match_dup 1) (match_dup 2))]
  ""
  "ld	%1,%0\;ld	%3,%2\;st	%0,%3\;st	%2,%1"
"C_ALUSEQ, R_ALU"
)


;;
;; normal move instructions
;;

;;(define_insn ""
;;  [(set (match_operand:SI 0 "register_operand" "d")
;;	(match_operand:SI 1 "immediate_operand" "n"))]
;;  ""
;;  "ldconst	%1,%0"
;; "C_ALU, R_MOVE"
;;)

(define_insn "movsi"
  [(set (match_operand:SI 0 "reg_or_mem_operand" "=d,d,d,m")
	(match_operand:SI 1 "general_operand" "d,i,m,d"))]
  ""
  "*
{
  extern int optimize;

  switch(which_alternative)
  {
    case 0:
      return \"mov	%1,%0\";
    case 1:
      if ((INTVAL(operands[1]) < 32) && (INTVAL(operands[1]) >= 0))
	return \"mov	%1,%0\";
      return \"ldconst	%1,%0\";
    case 2:
      return \"ld	%1,%0\";
    case 3:
      return \"st	%1,%0\";
    default:
      fatal(\"internal error: bad argument to movsi\");
  }
}"
"C_MEM, R_MOVE"
)

(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand" "=d,d,d,m")
	(match_operand:HI 1 "general_operand" "d,i,m,d"))]
  ""
  "*
{
  extern int optimize;

  switch(which_alternative)
  {
    case 0:
      return \"mov	%1,%0\";
    case 1:
      if ((INTVAL(operands[1]) < 32) && (INTVAL(operands[1]) >= 0))
	return \"mov	%1,%0\";
      return \"ldconst	%1,%0\";
    case 2:
      return \"ldos	%1,%0\";
    case 3:
      return \"stos	%1,%0\";
    default:
      fatal(\"internal error: bad argument to movhi\");
  }
}"
"C_MEM, R_MOVE"
)


(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand" "=d,d,d,m")
	(match_operand:QI 1 "general_operand" "d,i,m,d"))]
  ""
  "*
{
  extern int optimize;

  switch(which_alternative)
  {
    case 0:
      return \"mov	%1,%0\";
    case 1:
      if ((INTVAL(operands[1]) < 32) && (INTVAL(operands[1]) >= 0))
	return \"mov	%1,%0\";
      return \"ldconst	%1,%0\";
    case 2:
      return \"ldob	%1,%0\";
    case 3:
      return \"stob	%1,%0\";
    default:
      fatal(\"internal error: bad argument to movqi\");
  }
}"
"C_MEM, R_MOVE"
)



(define_insn "movdi"
  [(set (match_operand:DI 0 "general_operand" "=d,d,m")
	(match_operand:DI 1 "general_operand" "dI,m,d"))]
  ""
  "*
{
  switch(which_alternative)
  {
    case 0:
      return \"movl	%1,%0\";
    case 1:
      return \"ldl	%1,%0\";
    case 2:
      return \"stl	%1,%0\";
    default:
      fatal(\"internal error: bad argument to movdi\");
  }
}"
"C_MEM, R_MOVE"
)

(define_insn "movti"
  [(set (match_operand:TI 0 "general_operand" "=d,d,m,!m")
	(match_operand:TI 1 "general_operand" "dI,m,d,!m"))]
  ""
  "*
{
  register rtx xoperands[3];
  register int r;

  switch(which_alternative)
  {
    case 0:
      return \"movq	%1,%0\";
    case 1:
      return \"ldq	%1,%0\";
    case 2:
      return \"stq	%1,%0\";
    case 3:
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	if ((r = find_unused_reg(TImode,0)) >= 0) {
		xoperands[2] = gen_rtx(REG,TImode,r);
		output_asm_insn(\"ldq	%1,%2\;stq	%2,%0\",xoperands);
		return \"\";
	}
	if (REGNO(operands[0]) == 8) {
		xoperands[2] = gen_rtx(REG,TImode,0);
	} else {
		xoperands[2] = gen_rtx(REG,TImode,8);
	}
	output_asm_insn(\"addo	16,sp,sp\;stq	%2,-16(sp)\",xoperands);
	output_asm_insn(\"ldq	%1,%2\;stq	%2,%0\",xoperands);
	output_asm_insn(\"ldq	-16(sp),%2\;subo	16,sp,sp\",xoperands);
	return \"\";
    default:
      fatal(\"internal error: bad argument to movti\");
  }
}"
"C_MEM3, R_MEM"
)




;; so that the `optimizer' does not convert registers which hold addresses
;; of static items back into the static address, which in this case defeats
;; the purpose of loading the register.  Sigh.....

(define_insn "force_register"
  [(set (match_operand:SI 0 "register_operand" "r")
        (if_then_else
         (eq (pc) (const_int 0))
         (match_dup 0)
         (match_dup 0)))]
  ""
  ""
"C_ALU, R_ALU"
)

;;
;; movstr
;;
;; args are dst, src, len, align
;;

(define_expand "movstrsi"
  [(parallel [(set (mem:BLK (match_operand:BLK 0 "general_operand" ""))
		   (mem:BLK (match_operand:BLK 1 "general_operand" "")))
	      (use (match_operand:SI 2 "nonmemory_operand" "dn"))
	      (use (match_operand:SI 3 "literal" "I"))])]
  "(TARGET_MOVSTR)"
  "
{
#define	MAX_INLINE_INSNS 4

	enum machine_mode mode;
	rtx dest = operands[0];
	rtx src = operands[1];
	rtx tmp, p;
	int i;
	char *lib;
	int align = INTVAL (operands[3]);
	rtx size_op = operands[2];
	int const_size = (GET_CODE (size_op) == CONST_INT);
	int size = (const_size) ? INTVAL (size_op) : ((unsigned) ~0) >> 1;
	struct {				/* final cleanup */
		rtx temp;
		enum machine_mode mode;
		int offset;
	} final[6];

	if (const_size && size <= 0) {
		warning(\"Invalid size (%d) passed to block move.\",
			INTVAL(size_op));
		FAIL;
	}

	/* Determine machine mode to do move in.  */
	if (align == 1)
		mode = QImode;
	else if (align == 2)
		mode = HImode;
	else if (align == 4)
		mode = SImode;
	else if (align == 8)
		mode = DImode;
	else if (align == 16)
		mode = TImode;
	else
		fatal (\"internal error: block move bad alignment % d\", align);

	/* compiler doesn't generate alignments greater than SI */
	/* so fudge it if appropriate */
	if (size > 16) {
		mode = TImode;
		align = 16;
	}

	/* See if we can do the move with straight line code.  */
	if (const_size && TARGET_MOVSTR &&
	    (move_by_pieces_ninsns(size,align) < MAX_INLINE_INSNS)) {
		move_by_pieces (operands[0], operands[1], size, align);
	} else {
	/* if we can't do it inline, generate a call to a custom */
	/* block move routine */

	blkmov:
		switch(align) {
		case 1:		/* only byte aligned */
			lib = \"__blkmov_b\";
			break;
		case 2:		/* short aligned */
			lib = \"__blkmov_s\";
			break;
		case 4:
			lib = \"__blkmov_i\";
			break;
		case 8:
			lib = \"__blkmov_d\";
			break;
		case 16:
			if (size == 31) 
				lib = \"__blkmov_q31\";
			else
				lib = \"__blkmov_q\";
			break;
		}
		dest = copy_to_mode_reg(Pmode,XEXP(operands[0],0));
		src = copy_to_mode_reg(Pmode,XEXP(operands[1],0));
		if (size != align && size != 1 && (size != 2 || align != 4)) {
			if (CONSTANT_P (XEXP(operands[0],0)))
				emit_insn (gen_force_register (dest));

			if (CONSTANT_P (XEXP(operands[1],0)))
				emit_insn (gen_force_register (src));
		}

		emit_library_call(gen_rtx(SYMBOL_REF, Pmode, lib), 0,
			 VOIDmode, 3, dest, Pmode, src, Pmode,
			 size_op, SImode);
	}

	DONE;
}"
)

(define_peephole
  [(set (subreg:SI (match_operand:DI 0 "memory_operand" "=m") 0)
	(match_operand:SI 1 "register_operand" "d"))
   (set (match_operand:SI 2 "register_operand" "=d")
	(match_operand:SI 3 "memory_operand" "m"))]
  "(!(MEM_VOLATILE_P(operands[0])) &&
	(rtx_equal_p(XEXP(operands[0],0),XEXP(operands[3],0))))"
  "*{
	register rtx next,pat;
	register int ok_to_delete_st = 0;
	register int ok_to_delete_mov = 0;

	next = insn;
	while ((next = next_real_insn(next)) != 0) {
		if (GET_CODE(next) != INSN) {
			break;
		}

		/* should also check for uses of op[1] & op[2] here */
		/* but we make the pessimistic assumption */
		if (reg_mentioned_p(XEXP(operands[3],0),next)) {
			pat = PATTERN(next);
			if ((GET_CODE(pat) == SET) &&
			    (GET_CODE((SET_DEST(pat))) != REG))
				ok_to_delete_st++;
			break;
		}
	}
	if (ok_to_delete_st) {
		if (REGNO(operands[1]) != REGNO(operands[2])) {
			return \"mov	%1,%2\";
		}
		return \"\";
	}
	if (REGNO(operands[1]) != REGNO(operands[2])) {
		return	\"st	%1,%0\;mov	%1,%2\";
	}
	return	\"st	%1,%0\";
  }"
)


;; Floating point move insns


(define_insn "movdf"
  [(set (match_operand:DF 0 "general_operand" "=r,d,m,!f,m")
	(match_operand:DF 1 "general_operand" "rG,m,d,m,!f"))]
  ""
  "*
{
  register rtx xoperands[3];
  register int r;

  switch(which_alternative)
  {
    case 0:
      if (TARGET_FLOAT)
        return \"movrl	%1,%0\";
      else
	return \"movl	%1,%0\";
    case 1:
      return \"ldl	%1,%0\";
    case 2:
      return \"stl	%1,%0\";
    case 3:
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	if ((r = find_unused_reg(DImode,0)) >= 0) {
		xoperands[2] = gen_rtx(REG,DImode,r);
		output_asm_insn(\"ldl	%1,%2\;movrl	%2,%0\",xoperands);
		return \"\";
	}
	if (REGNO(operands[0]) == 8) {
		xoperands[2] = gen_rtx(REG,DImode,0);
	} else {
		xoperands[2] = gen_rtx(REG,DImode,8);
	}

	output_asm_insn(\"addo	8,sp,sp\;stl	%2,-8(sp)\",xoperands);
	output_asm_insn(\"ldl	%1,%2\;movrl	%2,%0\",xoperands);
	output_asm_insn(\"ldl	-8(sp),%2\;subo	8,sp,sp\",xoperands);
	return \"\";
    case 4:
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	if ((r = find_unused_reg(DImode,0)) >= 0) {
		xoperands[2] = gen_rtx(REG,DImode,r);
		output_asm_insn(\"movrl	%1,%2\;stl	%2,%0\",xoperands);
		return \"\";
	}
	if (REGNO(operands[0]) == 8) {
		xoperands[2] = gen_rtx(REG,DImode,0);
	} else {
		xoperands[2] = gen_rtx(REG,DImode,8);
	}

	output_asm_insn(\"addo	8,sp,sp\;stl	%2,-8(sp)\",xoperands);
	output_asm_insn(\"movrl	%1,%2\;stl	%2,%0\",xoperands);
	output_asm_insn(\"ldl	-8(sp),%2\;subo	8,sp,sp\",xoperands);
	return \"\";
    default:
      fatal(\"internal error: bad argument to movdf\");
  }
}"
"C_MEM4, R_MOVE"
)

(define_insn "movsf"
  [(set (match_operand:SF 0 "general_operand" "=r,d,m,!f,m")
	(match_operand:SF 1 "general_operand" "rG,m,d,m,!f"))]
  ""
  "*
{
  register rtx xoperands[3];
  register int r;

  switch(which_alternative)
  {
    case 0:
      if (TARGET_FLOAT)
        return \"movr	%1,%0\";
      else
	return \"mov	%1,%0\";
    case 1:
      return \"ld	%1,%0\";
    case 2:
      return \"st	%1,%0\";
    case 3:
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	if ((r = find_unused_reg(SImode,0)) >= 0) {
		xoperands[2] = gen_rtx(REG,SImode,r);
		output_asm_insn(\"ld	%1,%2\;movr	%2,%0\",xoperands);
		return \"\";
	}
	if (REGNO(operands[0]) == 8) {
		xoperands[2] = gen_rtx(REG,SImode,0);
	} else {
		xoperands[2] = gen_rtx(REG,SImode,8);
	}

	output_asm_insn(\"addo	4,sp,sp\;st	%2,-4(sp)\",xoperands);
	output_asm_insn(\"ld	%1,%2\;movr	%2,%0\",xoperands);
	output_asm_insn(\"ld	-4(sp),%2\;subo	4,sp,sp\",xoperands);
	return \"\";
    case 4:
	xoperands[0] = operands[0];
	xoperands[1] = operands[1];
	if ((r = find_unused_reg(SImode,0)) >= 0) {
		xoperands[2] = gen_rtx(REG,SImode,r);
		output_asm_insn(\"movr	%1,%2\;st	%2,%0\",xoperands);
		return \"\";
	}
	if (REGNO(operands[0]) == 8) {
		xoperands[2] = gen_rtx(REG,SImode,0);
	} else {
		xoperands[2] = gen_rtx(REG,SImode,8);
	}

	output_asm_insn(\"addo	4,sp,sp\;st	%2,-4(sp)\",xoperands);
	output_asm_insn(\"movr	%1,%2\;st	%2,%0\",xoperands);
	output_asm_insn(\"ld	-4(sp),%2\;subo	4,sp,sp\",xoperands);
	return \"\";
    default:
      fatal(\"internal error: bad argument to movsf\");
  }
}"
"C_MEM4, R_MOVE"
)

;; lda moved after add/sub so it isn't used instead


;;- truncation instructions
(define_insn "truncsiqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm")
	(truncate:QI
	 (match_operand:SI 1 "register_operand" "d")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"stob %1,%0\";
  return \"mov %1,%0\";
}"
"C_MEM, R_MOVE"
)


(define_insn "trunchiqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm")
	(truncate:QI
	 (match_operand:HI 1 "register_operand" "d")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"stob %1,%0\";
  return \"mov %1,%0\";
}"
"C_MEM, R_MOVE"
)

(define_insn "truncsihi2"
  [(set (match_operand:HI 0 "general_operand" "=dm")
	(truncate:HI
	 (match_operand:SI 1 "register_operand" "d")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"stos %1,%0\";
  return \"mov %1,%0\";
}"
"C_MEM, R_MOVE"
)

;;- zero extension instructions


;;
;; mixed-mode moves - with and without sign-extension & zero-extension
;;


;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
	(zero_extend:SI
	 (match_operand:HI 1 "reg_or_mem_operand" "d,m")))]
  ""
  "* {
    if (GET_CODE(operands[1]) == REG || GET_CODE(operands[1]) == SUBREG) {
	return \"shlo	16,%1,%0\;shro	16,%0,%0	# zero-ext hi->si\";
    } else {
	return \"ldos	%1,%0\";
    } 
  }"
"C_ALU2, R_ALU")

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=d,d")
	(zero_extend:HI
	 (match_operand:QI 1 "reg_or_mem_operand" "d,m")))]
  ""
  "* {
    if (GET_CODE(operands[1]) == REG || GET_CODE(operands[1]) == SUBREG) {
	return \"shlo	24,%1,%0\;shro	24,%0,%0	# zero-ext qi->hi\";
    } else {
	return \"ldob %1,%0\";
    }
  }"
"C_ALU2, R_ALU"
)

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
	(zero_extend:SI
	 (match_operand:QI 1 "reg_or_mem_operand" "d,m")))]
  ""
  "* {
    if (GET_CODE(operands[1]) == REG || GET_CODE(operands[1]) == SUBREG) {
	return \"shlo	24,%1,%0\;shro	24,%0,%0	# zero-ext qi->si\";
    } else {
	return \"ldob %1,%0\";
    }
}"
"C_ALU2, R_ALU")

;;- sign extension instructions
;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.


(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=d,d")
	(sign_extend:HI
	 (match_operand:QI 1 "reg_or_mem_operand" "d,m")))]
  ""
  "* {
  if (GET_CODE(operands[1]) == REG || GET_CODE(operands[1]) == SUBREG) {
    return \"shli	24,%1,%0\;shri	24,%0,%0	# sign-ext qi->hi\";
  } else {
  return \"ldib	%1,%0\";
  } 
}"
"C_ALU2, R_ALU")

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
	(sign_extend:SI
	 (match_operand:HI 1 "reg_or_mem_operand" "d,m")))]
  ""
  "* {
  if (GET_CODE(operands[1]) == REG || GET_CODE(operands[1]) == SUBREG) {
    return \"shli	16,%1,%0\;shri	16,%0,%0	# sign-ext qi->hi\";
  } else {
  return \"ldis	%1,%0\";
  } 
}"
"C_ALU2, R_ALU")

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=d,d")
	(sign_extend:SI
	 (match_operand:QI 1 "reg_or_mem_operand" "d,m")))]
  ""
  "* {
  if (GET_CODE(operands[1]) == REG || GET_CODE(operands[1]) == SUBREG) {
    return \"shli	24,%1,%0\;shri	24,%0,%0	# sign-ext qi->si\";
  } else {
    return \"ldib	%1,%0\";
  } 
}"
"C_ALU2, R_ALU")


;; Special patterns for optimizing bit-field instructions.


;; (define_insn ""
;;   [(set (match_operand:SI 0 "register_operand" "=d")
;;         (zero_extract:SI (match_operand:SI 1 "memory_operand" "m")
;;                          (match_operand:SI 2 "arith_operand" "I")
;;                          (match_operand:SI 3 "arith_operand" "I")))]
;;   "((INTVAL(operands[2]) + INTVAL(operands[3])) < 32)"
;;   "*{
;; 	register int nbytes, nbits, nrbits, noff;
;; 
;; 	/* operand[2] is width, operand[3] is starting bit */
;; 
;; 	nbits = (INTVAL(operands[2])+INTVAL(operands[3]));
;; 	nbytes = nbits/BITS_PER_UNIT;
;; 	nrbits = nbits%BITS_PER_UNIT;
;; 	noff = INTVAL(operands[3]);
;; 	if (nrbits != 0) {
;; 		nbytes += 1;
;; 	}
;; 	switch(nbytes) {
;; 	case 1:
;; 		output_asm_insn(\"ldob	%1,%0\",operands);
;; 		if ((INTVAL(operands[2]) < 6) && (noff == 0)) {
;; 			operands[2] = gen_rtx(CONST_INT,VOIDmode,
;; 					(1<<INTVAL(operands[2]))-1);
;; 			return \"and	%2,%0,%0\";
;; 		}
;; 		break;
;; 	case 2:
;; 		output_asm_insn(\"ldos	%1,%0\",operands);
;; 		break;
;; 	case 3:
;; 	case 4:
;; 		output_asm_insn(\"ld	%1,%0\",operands);
;; 		break;
;; 	default: abort();
;; 	}
;; 	if (nrbits) {
;; 		if (noff != 0 && (INTVAL(operands[2]) < 6)) {
;; 			if (INTVAL(operands[3]) > 0) {
;; 				output_asm_insn(\"shro	%3,%0,%0\",operands);
;; 			}
;; 			operands[2] = gen_rtx(CONST_INT,VOIDmode,
;; 					(1<<INTVAL(operands[2]))-1);
;; 			return \"and	%2,%0,%0\";
;; 		}
;; 		operands[2] = gen_rtx(CONST_INT, VOIDmode,
;; 				32 - (INTVAL(operands[2]) + noff));
;; 		if (INTVAL(operands[2]) > 0) {
;; 			output_asm_insn(\"shlo	%2,%0,%0\",operands);
;; 		}
;; 		operands[2] = gen_rtx(CONST_INT, VOIDmode,
;; 				32 - INTVAL(operands[2]));
;; 		if (INTVAL(operands[2]) > 0) {
;; 			output_asm_insn(\"shro	%2,%0,%0\",operands);
;; 		}
;; 	}
;; 	return \"\";
;;   }"
;; )
;; 
;; 
;; (define_insn ""
;;   [(set (match_operand:SI 0 "register_operand" "=d")
;;         (sign_extract:SI (match_operand:SI 1 "memory_operand" "m")
;;                          (match_operand:SI 2 "arith_operand" "I")
;;                          (match_operand:SI 3 "arith_operand" "I")))]
;;   ""
;;   "*{
;; 	register int nbytes, nbits, nrbits, noff;
;; 
;; 	/* operand[2] is width, operand[3] is starting bit */
;; 
;; 	nbits = (INTVAL(operands[2])+INTVAL(operands[3]));
;; 	nbytes = nbits/BITS_PER_UNIT;
;; 	nrbits = nbits%BITS_PER_UNIT;
;; 	noff = INTVAL(operands[3]);
;; 	if (nrbits != 0) {
;; 		nbytes += 1;
;; 	}
;; 	switch(nbytes) {
;; 	case 1:
;; 		output_asm_insn(\"ldib	%1,%0\",operands);
;; 		break;
;; 	case 2:
;; 		output_asm_insn(\"ldis	%1,%0\",operands);
;; 		break;
;; 	case 3:
;; 	case 4:
;; 		output_asm_insn(\"ld	%1,%0\",operands);
;; 		break;
;; 	default: abort();
;; 	}
;; 	if (nrbits) {
;; 		operands[2] = gen_rtx(CONST_INT, VOIDmode,
;; 				32 - (INTVAL(operands[2]) + noff));
;; 		output_asm_insn(\"shli	%2,%0,%0\",operands);
;; 		operands[2] = gen_rtx(CONST_INT, VOIDmode,
;; 				32 - INTVAL(operands[2]));
;; 		return \"shri	%2,%0,%0\";
;; 	}
;; 	return \"\";
;;   }"
;; )


;; operand 2 is bitstring length, operand 3 is first bit position

(define_insn "extzv"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (zero_extract:SI (match_operand:SI 1 "register_operand" "d")
                         (match_operand:SI 2 "arith_operand" "I")
                         (match_operand:SI 3 "arith_operand" "I")))]
  "(1) /* ((INTVAL(operands[2]) + INTVAL(operands[3])) <= 32) */"
  "*{
	rtx xoperands[6];
	register unsigned long t;

	xoperands[0] = operands[0]; xoperands[1] = operands[1];
	xoperands[2] = operands[2]; xoperands[3] = operands[3];

	if ((INTVAL(operands[3]) == 0) && (INTVAL(operands[2]) < 6)) {
		/* create a mask %2 bits long offset to loc %3 */
		t = ((1<<(INTVAL(operands[2])))-1) << INTVAL(operands[3]);
		if (t > 31)
			fatal(\"internal error: bad constant computation in extzv\");
		xoperands[4] = gen_rtx(CONST_INT,VOIDmode,t);
		output_asm_insn(\"and	%4,%1,%0	# extzv(%1,%2,%3)\",
			xoperands);
		return \"\";
	}

	/* [4] is amount to left shift to put MSB in sign bit */
	xoperands[4] = gen_rtx(CONST_INT,VOIDmode,
			32 - (INTVAL(operands[2]) + INTVAL(operands[3])));
	/* [5] is amount to right shift to put LSB in bit 0 after above shift */
	xoperands[5] = gen_rtx(CONST_INT,VOIDmode, 32 - INTVAL(operands[2]));

	if ((INTVAL(xoperands[4]) > 31) || (INTVAL(xoperands[5]) > 31) ||
	    (INTVAL(xoperands[4]) < 0) || (INTVAL(xoperands[5]) < 0)) {
		fatal(\"internal error: operand longer than SImode in extzv\");
	}

	if (INTVAL(xoperands[4])) {
		output_asm_insn(\"shlo	%4,%1,%0	# extzv(%1,%2,%3)\",
			xoperands);
	}
	if (INTVAL(xoperands[5])) {
		output_asm_insn(\"shro	%5,%0,%0	# extzv(%1,%2,%3)\",
			xoperands);
	}
	return \"\";
  }"
"C_ALU2, R_ALU"
)
(define_insn "extv"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (sign_extract:SI (match_operand:SI 1 "register_operand" "d")
                         (match_operand:SI 2 "arith_operand" "I")
                         (match_operand:SI 3 "arith_operand" "I")))]
  "(1) /* ((INTVAL(operands[2]) + INTVAL(operands[3])) <= 32) */"
  "*{
	rtx xoperands[6];

	xoperands[0] = operands[0]; xoperands[1] = operands[1];
	xoperands[2] = operands[2]; xoperands[3] = operands[3];

	xoperands[4] = gen_rtx(CONST_INT,VOIDmode,
			32 - (INTVAL(operands[2]) + INTVAL(operands[3])));
	xoperands[5] = gen_rtx(CONST_INT,VOIDmode, 32 - INTVAL(operands[2]));

	if ((INTVAL(xoperands[4]) > 31) || (INTVAL(xoperands[5]) > 31) ||
	    (INTVAL(xoperands[4]) < 0) || (INTVAL(xoperands[5]) < 0)) {
		fatal(\"internal error: operand longer than SImode in extv\");
	}

	if (INTVAL(xoperands[4])) {
		output_asm_insn(\"shli	%4,%1,%0	# extv(%1,%2,%3)\",
			xoperands);
	}
	if (INTVAL(xoperands[5])) {
		output_asm_insn(\"shri	%5,%0,%0	# extv(%1,%2,%3)\",
			xoperands);
	}
	return \"\";
  }"
"C_ALU2, R_ALU"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; insv - op[1] is size, op[2] is pos

(define_insn ""
 [(set (zero_extract:SI (match_operand 0 "register_operand" "d")
			 (const_int 1)
			 (match_operand:SI 2 "literal" "I"))
	(match_operand:SI 3 "arith_operand" "dI"))]
 ""
 "*{
	CC_STATUS_INIT;
	return \"chkbit	0,%3\;alterbit	%2,%0\";
 }"
"C_ALU2, R_ALU"
)

(define_expand "insv"
 [(set (zero_extract:SI (match_operand 0 "register_operand" "d")
			 (match_operand:SI 1 "literal" "I")
			 (match_operand:SI 2 "literal" "I"))
	(match_operand:SI 3 "arith_operand" "dI"))]
 ""
  "{
	register int size = INTVAL(operands[1]);
	register int pos = INTVAL(operands[2]);
	if ((memory_operand(operands[0],QImode) ||
	     memory_operand(operands[0],HImode) ||
	     memory_operand(operands[0],SImode) ||
	     memory_operand(operands[0],DImode)) &&
	    ((size == 8) || (size == 16)) && ((size % pos) == 0))  {
		/* an acceptable memory operand */
		operands[0] = adj_offsettable_operand(operands[0],
				INTVAL(operands[2])/8);
		emit_insn(gen_rtx(SET,(size == 8) ? QImode : HImode,
				operands[0],operands[3]));
		DONE;
	}
	FAIL;
  }"
)

(define_insn ""
 [(set (zero_extract:SI (match_operand:SI 0 "register_operand" "d")
			 (match_operand:SI 1 "arith_operand" "&dI")
			 (match_operand:SI 2 "literal" "I"))
	(match_operand:SI 3 "arith_operand" "dI"))]
  "(INTVAL(operands[2]) == 0)"
  "*{
	if ((GET_CODE(operands[1]) == CONST_INT) && (INTVAL(operands[1]) < 6)) {
		operands[1] = gen_rtx(CONST_INT,VOIDmode,
				(1<<INTVAL(operands[1]))-1);
		return \"modify	%1,%3,%0\";
	}
	return \"setbit	%1,0,%1\;subo	1,%1,%1\;modify	%1,%3,%0\";
  }"
"C_BITMODSCAN, R_ALU"
)

(define_insn ""
 [(set (zero_extract:SI (match_operand:SI 0 "register_operand" "d")
			 (match_operand:SI 1 "arith_operand" "&d")
			 (match_operand:SI 2 "literal" "I"))
	(match_operand:SI 3 "arith_operand" "&d"))]
  "(INTVAL(operands[1]) + INTVAL(operands[2]) <= 32)"
  "*{
	return \"setbit	%1,0,%1\;subo	1,%1,%1\;shlo	%2,%1,%1\;shlo	%2,%3,%3\;modify	%1,%3,%0\";
  }"
"C_BITMODSCAN, R_ALU"
)
;; don't have signed bitfields, let GCC figure out the shifts


;; Conversions between float and double.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f,d")
	(float_extend:DF
	 (match_operand:SF 1 "register_operand" "d,f")))]
  "TARGET_FLOAT"
  "*
  { if (which_alternative == 0)
      return \"movr	%1,%0\";
    return \"movrl	%1,%0\";
  } "
"C_FLOAT25, R_ALU"
)

;; template for extending sf->df where both are in general regs.
;; this is not part of the previous pattern because it is slow
;; and requires the use of fp0
;(define_insn ""
;  [(set (match_operand:DF 0 "register_operand" "!=d")
;	(float_extend:DF
;	 (match_operand:SF 1 "register_operand" "d")))
;   (clobber (reg:DF 32))]
;  ""
;  "movr	%1,fp0\;movrl	fp0,%0")


(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "register_operand" "=d")
	(float_truncate:SF
	 (match_operand:DF 1 "register_operand" "f")))]
  "TARGET_FLOAT"
  "movr	%1,%0"
"C_FLOAT25, R_ALU")


;; Conversion between fixed point and floating point.

;; (define_insn ""
;;   [(set (match_operand:SF 0 "register_operand" "=df")
;; 	(float:SF (const_int 0)))]
;;   "TARGET_FLOAT"
;;   "movr	0f0.0,%0"
;; "C_FLOAT25, R_ALU")
;; 
;; (define_insn ""
;;   [(set (match_operand:SF 0 "register_operand" "=df")
;; 	(float:SF (const_int 1)))]
;;   "TARGET_FLOAT"
;;   "movr	0f1.0,%0"
;; "C_FLOAT25, R_ALU")

(define_insn "floatsisf2"
  [(set (match_operand:SF 0 "register_operand" "=df")
	(float:SF (match_operand:SI 1 "register_operand" "d")))]
  "TARGET_FLOAT"
  "cvtir	%1,%0"
"C_FLOAT25, R_ALU")

;; (define_insn ""
;;   [(set (match_operand:DF 0 "register_operand" "=df")
;; 	(float:DF (const_int 0)))]
;;   "TARGET_FLOAT"
;;   "movrl	0f0.0,%0"
;; "C_FLOAT25, R_ALU")
;; 
;; (define_insn ""
;;   [(set (match_operand:DF 0 "register_operand" "=df")
;; 	(float:DF (const_int 1)))]
;;   "TARGET_FLOAT"
;;   "movrl	0f1.0,%0"
;; "C_FLOAT25, R_ALU")

;; this actually converts the integer to extended format in the fpregs
;; to convert to double in the general regs:
;;	cvtir	%1,%fptmp
;;	movrl	%fptmp,%0

(define_insn "floatsidf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(float:DF (match_operand:SI 1 "register_operand" "d")))]
  "TARGET_FLOAT"
  "cvtir	%1,%0"
"C_FLOAT25, R_ALU")

;; Convert a float to an actual integer.
;; Truncation is performed as part of the conversion.

(define_insn "fix_truncsfsi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(fix:SI (fix:SF (match_operand:SF 1 "register_operand" "df"))))]
  "TARGET_FLOAT"
  "cvtzri	%1,%0"
"C_FLOAT25, R_ALU")

(define_insn "fixuns_truncsfsi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(unsigned_fix:SI (fix:SF (match_operand:SF 1 "register_operand" "df"))))]
  "TARGET_FLOAT"
  "cvtzri	%1,%0"

"C_FLOAT25, R_ALU")

(define_insn "fix_truncdfsi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(fix:SI (fix:DF (match_operand:DF 1 "register_operand" "f"))))]
  "TARGET_FLOAT"
  "cvtzri	%1,%0"
"C_FLOAT25, R_ALU")

(define_insn "fixuns_truncdfsi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(unsigned_fix:SI (fix:DF (match_operand:DF 1 "register_operand" "f"))))]
  "TARGET_FLOAT"
  "cvtzri	%1,%0"
"C_FLOAT25, R_ALU")

;;- arithmetic instructions

;; - fix addsi and subsi so that they turn operations on negative
;; - constants into the other operation

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(minus:SI (match_dup 0)
		  (match_operand:SI 1 "arith_operand" "Ind")))]
  "((REGNO(operands[0]) == STACK_POINTER_REGNUM) ||
    (REGNO(operands[0]) == ARG_POINTER_REGNUM))"
  "*{
     if (GET_CODE(operands[1]) == CONST_INT) {
	 if ((INTVAL(operands[1]) < 0 &&
	      INTVAL(operands[1]) > -32)) {
		return \"addo	%0,%n1,%0\";
	}
	if ((INTVAL(operands[1]) < 32) && (INTVAL(operands[1]) >= 0)) {
		return \"subo	%1,%0,%0\";
	}
	return \"lda	%n1(%0),%0\";
    }
    return \"subo	%1,%0,%0\";
   }"
"C_ALU, R_ALU"
)

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(minus:SI (match_operand:SI 1 "signed_arith_operand" "dK")
		  (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "*
   { if ((GET_CODE(operands[1]) == CONST_INT) &&
	 (INTVAL(operands[1]) < 0 &&
	    INTVAL(operands[1]) > -32)) {
		return \"addi	%2,%n1,%0\";
	}
     return \"subi	%2,%1,%0\";
  }"
"C_ALU, R_ALU"
)

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(plus:SI (match_dup 0)
		  (match_operand:SI 1 "arith_operand" "Ind")))]
  "((REGNO(operands[0]) == STACK_POINTER_REGNUM) ||
    (REGNO(operands[0]) == ARG_POINTER_REGNUM))"
  "*{
     if (GET_CODE(operands[1]) == CONST_INT) {
	 if ((INTVAL(operands[1]) < 0 &&
	      INTVAL(operands[1]) > -32)) {
		return \"subo	%n1,%0,%0\";
	}
	if ((INTVAL(operands[2]) < 32) && (INTVAL(operands[2]) >= 0))
		return \"addo	%1,%0,%0\";
	return \"lda	%1(%0),%0\";
    }
    return \"addo	%1,%0,%0\";
   }"
"C_ALU, R_ALU"
)


(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(plus:SI (match_operand:SI 1 "signed_arith_operand" "%dK")
		 (match_operand:SI 2 "signed_arith_operand" "dK")))]
  ""
  "*
   { if ((GET_CODE(operands[2]) == CONST_INT) &&
	 (INTVAL(operands[2]) < 0 &&
	    INTVAL(operands[2]) > -32)) {
		return \"subi	%n2,%1,%0\";
     }
     if ((GET_CODE(operands[1]) == CONST_INT) &&
	 (INTVAL(operands[1]) < 0 &&
	    INTVAL(operands[1]) > -32)) {
		return which_alternative ? \"subo	%n1,%2,%0\"
					 : \"subi	%n1,%2,%0\";
     }
     return which_alternative ? \"addo	%1,%2,%0\"
				: \"addi	%1,%2,%0\";
   }"
"C_ALU, R_ALU"
)

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(mult:SI (match_operand:SI 1 "arith_operand" "%dI")
		 (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "muli	%1,%2,%0"
"C_MUL, R_ALU"
)

(define_insn "umulsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(umult:SI (match_operand:SI 1 "arith_operand" "%dI")
		  (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "mulo	%1,%2,%0"
"C_MUL, R_ALU"
)

;; This goes after the move/add/sub/mul instructions  
;; because those instructions are better when they apply.
(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(match_operand:SI 1 "address_operand" "p"))]
  ""
  "lda	%a1,%0"
"C_ALU, R_ALU")


;; this will never be selected because of an "optimization" that GCC does
;;
;; (define_insn ""
;;   [(set (match_operand:SI 0 "register_operand" "=d")
;;         (div:SI (match_operand:SI 1 "arith_operand" "dI")
;;                 (match_operand:SI 2 "power2_operand" "nI")))]
;;   ""
;;   "*{
;; 	operands[2] = gen_rtx(CONST_INT, VOIDmode,bitpos(INTVAL(operands[2])));
;; 	return \"shrdi	%2,%1,%0\";
;;   }"

(define_insn "divsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (div:SI (match_operand:SI 1 "arith_operand" "dI")
                (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "divi	%2,%1,%0"
"C_DIV, R_ALU")

(define_insn "udivsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (udiv:SI (match_operand:SI 1 "arith_operand" "dI")
                (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "divo	%2,%1,%0"
"C_DIV, R_ALU")

;; should we use the modi instruction here????
(define_insn "modsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (mod:SI (match_operand:SI 1 "arith_operand" "dI")
                (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "remi	%2,%1,%0"
"C_DIV, R_ALU")

(define_insn "umodsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
        (umod:SI (match_operand:SI 1 "arith_operand" "dI")
                (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "remo	%2,%1,%0"
"C_DIV, R_ALU")

;;- and instructions (with compliment also)			   


;; - new pattern to catch chkbit opportunities - mcg 1/29/89

(define_insn ""
 [(set (match_operand:SI 0 "general_operand" "=d")
	(eq (and:SI (match_operand:SI 1 "register_operand" "d")
		(match_operand:SI 2 "power2_operand" "n"))
	   (const_int 0)))]
 ""
 "*{
	operands[2] = gen_rtx(CONST_INT,VOIDmode,bitpos(INTVAL(operands[2])));
	if (INTVAL(operands[2]) == 0) {
		return \"notand	1,%1,%0\";
	}
	if (INTVAL(operands[2]) == 31) {
		return \"shro	31,%1,0\;xor	1,%0,%0\";
	}
	CC_STATUS_INIT;
	return \"chkbit	%2,%1	# s-pat 1\;testno	%0	# testf\";
  }"
"C_ALU, R_ALU"
)

(define_insn ""
 [(set (match_operand:SI 0 "general_operand" "=d")
	(ne (and:SI (match_operand:SI 1 "register_operand" "d")
		(match_operand:SI 2 "power2_operand" "n"))
	   (const_int 0)))]
 ""
 "*{
	operands[2] = gen_rtx(CONST_INT,VOIDmode,bitpos(INTVAL(operands[2])));
	if (INTVAL(operands[2]) == 0) {
		return \"and	1,%1,%0\";
	}
	if (INTVAL(operands[2]) == 31) {
		return \"shro	31,%1,0\";
	}
	CC_STATUS_INIT;
	return \"chkbit	%2,%1	# s-pat 2\;teste	%0	# testt\";
  }"
"C_ALU, R_ALU"
)

(define_insn ""
 [(set (match_operand:SI 0 "general_operand" "=d")
	(eq (and:SI (match_operand:SI 1 "register_operand" "d")
	    (ashift:SI (const_int 1) (match_operand:SI 2 "arith_operand" "dI")))
	   (const_int 0)))]
 ""
 "*{
	operands[2] = gen_rtx(CONST_INT,VOIDmode,bitpos(INTVAL(operands[2])));
	if (INTVAL(operands[2]) == 0) {
		return \"notand	1,%1,%0\";
	}
	if (INTVAL(operands[2]) == 31) {
		return \"shro	31,%1,0\;xor	1,%0,%0\";
	}
	CC_STATUS_INIT;
	return \"chkbit	%2,%1	# s-pat 3\;testno	%0	# testf\";
  }"
"C_ALU, R_ALU"
)

(define_insn ""
 [(set (match_operand:SI 0 "general_operand" "=d")
	(ne (and:SI (match_operand:SI 1 "register_operand" "d")
	   (ashift:SI (const_int 1) (match_operand:SI 2 "arith_operand" "dI")))
	   (const_int 0)))]
 ""
 "*{
	CC_STATUS_INIT;
	return \"chkbit	%2,%1	# s-pat 4\;teste	%0	# testt\";
  }"
"C_ALU, R_ALU"
)

(define_insn ""
 [(set (match_operand:SI 0 "general_operand" "=d")
	(eq (and:SI (match_operand:SI 1 "register_operand" "d")
		(match_operand:SI 2 "mask_operand" "n"))
	   (const_int 0)))]
 ""
 "*{

	int s,e;

	CC_STATUS_INIT;
	if ((INTVAL(operands[2]) < 32) && (INTVAL(operands[2]) >= 0)) {
		return \"and	%2,%1,%0\;cmpi	0,%0\;teste	%0\";
	}
	if (!bitstr(INTVAL(operands[2]),&s,&e)) {
		fatal(\"internal error: non-bitstring operand to bitstring and\");
	}
	if (s == 0) {
		operands[2] = gen_rtx(CONST_INT,VOIDmode, 31 - e);
		return \"shlo	%2,%1,%0\;cmpi	0,%0\;teste	%0\";
	}
	if (e == 31) {
		operands[2] = gen_rtx(CONST_INT,VOIDmode, s);
		return \"shro	%2,%1,%0\;cmpi	0,%0\;teste	%0\";
	}
	operands[2] = gen_rtx(CONST_INT,VOIDmode, 31 - e);
	output_asm_insn(\"shlo	%2,%1,%0\",operands);
	if (e-s != 31) {
		operands[2] = gen_rtx(CONST_INT,VOIDmode, 31 - (e-s));
		output_asm_insn(\"shro	%2,%0,%0\",operands);
	}
	return \"cmpi	0,%0\;teste	%0\";
  }"
"C_ALUSEQ, R_ALU"
)

(define_insn ""
 [(set (match_operand:SI 0 "general_operand" "=d")
	(ne (and:SI (match_operand:SI 1 "register_operand" "d")
		(match_operand:SI 2 "mask_operand" "n"))
	   (const_int 0)))]
 ""
 "*{
	int s,e;

	CC_STATUS_INIT;
	if ((INTVAL(operands[2]) < 32)  && (INTVAL(operands[2]) >= 0)) {
		return \"and	%2,%1,%0\;cmpi	0,%0\;testne	%0\";
	}
	if (!bitstr(INTVAL(operands[2]),&s,&e)) {
		fatal(\"internal error: non-bitstring operand to bitstring and\");
	}
	if (s == 0) {
		operands[2] = gen_rtx(CONST_INT,VOIDmode, 31 - e);
		return \"shlo	%2,%1,%0\;cmpi	0,%0\;testne	%0\";
	}
	if (e == 31) {
		operands[2] = gen_rtx(CONST_INT,VOIDmode, s);
		return \"shro	%2,%1,%0\;cmpi	0,%0\;testne	%0\";
	}
	operands[2] = gen_rtx(CONST_INT,VOIDmode, 31 - e);
	output_asm_insn(\"shlo	%2,%1,%0\",operands);
	if (e-s != 31) {
		operands[2] = gen_rtx(CONST_INT,VOIDmode, 31 - (e-s));
		output_asm_insn(\"shro	%2,%0,%0\",operands);
	}
	return \"cmpi	0,%0\;testne	%0\";
  }"
"C_ALUSEQ, R_ALU"
)

;; (define_insn ""
;;   [(set (match_operand:SI 0 "register_operand" "=d")
;; 	(and:SI (match_operand:SI 1 "arith_operand" "%dI")
;; 		(match_operand:SI 2 "mask_operand" "n")))]
;;   ""
;;   "*{
;; 	int s,e;
;; 	rtx xoperands[4];
;; 
;; 	if (INTVAL(operands[2]) < 32) {
;; 		return \"and	%2,%1,%0\";
;; 	}
;; 
;; 	xoperands[0] = operands[0];
;; 	xoperands[1] = operands[1];
;; 	if (!bitstr(INTVAL(operands[2]),&s,&e)) {
;; 		abort();
;; 	}
;; 	if (e == 31) {
;; 		operands[2] = gen_rtx(CONST_INT,VOIDmode, s);
;; 		return \"shro	%2,%0,%0\";
;; 	}
;; 	xoperands[2] = gen_rtx(CONST_INT,VOIDmode, 31 - e);
;; 	xoperands[3] = gen_rtx(CONST_INT,VOIDmode, 31 - (e-s));
;; 	output_asm_insn(\"shlo	%2,%1,%0\;shro	%3,%0,%0\",xoperands);
;; 	return \"\";
;;    }"
;; )

(define_insn "andsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(and:SI (match_operand:SI 1 "arith_operand" "%dI")
		(match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "and	%1,%2,%0"
"C_ALU, R_ALU")


(define_insn "andcbsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(and:SI (match_operand:SI 1 "arith_operand" "dI")
		(not:SI (match_operand:SI 2 "arith_operand" "dI"))))]
  ""
  "andnot	%1,%2,%0"
"C_ALU, R_ALU")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(ior:SI (match_operand:SI 1 "arith_operand" "%dI")
		(match_operand:SI 2 "power2_operand" "n")))]
  ""
  "*
   {
	if (GET_CODE(operands[1]) == CONST_INT) {
		operands[1] = gen_rtx(CONST_INT, VOIDmode,
				bitpos(INTVAL(operands[1])));
		return	\"setbit	%1,%2,%0\";
	}
	if (GET_CODE(operands[2]) == CONST_INT) {
		operands[2] = gen_rtx(CONST_INT, VOIDmode,
				bitpos(INTVAL(operands[2])));
		return	\"setbit	%2,%1,%0\";
	}
	fatal(\"internal error: multi-bit operand to setbit\");
   }"
"C_ALU, R_ALU"
)

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(ior:SI (match_operand:SI 1 "arith_operand" "%dI")
		(match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "or	%1,%2,%0"
"C_ALU, R_ALU")


(define_insn "iorcbsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(ior:SI (match_operand:SI 1 "arith_operand" "dI")
		(not:SI (match_operand:SI 2 "arith_operand" "dI"))))]
  ""
  "ornot	%2,%1,%0"
"C_ALU, R_ALU")


(define_insn "xorsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(xor:SI (match_operand:SI 1 "arith_operand" "%dI")
		(match_operand:SI 2 "arith_operand" "%dI")))]
  ""
  "xor	%1,%2,%0"
"C_ALU, R_ALU")


(define_insn "xorcbsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(xor:SI (match_operand:SI 1 "arith_operand" "dI")
		(not:SI (match_operand:SI 2 "arith_operand" "dI"))))]
  ""
  "xnor	%2,%1,%0"
"C_ALU, R_ALU")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(neg:SI (match_operand:SI 1 "arith_operand" "dI")))]
  ""
  "subi	%1,0,%0"
"C_ALU, R_ALU")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(not:SI (match_operand:SI 1 "arith_operand" "dI")))]
  ""
  "not	%1,%0"
"C_ALU, R_ALU")



;; Floating point arithmetic instructions.

(define_insn "adddf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	(plus:DF (match_operand:DF 1 "nonmemory_operand" "%rG")
		 (match_operand:DF 2 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "addrl	%1,%2,%0"
"C_FLOAT10, R_FPADD")

(define_insn "addsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(plus:SF (match_operand:SF 1 "nonmemory_operand" "%rG")
		 (match_operand:SF 2 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "addr	%1,%2,%0"
"C_FLOAT10, R_FPADD")

(define_insn "subdf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	(minus:DF (match_operand:DF 1 "nonmemory_operand" "rG")
		  (match_operand:DF 2 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "subrl	%2,%1,%0"
"C_FLOAT10, R_FPADD")

(define_insn "subsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(minus:SF (match_operand:SF 1 "nonmemory_operand" "rG")
		  (match_operand:SF 2 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "subr	%2,%1,%0"
"C_FLOAT10, R_FPADD")

(define_insn "muldf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	(mult:DF (match_operand:DF 1 "nonmemory_operand" "rG")
		 (match_operand:DF 2 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "mulrl	%1,%2,%0"
"C_FLOAT25, R_FPMUL")

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(mult:SF (match_operand:SF 1 "nonmemory_operand" "rG")
		 (match_operand:SF 2 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "mulr	%1,%2,%0"
"C_FLOAT25, R_FPMUL")

(define_insn "divdf3"
  [(set (match_operand:DF 0 "register_operand" "=r")
	(div:DF (match_operand:DF 1 "nonmemory_operand" "rG")
		(match_operand:DF 2 "nonmemory_operand" "rG")))]
  "TARGET_FLOAT"
  "divrl	%2,%1,%0"
"C_FLOAT25, R_FPDIV")

(define_insn "divsf3"
  [(set (match_operand:SF 0 "register_operand" "=r")
	(div:SF (match_operand:SF 1 "register_operand" "rG")
		(match_operand:SF 2 "register_operand" "rG")))]
  "TARGET_FLOAT"
  "divr	%2,%1,%0"
"C_FLOAT25, R_FPDIV")

(define_insn "negsf2"
  [(set (match_operand:SF 0 "register_operand" "=d,f")
	(neg:SF (match_operand:SF 1 "register_operand" "d,r")))]
  "TARGET_FLOAT"
  "*
  { if(which_alternative == 0)
      return \"notbit	31,%1,%0\";
    return \"subr %1,0,%0\";
  }
  "
"C_FLOAT10, R_FPADD")

(define_insn "negdf2"
  [(set (match_operand:DF 0 "register_operand" "=r")
	(neg:DF (match_operand:DF 1 "register_operand" "r")))]
  "TARGET_FLOAT"
  "subrl	%1,0f0.0,%0"
"C_FLOAT10, R_FPADD")

(define_insn "absdf2"
  [(set (match_operand:DF 0 "register_operand" "=df")
	(abs:DF (match_operand:DF 1 "register_operand" "df")))]
  "(TARGET_FLOAT)"
  "*{
	int dstreg = REGNO(operands[0]);
	int srcreg = REGNO(operands[1]);
	register rtx xoperands[4];

	if (dstreg < 32) {
		xoperands[2] = xoperands[0] = operands[0];
		xoperands[3] = xoperands[1] = operands[1];
		REGNO(xoperands[2])++;
		REGNO(xoperands[3])++;
		if (srcreg >= 32) {
			output_asm_insn(\"movrl	%1,%0\",operands);
			output_asm_insn(\"clrbit	31,%2,%2	# absdf(%0,%1)\",xoperands);
			return \"\";
		}
		if (dstreg != srcreg) {
			output_asm_insn(\"mov	%1,%0\",operands);
		}
		output_asm_insn(\"clrbit	31,%3,%2	# absdf(%0,%1)\",
			xoperands);
		return \"\";
	}
	if (srcreg >= 32) {
		return \"cpysre	%1,0f0.0,%0	# absdf(%0,%1)\";
	}
	return \"movrl	%1,%0\;cpysre	%0,0f0.0,%0\";
 }"
"C_FLOAT25,R_ALU")

(define_insn "abssf2"
  [(set (match_operand:SF 0 "register_operand" "=df")
	(abs:SF (match_operand:SF 1 "register_operand" "df")))]
  "(TARGET_FLOAT)"
  "*{
	int dstreg = REGNO(operands[0]);
	int srcreg = REGNO(operands[1]);
	register rtx xoperands[4];

	if (dstreg < 32 && srcreg < 32) {
		return \"clrbit	31,%1,%0	# abssf(%0,%1)\";
	}
	if (dstreg >= 32 && srcreg >= 32) {
		return \"cpysre	%1,0f0.0,%0\";
	}
	if (dstreg < 32) {
		return \"movr	%1,%0\;clrbit	31,%0,%0\";
	}
	return \"movr	%1,%0\;cpysre	%0,0f0.0,%0\";
  }"
"C_ALU2, R_ALU")

;; Shift instructions

;; Optimized special case of shifting.
;; Must precede the general case.

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],3);
	return \"ldib	%1,%0\";
   }"
"C_ALU2, R_ALU")

(define_insn ""
  [(set (match_operand:QI 0 "register_operand" "=d")
	(ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],3);
	return \"ldib	%1,%0\";
   }"
"C_ALU2, R_ALU")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(lshiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],3);
	return \"ldob	%1,%0\";
   }"
"C_ALU2, R_ALU")

(define_insn ""
  [(set (match_operand:QI 0 "register_operand" "=d")
	(lshiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],3);
	return \"ldob	%1,%0\";
   }"
"C_ALU2, R_ALU")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 16)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],2);
	return \"ldis	%1,%0\";
   }"
"C_ALU2, R_ALU")

(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "=d")
	(ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 16)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],2);
	return \"ldis	%1,%0\";
   }"
"C_ALU2, R_ALU")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=d")
	(lshiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 16)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],2);
	return \"ldos	%1,%0\";
   }"
"C_ALU2, R_ALU")

(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "=d")
	(lshiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 16)))]
  ""
  "*{
	operands[1] = adj_offsettable_operand(operands[1],2);
	return \"ldos	%1,%0\";
   }"
"C_ALU2, R_ALU")

;;- arithmetic shift instructions


(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(ashift:SI (match_operand:SI 1 "arith_operand" "dI")
		   (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "shli	%2,%1,%0"
"C_ALU2, R_ALU"
)

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(ashiftrt:SI (match_operand:SI 1 "arith_operand" "dI")
		     (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "shri	%2,%1,%0"
"C_ALU2, R_ALU")


(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=d")
	(lshiftrt:SI (match_operand:SI 1 "arith_operand" "dI")
		   (match_operand:SI 2 "arith_operand" "dI")))]
  ""
  "shro	%2,%1,%0"
"C_ALU2, R_ALU")

;; Unconditional and other jump instructions
(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "b	%l0"
"C_BR, R_BR")

;; op[0] is index, op[1] is lower bound, op[2] is upperbound - lowerbound
;; op[3] is out-of-range label, op[4] is head of jump table

;; (define_insn "casesi"
;;    [(set (cc0)
;; 	(compare (match_operand:SI 0 "register_operand" "d")
;; 		 (match_operand:SI 1 "arith_operand" "n")))
;;     (set (pc)
;; 	 (if_then_else (lt [(cc0) (const_int 0)])
;; 		(label_ref (match_operand 3 "" ""))
;; 		(pc)))
;;     (set (cc0)
;; 	(compare (match_dup 0)
;; 		 (match_operand:SI 2 "arith_operand" "n")))
;;     (set (pc)
;; 	(if_then_else (gt [(cc0) (const_int 0)])
;; 		(label_ref (match_dup 3))
;; 	 	(pc)))
;;     (set (pc) (plus:SI (label_ref (match_operand 4 "" ""))
;; 			(mult:SI (match_dup 0) (const_int 4))))]
;;     ""
;;    "*{
;; 	rtx xops[6];
;; 	xops[0] = operands[0]; xops[1] = operands[1]; xops[2] = operands[2];
;; 	xops[3] = operands[3]; xops[4] = operands[4];
;; 	xops[5] = gen_rtx(CONST_INT, VOIDmode, INTVAL(xops[1]) * 4);
;; 
;; 	return \"cmpi\t%1,%0\;concmpi\t%2,%0\;bne\t%l3\;ld	%l4-%5[%0*4],%0\;bx\t(%0)"
;; "C_BR,R_BR")


(define_insn "tablejump"
  [(set (pc) (match_operand:SI 0 "register_operand" "d"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "bx	(%0)"
"C_BR, R_BR"
)

;;- jump to subroutine

(define_insn "call"
  [(call (match_operand:SI 0 "general_operand" "g")
	 (match_operand:SI 1 "immediate_operand" "i"))]
  ""
  "*{
	extern char *i960_output_call_insn();
	return i960_output_call_insn(operands[0],operands[1],insn);
   }"
"C_CALL, R_CALL")

(define_insn "call_value"
  [(set (match_operand 0 "register_operand" "=d")
	(call (match_operand:SI 1 "general_operand" "g")
	      (match_operand:SI 2 "immediate_operand" "i")))]
  ""
  "*{
	extern char *i960_output_call_insn();
	return i960_output_call_insn(operands[1],operands[2],insn);
   }"
"C_CALL, R_CALL")

(define_insn "return"
  [(return)]
  ""
  "*{
	extern char *i960_output_ret_insn();
	return i960_output_ret_insn(insn);
   }"
"C_RET, R_RET"
)

(define_insn "nop"
  [(const_int 0)]
  ""
  ""
    "C_NOP, R_NOP"
)
