/* $Id: out-i960.c,v 1.14 89/11/28 16:04:14 mcg Exp $ */

/* Subroutines for insn-output.c for intel 80960
   Copyright (C) 1987, 1988 Free Software Foundation, Inc.
   Contributed by Steven McGeady, Intel Corp.
   Additional Work by Glenn Colon-Bonet, Jonathan Shapiro, Andy Wilson
 */


/*
This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

#include <stdio.h>

#include "flags.h"
#include "tree.h"
#include "insn-codes.h"

char *out_i960_rcs_id = "@(#) $Id: out-i960.c,v 1.14 89/11/28 16:04:14 mcg Exp $";
char *tm_i960_rcs_id = i960_RCS_ID_STRING;
extern char *target_version_string;
extern char *version_string;
extern char *const insn_template[];

i960_asm_file_start(file)
FILE *file;
{
	fprintf(file," # GCC base %s; 80960 Revision %s\n",
		version_string, target_version_string);
	fprintf(file," # %s\n", out_i960_rcs_id);
	fprintf(file," # %s\n", tm_i960_rcs_id);
	fprintf(file," # %s\n", insn_template[(int)CODE_FOR_i960_rcs_id]);

	fputs(" #	",file);
	if (optimize) fputs("-O ",file);
	if (flag_force_mem) fputs("-fforce-mem ", file);
	if (flag_force_addr) fputs("-fforce-addr ", file);
	if (flag_combine_regs) fputs("-fcombine-regs ", file);
	if (flag_strength_reduce) fputs("-fstrength-reduce ", file);
	if (flag_inline_functions) fputs("-finline-functions ", file);
	if (flag_no_peephole) fputs("-fno-peephole ", file);
	fputs("\n",file);

	fputs(" #	",file);
	if (TARGET_CA) {
		if (!TARGET_FLOAT) fputs("-mca ", file);
		else fputs("-mcb ", file);
	} else if (TARGET_MC) {
		fputs("-mmc ", file);
	} else if (TARGET_KA) {
		if (!TARGET_FLOAT) fputs("-mka ", file);
		else fputs("-mkb ", file);
	}
	if (!TARGET_FLOAT) fputs("-mnofloat ",file);
	if (!TARGET_LEAFPROC) fputs("-mnoleaf-procedures ",file);
	if (!TARGET_TAILCALL) fputs("-mnotail-calls ",file);
	if (!TARGET_COMPLEX_ADDR) fputs("-mnocomplex-addr ",file);
	if (TARGET_CODE_ALIGN) fputs("-mcode-align ",file);
	if (TARGET_BRANCH_PREDICT) fputs("-mbranch-predict ",file);
	if (TARGET_ROTATE_LOCAL) fputs("-mrotate-locals ",file);
	if (TARGET_ROTATE_GLOBAL) fputs("-mrotate-globals ",file);
	if (TARGET_INTEL_ASM) fputs("-mintel-asm ",file);
	fputs("\n",file);
}

/* Global variables for machine-dependent things.  */

/* This should go away if we pass floats to regs via
   the stack instead of the frame, and if we learn how
   to renumber all the registers when we don't do a save (hard!).  */
extern int frame_pointer_needed;

static rtx find_addr_reg ();

/* no such initialization needed on the 80960 */

int
init_emit_once_mdep () {}

int
no_funny_sets_cc0 (x)
     rtx x;
{
    return 1;
}


/* Return truth value of whether OP can be used as an operands in a three
   address arithmetic insn (such as add %o1,7,%l2) of mode MODE.  */

int
reg_or_mem_operand (op, mode)
rtx op;
enum machine_mode mode;
{
	return general_operand(op, mode);
}

/* Return truth value of whether OP can be used as an operands in a three
   address arithmetic insn (such as add %o1,7,%l2) of mode MODE.  */

int
arith_operand (op, mode)
rtx op;
enum machine_mode mode;
{
	return (register_operand (op, mode) || literal(op, mode));
}
int
fp_arith_operand (op, mode)
rtx op;
enum machine_mode mode;
{
	return(register_operand (op, mode) || fp_literal(op, mode));
}

int
signed_arith_operand (op, mode)
rtx op;
enum machine_mode mode;
{
	return (register_operand (op, mode) || signed_literal(op, mode));
}


/* Return truth value of whether OP is a integer which fits the
   range constraining immediate operands in three-address insns.  */

int
literal(op, mode)
rtx op;
enum machine_mode mode;
{
  return ((GET_CODE (op) == CONST_INT) &&
	    INTVAL(op) >= 0 && INTVAL(op) < 32);
}

int
fp_literal(op, mode)
rtx op;
enum machine_mode mode;
{
  return ((GET_CODE (op) == CONST_DOUBLE) &&
	  (XINT (op, 0) == 0 && XINT (op, 1) == 0));
}

int
neg_literal(op,mode)
rtx op;
enum machine_mode mode;
{
  return ((GET_CODE (op) == CONST_INT) &&
	    INTVAL(op) < 0 && INTVAL(op) > -32);
}

int
signed_literal(op, mode)
rtx op;
enum machine_mode mode;
{
  return ((GET_CODE (op) == CONST_INT) &&
	    INTVAL(op) > -32 && INTVAL(op) < 32);
}

power2_operand(op,mode)
rtx op;
enum machine_mode mode;
{
	register unsigned int val;

	if (GET_CODE(op) != CONST_INT) {
		return 0;
	}
	return(is_power2(INTVAL(op)));
}

mask_operand(op,mode)
rtx op;
enum machine_mode mode;
{
	register unsigned int val;
	if (GET_CODE(op) != CONST_INT) {
		return 0;
	}
	return(is_mask(val));
}

is_power2(val)
unsigned int val;
{
	for ( ; val != 0; val >>= 1) {
		if (val&1) {
			if (val != 1)
				return 0;
			return 1;
		}
	}
	/* no bits set */
	return 0;
}

is_mask(val)
unsigned int val;
{
	register int start, end, i;

	start = -1;
	for (i = 0; val != 0; val >>= 1, i++) {
		if (val&1) {
			if (start < 0) {
				start = i;
			}
			end = i;
			continue;
		}
		/* still looking for the first bit */
		if (start < 0) {
			continue;
		}
		/* we've seen the start of a bit sequence */
		/* then a zero - if there are more bits, it's not a mask */
		if (val) {
			return 0;
		}
	}
	/* bit string starts at 'start', ends at 'end' */
	return 1;
}


bitpos(val)
unsigned int val;
{
	register int i;

	for (i = 0; val != 0; i++, val >>= 1) {
		if (val&1) {
			if (val != 1)
				return -1;
			return i;
		}
	}
	return -1;
}

bitstr(val,s,e)
unsigned int val;
int *s,*e;
{
	register int start, end, i;

	start = -1; end = -1;
	for (i = 0; val != 0; val >>= 1, i++) {
		if (val&1) {
			if (start < 0) {
				start = i;
			}
			end = i;
			continue;
		}
		/* still looking for the first bit */
		if (start < 0) {
			continue;
		}
		/* we've seen the start of a bit sequence */
		/* then a zero - if there are more bits, it's not a mask */
		if (val) {
			start = -1;
			end = -1;
			break;
		}
	}
	/* bit string starts at 'start', ends at 'end' */
	*s = start;
	*e = end;
	return ((start < 0) ? 0 : 1);
}


nonfpreg_operand (op, mode)
rtx op;
enum machine_mode mode;
{
	if ((GET_CODE(op) == REG) && (GET_MODE_CLASS(mode) == MODE_FLOAT))
		return 0;
	return (general_operand(op,mode));
}


/* Return truth value of whether OP is a relational operator.  */
int
relop(op, mode)
rtx op;
enum machine_mode mode;
{
	switch (GET_CODE(op)) {
	case EQ:
	case NE:
	case GT:
	case GE:
	case LT:
	case LE:
	case GTU:
	case GEU:
	case LTU:
	case LEU:
		return 1;
	}
	return 0;
}



/* Return truth value of wheterh OP is EQ or NE.  */
int
eq_or_neq(op, mode)
rtx op;
enum machine_mode mode;
{
	return (GET_CODE(op) == EQ || GET_CODE(op) == NE);
}


#if 0
i960_gen_ldconst(dst,src)
register rtx dst,src;
{
	register int rsrc = INTVAL(src);

	if (rsrc > 0) {
		/* ldconst	0..31,X		-> 	mov	0..31,X */
		if (rsrc < 32) {
			/* return 'mov %1,%0' */
		}
		/* ldconst	32..63,X	->	add	31,nn,X */
		if (rsrc < 63) {
			/* return 'add 31,%1-31,%0' */
		}
	} else if (rsrc < 0) {
		/* ldconst	-1..-31		->	sub	0,0..31,X */
		if (rsrc > -31) {
			/* return 'sub	0,abs(%1),%0' */
		}
	}
	/* if const is a single bit */
	if ((j = bitpos(rsrc)) >= 0) {
		/* return 'setbit	j,0,%0' */
	}
	/* if const is a bit string of less than 6 bits (1..31 shifted) */
	if (bitstr()) {
	}
}
#endif 


static char *i960_reg_names[] = REGISTER_NAMES;
extern char call_used_regs[];

int	i960_func_n_calls;	/* number of calls in current function */
int	i960_leaf_ret_reg;	/* the leaf-procedure return register */
int	i960_leaf_proc_ok;	/* this procedure is ok for a leafproc */
int	i960_func_is_varargs;	/* this function is varargs */
int	i960_func_struct_return;/* this function returns a struct */
int	i960_g14_save_reg;	/* if this proc uses g14, where its value is
				   saved */
char	i960_restore_g14_str[100];/* the string to restore g14 */

char	epilogue_string[1000];
int	tail_call_ok;
int	epilogue_needed;
static	int func_nregs;
static	int ret_label = 0;
static	int regs[FIRST_PSEUDO_REGISTER];
static	int saveregs[FIRST_PSEUDO_REGISTER];

find_unused_reg(mode,locals)
enum machine_mode mode;
int locals;
{
	static char fixed_regs[FIRST_PSEUDO_REGISTER] = FIXED_REGISTERS;
	register int size;
	register int maxreg;
	register int i,j;

	if ((mode == SImode) || (mode == QImode) || (mode == HImode) ||
	    (mode == SFmode))
		size = 1;
	else if ((mode == DImode) || (mode == DFmode))
		size = 2;
	else if ((mode == TFmode) || (mode == TImode))
		size = 4;
	else
		abort();

	maxreg = (i960_leaf_proc_ok ? 16 : 32) - (size-1);
	for (i = (locals ? 16 : 0); i < maxreg; i++) {
		if ((i % size) != 0) {
			continue;
		}
		if ((regs_ever_live[i] == 0) && !fixed_regs[i]) {
			if (size == 1)
				return i;
			if (size == 2) {
				if (regs_ever_live[i+1] || fixed_regs[i+1])
					continue;
				return i;
			}
			if (size == 4) {
				if ((regs_ever_live[i+1] || fixed_regs[i+1])||
				    (regs_ever_live[i+2] || fixed_regs[i+2])||
				    (regs_ever_live[i+3] || fixed_regs[i+3]))
					continue;
				return i;
			}
		}
	}
	return -1;
}

i960_function_name_declare(file, name, fndecl)
FILE *file;
char *name;
tree fndecl;
{
	register int i,j;
	register rtx insn;
	register rtx g14,fp;

	ret_label++;
	i960_leaf_ret_reg = -1;
	i960_g14_save_reg = -1;
	epilogue_string[0] = '\0';
	i960_reg_names[ARG_POINTER_REGNUM] = "g14";

	g14 = gen_rtx(REG,SImode,14);
	fp = gen_rtx(REG,SImode,15);

	if (TARGET_LEAFPROC) {
		i960_leaf_proc_ok = 1;
	} else {
		i960_leaf_proc_ok = 0;
	}
	if (TARGET_TAILCALL) {
		tail_call_ok = 1;
	} else {
		tail_call_ok = 0;
	}
	epilogue_needed = 0;
	i960_func_is_varargs = 0;
	i960_func_struct_return = 0;
	i960_func_n_calls = 0;
	func_nregs = 0;

	/*
	 * Nonzero if function takes extra anonymous args.
	 * Also nonzero if the first arg is named `__builtin_va_alist',
	 * which is used on some machines for old-fashioned non-ANSI varargs.h
	 */

	if (((DECL_ARGUMENTS(fndecl) != 0 &&
	     (!strcmp(IDENTIFIER_POINTER(DECL_NAME(DECL_ARGUMENTS(fndecl))),
		      "__builtin_va_alist"))) ||
	     (TYPE_ARG_TYPES(TREE_TYPE(fndecl)) != 0 &&
		(TREE_VALUE(tree_last(TYPE_ARG_TYPES(TREE_TYPE(fndecl)))) !=
		 void_type_node))))
	{
		i960_func_is_varargs = 1;
		i960_leaf_proc_ok = 0;
		tail_call_ok = 0;
	}

	/*
	 * See if function returns a struct
	 */
	if (DECL_MODE(DECL_RESULT(fndecl)) == BLKmode) {
		i960_func_struct_return = 1;
		i960_leaf_proc_ok = 0;
		tail_call_ok = 0;
	}

	insn = get_insns();

	for (insn = NEXT_INSN(insn); insn; insn = NEXT_INSN(insn)) {
		switch(GET_CODE(insn)) {
		case NOTE:
		case BARRIER:
		case CODE_LABEL:
			continue;
	
		case CALL_INSN:		/* see if there are any calls */
			/* should look for actuals that are my params here */
			i960_leaf_proc_ok = 0;
			i960_func_n_calls++;
			continue;

		case INSN:
			break;

		default:
			continue;
		}
		/* see if there are any uses of g14 */

		if (reg_mentioned_p(g14,insn)) {
			regs_ever_live[ARG_POINTER_REGNUM] = 1;
			i960_leaf_proc_ok = 0;
		}
		if (reg_mentioned_p(fp,insn)) {
			register rtx body = PATTERN(insn);
			register rtx src = SET_SRC(body);

			regs_ever_live[FRAME_POINTER_REGNUM] = 1;
			i960_leaf_proc_ok = 0;
			if (GET_CODE(body) == SET &&
			    address_operand(src,GET_MODE(src))) {
				tail_call_ok = 0;
			}
		}
	}


#if 0
	if (optimize) {

	insn = get_insns();

	for (insn = NEXT_INSN(insn); insn; insn = NEXT_INSN(insn)) {
	switch(GET_CODE(insn)) {
	case NOTE:
	case BARRIER:
	case CODE_LABEL:
	case CALL_INSN:
		break;

	case INSN:
		/* check for redundant ldconst's */
		{
		register rtx i;
		rtx pat,src,dst,reg,cons;
		register RTX_CODE code;
		int ok_delete_zero_set;

		reg = SET_DEST(PATTERN(insn));
		cons = SET_SRC(PATTERN(insn));
		ok_delete_zero_set = 0;

		if (GET_CODE(PATTERN(insn)) != SET ||
		   (GET_CODE(cons) != CONST_INT) ||
		   (GET_CODE(reg) != REG)) {
			break;
		}


		for (i = NEXT_INSN(insn); i; i = NEXT_INSN(i)) {
			code = GET_CODE(i);

			if (code == NOTE || code == BARRIER)
				continue;

			/* don't look past the next label or call */
			if (code == CODE_LABEL)
				break;

			if ((code == JUMP_INSN) ||
			    (code == CALL_INSN) && call_used_regs[REGNO(reg)]) {
				if (GET_CODE(PATTERN(i)) != RETURN) {
					ok_delete_zero_set = 0;
				}
				break;
			}

			if (code != INSN)
				break;

			pat = PATTERN(i);
			dst = SET_DEST(pat);
			src = SET_SRC(pat);


			code = GET_CODE(pat);

#if 0
			if (code == SET && (INTVAL(cons) == 0) &&
			    (regs_ever_live[ARG_POINTER_REGNUM] == 0) &&
			    rtx_equal_p(reg,src) && (GET_CODE(dst) == MEM)) {
				REGNO(SET_SRC(PATTERN(i))) = ARG_POINTER_REGNUM;
				ok_delete_zero_set++;
			}
#endif

			/* register is killed ? */
			/* could replace this if PRESERVE_DEATH... */
			/* were set correctly */

			if (code == SET && (rtx_equal_p(reg,dst))) {
				/* not killed, redundant setting ? */
				if (GET_CODE(src) == CONST_INT &&
				    (INTVAL(src) == INTVAL(cons))) {
					delete_insn(i);
					continue;
				}
				ok_delete_zero_set = 0;
				break;
			}
			/* here should check for set of different reg */
			/* with same constant value, then look for */
			/* uses of that register elsewhere in the */
			/* basic block */
		} /* end inside for loop */

#if 0
		if (ok_delete_zero_set) {
			delete_insn(insn);
		}
#endif

		} /* end case INSN block */
		break;
	default:
		break;
	} /* end switch */
	} /* end for loop */
	} /* end if (optimize) */
#endif

	fprintf(file, "\t#  Function '%s'\n", name);
	fprintf(file, "\t#   %d calls\n", i960_func_n_calls);

	fprintf(file, "\t#  Registers used: ");
	for (i = 0, j = 0; i < FIRST_PSEUDO_REGISTER; i++) {
		if (regs_ever_live[i]) {
			fprintf(file, "%s%s ", i960_reg_names[i],
				call_used_regs[i] ? "" : "*");
			if (i > 15 && j == 0) {
				fprintf(file,"\n\t#\t\t   ");
				j++;
			}
		}
		if (regs_ever_live[i] && (!call_used_regs[i])) {
			regs[i] = -1;
			if (i < 16) {		/* global registers */
				func_nregs++;
				if (i > 7 && i != 13) {
					i960_leaf_proc_ok = 0;
				}
			} else if (i < 32) {	/* local registers */
				i960_leaf_proc_ok = 0;
			}
		} else {
			regs[i] = 0;
		}
	}
	fprintf(file, "\n");

	if (optimize && i960_leaf_proc_ok &&
	    get_frame_size() <= STARTING_FRAME_OFFSET) {
		for (i960_leaf_ret_reg = -1, i = 0; i < 8; i++) { 
			if (regs_ever_live[i] == 0) {
				i960_leaf_ret_reg = i;
				regs_ever_live[i] = 1;
				break;
			}
		}
		if (i960_leaf_ret_reg >= 0) {
			/* make it a leaf proc */

			fprintf(file,"\n");
			if (TREE_PUBLIC (fndecl))
				fprintf(file,"\t.globl	%s.lf\n",name);
			fprintf(file,"\t.leafproc\t_%s,%s.lf\n\n",name,name);
			fprintf(file,"_%s:\n",name);
			fprintf(file,"\tlda	LR%d,g14\n",ret_label);
			fprintf(file,"%s.lf:\n",name);
			fprintf(file,"\tmov	g14,g%d\n", i960_leaf_ret_reg);
			if (TARGET_CA) {
				fprintf(file,"\tlda	0,g14\n");
			} else {
				fprintf(file,"\tmov	0,g14\n");
			}
			return;
		}
	}

	ASM_OUTPUT_LABEL(file,name);

}

i960_function_prologue(file, size)
FILE *file;
unsigned int	size;
{
	int	fsize = ((size) + 3) &~3;
	register int i,j,nr;
	int	n_iregs = func_nregs;
/* [atw] 1. starting-frame-offset has already been subtracted
 *       2. align local variable size to a quad-word boundary.
 *	int	lsize = fsize - STARTING_FRAME_OFFSET;
*/
	int     lsize = ((fsize + 15)) & ~15;
	int	rsize = 0;
	int	sp_off;
	char	tmpstr[1000];


	if (n_iregs) {
		epilogue_needed = 1;
	}

	/* fprintf (file, "\t#PROLOGUE#\n"); */

	/* first look for local registers to save globals in */
	for (i = 0; i < 16; i++) {
		if (regs[i] == 0)
			continue;
		saveregs[i] = -1;
		/* start at r4, not r3 */
		for (j = 20; j < 32; j++) {
			if (regs[j] != 0) {
				continue;
			}
			regs[i] = 1;
			regs[j] = -1;
			regs_ever_live[j] = 1;
			saveregs[i] = j;
			nr = 1;
			if (i <= 14 && i%2 == 0 && j <= 30 && j%2 == 0 &&
			    regs[i+1] != 0 && regs[j+1] == 0) {
				nr = 2;
				regs[i+1] = 1;
				regs[j+1] = -1;
				regs_ever_live[j+1] = 1;
				saveregs[i+1] = j+1;
			}
			if (nr == 2 && i <= 12 && i%4 == 0 && j <= 28 && j%4 == 0 &&
			    regs[i+2] != 0 && regs[j+2] == 0) {
				nr = 3;
				regs[i+2] = 1;
				regs[j+2] = -1;
				regs_ever_live[j+2] = 1;
				saveregs[i+2] = j+2;
			}
			if (nr == 3 && regs[i+3] != 0 && regs[j+3] == 0) {
				nr = 4;
				regs[i+3] = 1;
				regs[j+3] = -1;
				regs_ever_live[j+3] = 1;
				saveregs[i+3] = j+3;
			}

			fprintf(file,"\tmov%s	%s,%s\n",
				((nr == 4) ? "q" :
				 (nr == 3) ? "t" :
				 (nr == 2) ? "l" : ""),
				i960_reg_names[i],i960_reg_names[j]);
			sprintf(tmpstr,"\tmov%s	%s,%s\n",
				((nr == 4) ? "q" :
				 (nr == 3) ? "t" :
				 (nr == 2) ? "l" : ""),
				i960_reg_names[j],i960_reg_names[i]);
			strcat(epilogue_string,tmpstr);

			n_iregs -= nr;
			i += nr-1;
			break;
		}
	}
	/* if there are no calls, then there is no need to save away g14,
	   since the call template will never set it back to zero. */

	/* if we do need to goof with g14, but can find a local register
	   to save it in, we record the register number of the local register
	   and replace all instances of g14 with it */

	if (i960_func_n_calls &&
	    (i960_func_is_varargs || regs_ever_live[ARG_POINTER_REGNUM])) {
		if ((i960_g14_save_reg = find_unused_reg(SImode,1)) < 0) {
			n_iregs++;
		} else {
			regs_ever_live[i960_g14_save_reg] = 1;
		}
	}
	nr = lsize + (rsize = (n_iregs*4));
	sp_off = STARTING_FRAME_OFFSET + lsize;

	/* allocate space for register save and locals */
	if (nr > 0) {
		if (nr < 32)
			fprintf(file, "\taddo	%d,sp,sp\n", nr);
		else
			fprintf(file, "\tlda\t%d(sp),sp\n", nr);
	}

	/* save registers on stack if needed */
	for (i = 0, j = n_iregs; j > 0 && i < 16; i++) {
		if (regs[i] != -1) {
			continue;
		}
		nr = 1;

		if ((i <= 14) && (i%2 == 0) && (regs[i+1] == -1)) {
			nr = 2;
		}
		if ((i <= 12) && (i%4 == 0) && (nr == 2) && (regs[i+2] == -1)) {
			nr = 3;
		}
		if ((nr == 3) && (regs[i+3] == -1)) {
			nr = 4;
		}
		fprintf(file,"\tst%s	%s,%d(fp)\n",
			((nr == 4) ? "q" :
			 (nr == 3) ? "t" :
			 (nr == 2) ? "l" : ""),
			i960_reg_names[i], sp_off);
		sprintf(tmpstr,"\tld%s	%d(fp),%s\n",
			((nr == 4) ? "q" :
			 (nr == 3) ? "t" :
			 (nr == 2) ? "l" : ""),
			sp_off, i960_reg_names[i]);
		strcat(epilogue_string,tmpstr);
		sp_off += (nr*4);
		i += nr-1;
		j -= nr;
	}
	if (i960_func_is_varargs) {
		/* if so, this is probably a varargs, */
		/* so be sure there's an argument block */
		fprintf(file,"\tcmpobne	0,g14,LF%d\n",ret_label);
		fprintf(file,"\tmov	sp,g14\n");
		fprintf(file,"\tlda	48(sp),sp\n");
		fprintf(file,"LF%d:",ret_label);
		fprintf(file,"\tstq	g0,(g14)\n");
		fprintf(file,"\tstq	g4,0x10(g14)\n");
		fprintf(file,"\tstq	g8,0x20(g14)\n");
	}
	if (i960_g14_save_reg >= 0) {
		fprintf(file,"\tmov\tg14,%s\n",i960_reg_names[i960_g14_save_reg]);
		sprintf(i960_restore_g14_str,"mov\t%s,g14",i960_reg_names[i960_g14_save_reg]);

		/* for now, until we've fully checked-out g14 replacement */
		i960_g14_save_reg = -1;
#if 0
		i960_reg_names[ARG_POINTER_REGNUM] = i960_reg_names[i960_g14_save_reg];
		/* the g14_save_reg will now be used in place of g14 */
		/* g14 is not otherwise used and is guaranteed to be zero */

		regs_ever_live[ARG_POINTER_REGNUM] = 0;
		fprintf(file,"\tmov	0,g14\n");
#endif

	} else if (i960_func_n_calls &&
		  (i960_func_is_varargs || regs_ever_live[ARG_POINTER_REGNUM])){

		/* we allocated space for this above when we incremented
		   n_iregs after looking for save reg for g14 */

		fprintf(file,"\tst	g14,%d(fp)\n",sp_off);

		/* this string is used in the call template to restore g14
		   after calls */

		sprintf(i960_restore_g14_str,"ld\t%s(fp),g14",sp_off);
	}

	nr = fsize+(n_iregs*4)+(i960_func_is_varargs ? 48 : 0);

	if (nr == 0 && lsize == 0 && rsize == 0)
		return;

	fprintf(file, "\t#Prologue stats:\n");
	fprintf(file, "\t#  Total Frame Size: %d bytes\n", nr);

	if (lsize)
		fprintf(file, "\t#  Local Variable Size: %d bytes\n", lsize);
	if (rsize)
		fprintf(file,"\t#  Register Save Size: %d regs, %d bytes\n",
			n_iregs,rsize);
	fprintf (file, "\t#End Prologue#\n");
}



i960_function_epilogue(file,size)
FILE *file;
unsigned int size;
{
	int fsize = ((size) + 3) & (~3);
	int lsize = fsize - STARTING_FRAME_OFFSET;
	register int i,j,nr;
	int n_iregs = 0;
	int sp_off;
	char	regs[FIRST_PSEUDO_REGISTER];


	if (i960_leaf_ret_reg >= 0) {
		fprintf(file,"LR%d:	ret\n",ret_label);
		return;
	}
	if (!epilogue_needed) {
		register rtx tmp;
	
		tmp = get_last_insn();
		while (tmp) {
			if (GET_CODE(tmp) == BARRIER)
				return;
			if (GET_CODE(tmp) == CODE_LABEL)
				break;
			if (GET_CODE(tmp) == JUMP_INSN) {
				if (GET_CODE(PATTERN(tmp)) == RETURN)
					return;
				break;
			}
			if (GET_CODE(tmp) == NOTE) {
				tmp = PREV_INSN(tmp);
				continue;
			}
			break;
		}
		fprintf(file,"LR%d:	ret\n",ret_label);
		return;
	}

	fprintf(file,"LR%d:\n",ret_label);

	fprintf (file, "\t#EPILOGUE#\n");

	if (epilogue_string[0] != '\0')
		fprintf(file, "%s", epilogue_string);

	if (i960_func_is_varargs || regs_ever_live[ARG_POINTER_REGNUM]) {
		fprintf(file,"\tmov	0,g14\n");
	}
	fprintf(file,"\tret\n");
	fprintf (file, "\t#End Epilogue#\n");
}


char *
i960_output_call_insn(targ,frame,insn)
register rtx targ,frame,insn;
{
	int non_indirect, uses_g14;
	int framesize = INTVAL(frame);
	rtx nexti = next_real_insn(insn);
	rtx operands[3];

	operands[0] = targ;
	operands[1] = frame;

	non_indirect = ((GET_CODE(targ) == MEM) && 
	    (GET_CODE(XEXP(targ, 0)) == SYMBOL_REF));
	uses_g14 = (i960_func_is_varargs ||
	    regs_ever_live[ARG_POINTER_REGNUM]);

	/* we've got an argument block */
	if (framesize != 0) {
		operands[1] = gen_rtx(CONST_INT, VOIDmode, framesize);
		output_asm_insn("lda	 %n1(sp), g14", operands);
	} else if (uses_g14) {
		/* no arg block, but g14 is live in this procedure */
		output_asm_insn("mov	0, g14", operands);
	}

	if (optimize && !epilogue_needed && framesize == 0 && tail_call_ok &&
	    TARGET_TAILCALL && (GET_CODE(PATTERN(nexti)) == RETURN)) {
		/* delete_insn(nexti); /* might delete after a label */
		output_asm_insn((non_indirect) ? "b	 %0" : "bx	 %0",
				operands);
		return "";
	}

	output_asm_insn(non_indirect ? "callj	 %0" : "callx	%0", operands);

	if (uses_g14) {
		if (i960_g14_save_reg < 0) {
			if (GET_CODE(PATTERN(nexti)) != RETURN) {
				return i960_restore_g14_str;
			}
		} else {
#if 0
			/* we've got g14 value saved elsewhere,		*/
			/* just reset g14 here, so we can use as constant 0 */
		/* this isn't turned on now */
			return "mov	0,g14";
#endif
			abort();
		}
	} else if (framesize != 0) {
		return "mov	0,g14";
	}
	return "";
}




char *
i960_output_ret_insn(insn)
register rtx insn;
{
	static char lbuf[20];

	if (epilogue_needed) {
		if (next_real_insn(insn) == 0) {
			return "";
		}
		sprintf(lbuf,"b	LR%d",ret_label);
		return lbuf;
	}
	if (i960_func_is_varargs || regs_ever_live[ARG_POINTER_REGNUM]) {
		output_asm_insn("mov	0,g14",0);
	}
	if (i960_leaf_ret_reg >= 0) {
		sprintf(lbuf,"bx	(%s)",i960_reg_names[i960_leaf_ret_reg]);
		return lbuf;
	}
	return "ret";
}


/* Load the address specified by OPERANDS[3] into the register
   specified by OPERANDS[0].

   OPERANDS[3] may be the result of a sum, hence it could either be:

   (1) CONST
   (2) REG
   (2) REG + CONST_INT
   (3) REG + REG + CONST_INT

   Note that (3) is not a legitimate address.
   All cases are handled here.  */

void
output_load_address (operands)
rtx *operands;
{
	rtx base, offset;

	/* constant */
	if (CONSTANT_P (operands[3])) {
		output_asm_insn ("lda	%3,%0", operands);
		return;
	}
	/* reg */
	if (REG_P (operands[3])) {
		if (REGNO (operands[0]) != REGNO (operands[3]))
			output_asm_insn ("mov %3,%0", operands);
		return;
	}

	base = XEXP (operands[3], 0);
	offset = XEXP (operands[3], 1);

	if (GET_CODE (base) == CONST_INT) {
		rtx tmp = base;
		base = offset;
		offset = tmp;
	}

	if (GET_CODE (offset) != CONST_INT)
		abort ();

	/* reg + constant */
	if (REG_P (base)) {
		operands[6] = base;
		operands[7] = offset;
		if (literal(offset,SImode)) {
			output_asm_insn("addo	%6,%7,%0\n",operands);
		} else if (neg_literal(offset,SImode)) {
			operands[7] = gen_rtx(CONST_INT, VOIDmode, INTVAL(operands[7])&0x1f);
			output_asm_insn("subo	%7,%6,%0\n",operands);
		} else {
			output_asm_insn ("lda	%6(%7),%0\n", operands);
		}
		return;
	}

	/* reg + reg + const */
	operands[6] = XEXP (base, 0);
	operands[7] = XEXP (base, 1);
	operands[8] = offset;

	if (literal(offset,SImode)) {
		output_asm_insn("addo\t%8,%6,%0\n\taddo\t%0,%7,%0\n",operands);
	} else if (neg_literal(offset,SImode)) {
		operands[8] = gen_rtx(CONST_INT, VOIDmode, INTVAL(operands[8])&0x1f);
		output_asm_insn("subo\t%7,%6,%0\n\taddo\t%0,%7,%0\n",operands);
	} else {
		/* better for code density */
		output_asm_insn("lda	%8(%6)[%7*1],%0\n",operands);
	}
	abort();
}



static	i960_branch_predict;
int	i960_loop_level = 0;

i960_final_prescan_insn(insn,opvec,noperands)
rtx insn;
rtx *opvec;
int noperands;
{
	rtx next;

	i960_branch_predict = -1;
	next = NEXT_INSN(insn);
	if (!next)
		return;
	if (GET_CODE(next) == NOTE) {
		if (NOTE_LINE_NUMBER(next) == NOTE_INSN_LOOP_BEG) {
			i960_branch_predict = 1;
		} else if (NOTE_LINE_NUMBER(next) == NOTE_INSN_LOOP_END) {
			i960_branch_predict = 1;
		}
#ifdef NOTE_INSN_LOOP_CONT
		/* not in 1.34 */
		else if (NOTE_LINE_NUMBER(next) == NOTE_INSN_LOOP_CONT) {
			i960_branch_predict = 0;
		}
#endif
	}
	return;
}

i960_print_operand(file,x,code)
FILE *file;
rtx x;
char code;
{
	enum rtx_code rtxcode = GET_CODE(x);
	static char *reg_name[] = REGISTER_NAMES;

	if (rtxcode == REG) {
		fprintf(file, "%s", reg_name[REGNO (x)]);
		return;
	}
	if (rtxcode == MEM)	{
		output_address(XEXP(x, 0));
		return;
	}
	if (rtxcode == CONST_DOUBLE) {
		if ((x == dconst0_rtx) || (x == fconst0_rtx)) {
			fprintf(file, "0f0.0");
			return;
		}
		fatal("Illegal const_double in PRINT_OPERAND\n");
	}

	switch(code) {
	case 'P':	/* branch prediction bit */
		if (TARGET_BRANCH_PREDICT) {
			if (i960_branch_predict == 1) {
				fputs(".t",file);
			} else if (i960_branch_predict == 0) {
				fputs(".f", file);
			}
		}
		return;

	case 'B':	/* branch or jump, depending on assembler */
		if (TARGET_INTEL_ASM) fputs("j",file);
		else fputs("b",file);
		return;
	case 'S':	/* sign of condition */
		if ((rtxcode == EQ) || (rtxcode == NE) || (rtxcode == GTU) ||
		    (rtxcode == LTU) || (rtxcode == GEU) || (rtxcode == LEU)) {
			fputs("o",file);
			return;
		}
		if ((rtxcode == GT) || (rtxcode == LT) ||
		    (rtxcode == GE) || (rtxcode == LE)) {
			fputs("i",file);
			return;
		}
		abort();
		/*NOTREACHED*/
	case 'C':	/* normal condition */
		if (rtxcode == EQ) {fputs("e",file); return;}
		if (rtxcode == NE) {fputs("ne",file); return;}
		if (rtxcode == GT) {fputs("g",file); return;}
		if (rtxcode == GTU) {fputs("g",file); return;}
		if (rtxcode == LT) {fputs("l",file); return;}
		if (rtxcode == LTU) {fputs("l",file); return;}
		if (rtxcode == GE) {fputs("ge",file); return;}
		if (rtxcode == GEU) {fputs("ge",file); return;}
		if (rtxcode == LE) {fputs("le",file); return;}
		if (rtxcode == LEU) {fputs("le",file); return;}
		abort();
		/*NOTREACHED*/
	case 'R': 	/* reversed operand condition */
		if (rtxcode == EQ) {fputs("e",file); return;}
		if (rtxcode == NE) {fputs("ne",file); return;}
		if (rtxcode == GT) {fputs("l",file); return;}
		if (rtxcode == GTU) {fputs("l",file); return;}
		if (rtxcode == LT) {fputs("g",file); return;}
		if (rtxcode == LTU) {fputs("g",file); return;}
		if (rtxcode == GE) {fputs("le",file); return;}
		if (rtxcode == GEU) {fputs("le",file); return;}
		if (rtxcode == LE) {fputs("ge",file); return;}
		if (rtxcode == LEU) {fputs("ge",file); return;}
		abort();
		/*NOTREACHED*/
	case 'I':	/* inverted condition */
		if (rtxcode == EQ) {fputs("ne",file); return;}
		if (rtxcode == NE) {fputs("e",file); return;}
		if (rtxcode == GT) {fputs("le",file); return;}
		if (rtxcode == GTU) {fputs("le",file); return;}
		if (rtxcode == LT) {fputs("ge",file); return;}
		if (rtxcode == LTU) {fputs("ge",file); return;}
		if (rtxcode == GE) {fputs("l",file); return;}
		if (rtxcode == GEU) {fputs("l",file); return;}
		if (rtxcode == LE) {fputs("g",file); return;}
		if (rtxcode == LEU) {fputs("g",file); return;}
		abort();
		/*NOTREACHED*/
	case 'X':	/* inverted condition w/ reversed operands */
		if (rtxcode == EQ) {fputs("ne",file); return;}
		if (rtxcode == NE) {fputs("e",file); return;}
		if (rtxcode == GT) {fputs("ge",file); return;}
		if (rtxcode == GTU) {fputs("ge",file); return;}
		if (rtxcode == LT) {fputs("le",file); return;}
		if (rtxcode == LTU) {fputs("le",file); return;}
		if (rtxcode == GE) {fputs("g",file); return;}
		if (rtxcode == GEU) {fputs("g",file); return;}
		if (rtxcode == LE) {fputs("l",file); return;}
		if (rtxcode == LEU) {fputs("l",file); return;}
		abort();
		/*NOTREACHED*/
	}
	output_addr_const (file, x);
	return;
}


/* Print a memory address as an operand to reference that memory location.  */

i960_print_operand_addr (file, addr)
FILE *file;
register rtx addr;
{
	register rtx op0, op1, breg, ireg;
	rtx scale, offset;
	int nested_plus = 0;	/* true if is plus (...plus(...)) rtx */

	ireg = 0;
	breg = 0;
	offset = 0;
	scale = 0;
	nested_plus = 0;
retry:
	switch (GET_CODE (addr)) {
	case MEM:
		addr = XEXP (addr, 0);
		goto retry;

	case REG:
		fprintf (file, "(%s)", i960_reg_names [REGNO (addr)]);
		break;

	case PLUS:
		op0 = XEXP(addr, 0);
		op1 = XEXP(addr, 1);
		if (CONSTANT_ADDRESS_P (op0)) {
			if (op0 == const0_rtx)
				offset = 0;
			else
				offset = op0;
			op0 = 0;
		} else if (CONSTANT_ADDRESS_P (op1)) {
			if (op1 == const0_rtx)
				offset = 0;
			else
				offset = op1;
			op1 = 0;
		}
		if (op0 && GET_CODE (op0) == REG) {
			if (!breg)
				breg = op0;
			else if (!ireg)
				ireg = op0;
			else
				fatal("Too many registers in print_operand_address()\n");
			op0 = 0;
		}
		if (op1 && GET_CODE (op1) == REG) {
			if (!breg)
				breg = op1;
			else if (!ireg)
				ireg = op1;
			else
				fatal("Too many registers in print_operand_address()\n");
			op1 = 0;
		}
		if (op0 && GET_CODE (op0) == MULT) {
			if ((GET_CODE (XEXP (op0, 0)) == REG) && 
			    (GET_CODE (XEXP (op0, 1)) == CONST_INT)) {
				ireg = XEXP (op0, 0);
				scale = XEXP (op0, 1);
				op0 = 0;
			} else if ((GET_CODE (XEXP (op0, 1)) == REG) && 
			    (GET_CODE (XEXP (op0, 0)) == CONST_INT)) {
				ireg = XEXP (op0, 1);
				scale = XEXP (op0, 0);
				op0 = 0;
			} else
				fatal("Illegal form of MULT rtx in print_operand_addr().\n");
		} else if (op1 && GET_CODE (op1) == MULT) {
			if ((GET_CODE (XEXP (op1, 0)) == REG) && 
			    (GET_CODE (XEXP (op1, 1)) == CONST_INT)) {
				ireg = XEXP (op1, 0);
				scale = XEXP (op1, 1);
				op1 = 0;
			} else if ((GET_CODE (XEXP (op1, 1)) == REG) && 
			    (GET_CODE (XEXP (op1, 0)) == CONST_INT)) {
				ireg = XEXP (op1, 1);
				scale = XEXP (op1, 0);
				op1 = 0;
			} else
				fatal("Illegal form of MULT rtx in print_operand_addr().\n");
		}
		if (op0 && GET_CODE (op0) == PLUS) {
			if (op1 || nested_plus) /* should have already matched op1 */
				fatal ("bug in print_operand_addr - PLUS PLUS rtx\n");
			addr = op0;
			nested_plus = 1;
			goto retry;
		} else if (op1 && GET_CODE (op1) == PLUS) {
			if (op0) /* should have already matched op0 */
				fatal ("bug in print_operand_addr - PLUS PLUS rtx\n");
			addr = op1;
			nested_plus = 1;
			goto retry;
		}

		if (op0 || op1) /* something didn't match */
			fatal ("Operand failed to match in print_operand_addr()");
		if (offset)
			output_addr_const(file, offset);
		if (breg) {
			fprintf (file, "(%s)", i960_reg_names[REGNO (breg)]);
		}
		if (ireg) {
			if (scale == 0)
				scale = gen_rtx(CONST_INT, VOIDmode, 1);
			fprintf (file, "[%s*%d]", i960_reg_names[REGNO (ireg)], 
					INTVAL(scale));
		}
		break;

	default:
		output_addr_const (file, addr);
	}
}




/* code for legitimize addres stuff - here rather than in tm.h so we
   can debug it
 */


/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address.

	On 80960, legitimate addresses are:
		disp	(12 or 32 bit)		ld	foo,r0
		base				ld	(g0),r0
		base + displ			ld	0xf00(g0),r0
		index*scale + displ		ld	0xf00[g1*4],r0
		base + index*scale		ld	(g0)[g1*4],r0
		base + index*scale + displ	ld	0xf00(g0)[g1*4],r0

	in each case, scale can be 1,2,4,8, or 16

   We can also treat a SYMBOL_REF as legitimate if it is part of this
   function's constant-pool, because such addresses can actually
   be output as REG+SMALLINT.  */

/* 1 if X is an address that we could indirect through.  */
indirectable_address_p(x, strict)
register rtx x;
int strict;
{

	if (CONSTANT_ADDRESS_P(x)) {
		return 1;
	}
	if (GET_CODE(x) == REG &&
	   (strict ? REG_OK_FOR_BASE_P_STRICT(x) : REG_OK_FOR_BASE_P(x))) {
		return 1;
	}
	if ((GET_CODE(x) == PLUS && GET_CODE(XEXP(x, 0)) == REG &&
	     (strict ?
		REG_OK_FOR_BASE_P_STRICT(XEXP(x,0))
	      : REG_OK_FOR_BASE_P(XEXP (x, 0))) &&
	     CONSTANT_ADDRESS_P(XEXP (x, 1)))) {
		return 1;
	}
	return 0;
}

/*
 * returns 1 if X is a valid indexing term.  This could either be a 
 * register only, or a the product of a register and a scale term
 * of size 1, 2, 4, 8, or 16.
 */
#define INDEX_TERM_P(X, MODE)   					\
 ((GET_CODE (X) == REG && REG_OK_FOR_BASE_P (X))			\
   || (GET_CODE (X) == MULT						\
     &&									\
     ((GET_CODE (XEXP (X,0)) == CONST_INT				\
       && SCALE_TERM_P (XEXP (X,0))					\
       && GET_CODE (XEXP (X,1)) == REG					\
       && REG_OK_FOR_INDEX_P (XEXP (X,1)))				\
      ||								\
      (GET_CODE (XEXP (X,1)) == CONST_INT				\
       && SCALE_TERM_P (XEXP (X,1))					\
       && GET_CODE (XEXP (X,0)) == REG					\
       && REG_OK_FOR_INDEX_P (XEXP (X,0))))))

index_term_p(x, mode, strict)
register rtx x;
enum machine_mode mode;
int strict;
{
	/* the reference to 'strict' here is a kludge to get around a
	 * bug in reload.c -- when we have run out of registers, a
	 * base-plus-scaled-index addressing mode where the base is
	 * the register needing reloading will be converted into a
	 * double-inderect memory reference, e.g.:
	 *	(mem (plus (reg 36) (mult (reg 0) (const 64))))
	 * becomes
	 *	(mem (plus (mem (plus (reg 15) (const 64))
	 *		(mult (reg 0) (const 64))))
	 *
	 * which is clearly illegal.  the problem appears to be in a
	 * combination of subst_reg_equivs() and find_reload_address_1(),
	 * or alternatively the code in reload() itself which substitutes
	 * the reg_equiv_mem[] value stored by alter_reg().  In any case,
	 * this kludge appears to prevent the problem from occurring.
	 *
	 * mcg - 11/5/89
	 */

	if (!(TARGET_COMPLEX_ADDR) || strict)
		return 0;

	if (GET_CODE (x) == REG &&
	    (strict ? REG_OK_FOR_BASE_P_STRICT(x) : REG_OK_FOR_BASE_P (x))) {
		return 1;
	}
	if (GET_CODE (x) == MULT) {
		if (GET_CODE (XEXP (x,0)) == CONST_INT &&
		    SCALE_TERM_P (XEXP (x,0)) &&
		    GET_CODE (XEXP (x,1)) == REG &&
		    (strict ?
			REG_OK_FOR_INDEX_P_STRICT(XEXP(x,1))
		      : REG_OK_FOR_INDEX_P (XEXP (x,1)))) {
			return 1;
		}
		if (GET_CODE (XEXP (x,1)) == CONST_INT &&
		    SCALE_TERM_P (XEXP (x,1)) &&
		    GET_CODE (XEXP (x,0)) == REG &&
		    (strict ?
			REG_OK_FOR_INDEX_P_STRICT(XEXP(x,0))
		      : REG_OK_FOR_INDEX_P (XEXP (x,0)))) {
			return 1;
		}
	}
	return 0;
}


nonindexed_address_p(x, strict)
register rtx x;
int strict;
{ 
	if (GET_CODE (x) == REG) 
		return 1;
	if (indirectable_address_p(x,strict)) 
		return 1;
	return 0;
}


indexing_p(x,mode, strict)
register rtx x;
enum machine_mode mode;
int strict;
{
	register rtx xfoo;

	/* kludge for reload() bug - see above */
	if (!(TARGET_COMPLEX_ADDR) || strict)
		return 0;

	if (GET_CODE(x) == PLUS) {
		xfoo = XEXP (x, 0);
		if (index_term_p(xfoo, mode, strict)) {
			if (nonindexed_address_p(XEXP(x, 1), strict))
				return 1;
		}
		xfoo = XEXP(x, 1);
		if (index_term_p(xfoo, mode, strict)) {
			if (nonindexed_address_p(XEXP(x, 0), strict))
				return 1;
		}
	}
	return 0;
}

const_plus_index_p(x, mode, strict)
register rtx x;
enum machine_mode mode;
int strict;
{ 
	if (GET_CODE(x) == PLUS) { 
		if (CONSTANT_ADDRESS_P (XEXP (x, 0))
		     && (strict ? REG_OK_FOR_BASE_P_STRICT(XEXP(x,0)) :
				  REG_OK_FOR_BASE_P (XEXP (x, 0)))
		     && index_term_p (XEXP (x, 1), mode, strict))
			return 1;
		if (CONSTANT_ADDRESS_P (XEXP (x, 1))
		     && (strict ? REG_OK_FOR_BASE_P_STRICT(XEXP(x,1)) :
				  REG_OK_FOR_BASE_P (XEXP (x, 1)))
		     && index_term_p (XEXP (x, 0), mode, strict))
			return 1;
	} 
	return 0;
}


/* Go to ADDR if X is the sum of a register
   and a valid index term for mode MODE.  */
reg_plus_index_p(x, mode, strict)
register rtx x;
enum machine_mode mode;
int strict;
{ 
	if (GET_CODE (x) == PLUS) { 
		if (GET_CODE (XEXP (x, 0)) == REG
		     && (strict ? REG_OK_FOR_BASE_P_STRICT(XEXP(x,0)) :
				  REG_OK_FOR_BASE_P (XEXP (x, 0)))
		     && index_term_p(XEXP (x, 1), mode, strict))
			return 1;
		if (GET_CODE (XEXP (x, 1)) == REG
		     && (strict ? REG_OK_FOR_BASE_P_STRICT(XEXP(x,1)) :
				  REG_OK_FOR_BASE_P (XEXP (x, 1)))
		     && index_term_p (XEXP (x, 0), mode, strict))
			return 1;
	} 
	return 0;
}


indexed_address_p(x,mode,strict)
register rtx x;
enum machine_mode mode;
int strict;
{
	if (GET_CODE (x) == PLUS) { 
		if (GET_CODE (XEXP (x, 0)) == PLUS &&
		   (GET_CODE (XEXP (x, 1)) == REG))
			if (const_plus_index_p(XEXP (x, 0), mode, strict))
				return 1;

		if (GET_CODE (XEXP (x, 1)) == PLUS &&
		   (GET_CODE (XEXP (x, 0)) == REG))
			if (const_plus_index_p(XEXP (x, 1), mode, strict))
				return 1;

		if (GET_CODE (XEXP (x, 0)) == PLUS &&
		   (CONSTANT_ADDRESS_P(XEXP (x, 1))))
			if (reg_plus_index_p(XEXP (x, 0), mode, strict))
				return 1;

		if (GET_CODE (XEXP (x, 1)) == PLUS &&
		   (CONSTANT_ADDRESS_P(XEXP (x, 0))))
			if (reg_plus_index_p(XEXP (x, 1), mode, strict))
				return 1;
	}
	return 0;
}


legitimate_address_p(mode,x,strict)
enum machine_mode mode;
register rtx x;
int strict;
{
	if (nonindexed_address_p(x,strict)) 
		return 1;

	if ((indexing_p(x,mode,strict)) ||
	   (indexed_address_p(x,mode,strict))) {
		return 1;
	}
	return 0;
}

/* Try machine-dependent ways of modifying an illegitimate address
   to be legitimate.  If we find one, return the new, valid address.
   This macro is used in only one place: `memory_address' in explow.c.

   OLDX is the address as it was before break_out_memory_refs was called.
   In some cases it is useful to look at this to decide what needs to be done.

   MODE and WIN are passed so that this macro can use
   GO_IF_LEGITIMATE_ADDRESS.

   It is always safe for this macro to do nothing.  It exists to recognize
   opportunities to optimize the output.  */

/* On 80960, change REG+N into REG+REG, and REG+(X*Y) into REG+REG.  */

rtx
legitimize_address(x, oldx, mode)
register rtx x;
register rtx oldx;
enum machine_mode mode;
{ 
	extern rtx copy_to_reg();

	if (GET_CODE (x) == PLUS && CONSTANT_ADDRESS_P (XEXP (x, 1)))
		x = gen_rtx (PLUS, SImode, XEXP (x, 0),
		    copy_to_mode_reg (SImode, XEXP (x, 1)));
	if (GET_CODE (x) == PLUS && CONSTANT_ADDRESS_P (XEXP (x, 0)))
		x = gen_rtx (PLUS, SImode, XEXP (x, 1),
		    copy_to_mode_reg (SImode, XEXP (x, 0)));
	if (GET_CODE (x) == PLUS && GET_CODE (XEXP (x, 0)) == MULT)
		x = gen_rtx (PLUS, SImode, XEXP (x, 1),
		    force_operand (XEXP (x, 0), 0));
	if (GET_CODE (x) == PLUS && GET_CODE (XEXP (x, 1)) == MULT)
		x = gen_rtx (PLUS, SImode, XEXP (x, 0),
		    force_operand (XEXP (x, 1), 0));
	if (GET_CODE (x) == SYMBOL_REF)
		x = copy_to_reg (x);
	return x;
}

/*----------------------------------------------------------------------------*/
/* unsigned_condjump_p() - returns true if the insn passed is a conditional   */
/*    jump with an unsigned branch condition.  This is used to determine if   */
/*    the preceding compare insn should be a signed or unsigned compare.      */
/*----------------------------------------------------------------------------*/
unsigned_condjump_p(insn)
rtx insn;
{
    rtx cinsn;
    enum rtx_code codei;

    /* check if this is a valid insn */
    if (insn == 0)
	return 0;
    codei = GET_CODE (insn);
    if (!(codei == INSN || codei == CALL_INSN || codei == JUMP_INSN))
        return 0;

    /* check if this is a conditional jump insn */
    if(simplejump_p(insn) || ! condjump_p(insn))
	return 0;
    
    /* insn is a valid conditional jump insn */
    cinsn = XEXP (SET_SRC (PATTERN (insn)), 0);
    codei = GET_CODE(cinsn);

    switch(codei)
    {
	case GEU:
	case GTU:
	case LEU:
	case LTU:
	    return 1;
	default:
	    return 0;
    }

}



/*------------------------------------------------------------------------------*/
/* unsigned_condset_p() - returns true if the insn passed is a conditional	*/
/*    set with an unsigned branch condition.  This is used to determine if 	*/
/*    the preceding compare insn should be a signed or unsigned compare.	*/
/*------------------------------------------------------------------------------*/
unsigned_condset_p(insn)
rtx insn;
{
    rtx x;
    rtx cinsn;
    enum rtx_code codei;

    /* check if this is a valid insn */
    if (insn == 0)
	return 0;
    codei = GET_CODE (insn);
    if (!(codei == INSN || codei == CALL_INSN || codei == JUMP_INSN))
        return 0;

    x = PATTERN (insn);

    /* check if this is a conditional jump insn */
    if(GET_CODE(x) != SET)
        return 0;
    
    /* insn is a valid conditional set insn */
    cinsn = SET_SRC (x);
    codei = GET_CODE(cinsn);

    switch(codei)
    {
	case GEU:
	case GTU:
	case LEU:
	case LTU:
	    return 1;
	default:
	    return 0;
    }
}

chkbit_insn_p(insn)
rtx insn;
{
    rtx x;
    rtx cinsn;
    enum rtx_code codei;

    return (cc_status.flags&CC_BITTEST);
}

rtx
operand_constant_p(insn,op)
rtx insn,op;
{
	register rtx ilink,pinsn,note;
	extern rtx find_regno_note();	/* in rtl.c */

	if (GET_CODE(op) == CONST_INT)
		return(op);

	for (ilink = LOG_LINKS(insn); ilink; ilink = XEXP(ilink, 1)) {
		pinsn = XEXP(ilink,0);
		if (GET_CODE(pinsn) == NOTE || GET_CODE(pinsn) != INSN)
			continue;
		if ((GET_CODE(PATTERN(pinsn)) == SET) &&
		     rtx_equal_p(SET_DEST(PATTERN(pinsn)),op)) {
			note = find_regno_note(pinsn,REG_EQUIV,REGNO(op));
			if (note) {
				if ((GET_CODE(XEXP(note,0)) == CONST_INT))
					return (XEXP(note,0));
			} else if (GET_CODE(SET_SRC(PATTERN(pinsn))) == CONST_INT) {
					return (SET_SRC(PATTERN(pinsn)));
			}
		}
	}
	return (rtx) 0;
}

/* for debugging purposes in testing the HARD_REGNO_NREGS macro */

int hard_regno_nregs(regno, mode)
int regno;
enum machine_mode mode;
{
    return HARD_REGNO_NREGS (regno, mode);
}

int hard_regno_mode_ok(regno, mode)
int regno;
enum machine_mode mode;
{
    return HARD_REGNO_MODE_OK (regno, mode);
}

int type_align(type)
tree type;
{
   return TYPE_ALIGN(type);
}

i960_function_arg_size(mode,type)
enum machine_mode mode;
tree type;
{
	return __FUNCTION_ARG_SIZE(mode,type);
}

i960_function_arg_align(off, mode, type)
unsigned int off;
enum machine_mode mode;
tree type;
{
	return __FUNCTION_ARG_ALIGN(off,mode,type);
}

/* Return the next CALL_INSN or JUMP_INSN after LABEL;
   or 0, if there is none.  */

rtx
next_branch_insn (label)
     rtx label;
{
	register rtx insn = NEXT_INSN (label);
	register RTX_CODE code;

	while (1) {
		if (insn == 0)
			return insn;
		code = GET_CODE (insn);
		if (code == CALL_INSN || code == JUMP_INSN)
			break;
		insn = NEXT_INSN (insn);
	}
	return insn;
}

/* Return the last instruction that set the condition codes register,
   Since this is used only for branch prediction, we should be safe
   to only look for CALL and insns that set CC0...

   return 0, if there is none.  */
rtx
prev_cc0_insn(label)
rtx label;
{
	register rtx insn = PREV_INSN (label);
	register RTX_CODE code;

	while (1) {
		if (insn == 0)
			return insn;
		code = GET_CODE (insn);
		if (code == CALL_INSN || 
		    (code == SET && GET_CODE (SET_DEST (insn)) == CC0))
			break;
		insn = PREV_INSN (insn);
	}

	return insn;
}


