/* Program environment definitions for GDB, the GNU debugger.
   Copyright (C) 1989 Free Software Foundation, Inc.

GDB is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GDB General Public License for full details.

Everyone is granted permission to copy, modify and redistribute GDB,
but only under the conditions described in the GDB General Public
License.  A copy of this license is supposed to have been given to you
along with GDB so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share GDB, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!
*/


/* We manipulate environments represented as these structures.  */

struct environ
{
  /* Number of usable slots allocated in VECTOR.
     VECTOR always has one slot not counted here,
     to hold the terminating zero.  */
  int allocated;
  /* A vector of slots, ALLOCATED + 1 of them.
     The first few slots contain strings "VAR=VALUE"
     and the next one contains zero.
     Then come some unused slots.  */
  char **vector;
};

struct environ *make_environ ();
void free_environ ();
void init_environ ();
char *get_in_environ ();
void set_in_environ ();
void unset_in_environ ();
char **environ_vector ();
