/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
/************************************************/
/* For an explanation of "GDB mode", see the 	*/
/* description of the 'gdb' flag in globals.h. 	*/
/************************************************/

#define DLE	'\020'
			/* GDB commands start with this character.
			 * And NINDY informs GDB that the user program
			 * has stopped running by sending this character to GDB.
			 */

#define      	FALSE   0		/* standard */
#define      	TRUE    1
#define      	STEP    2
#define      	ERROR  	-1

#define 	NONE	0		/* obvious I hope */
#define 	ONE	1
#define 	TWO	2
#define 	THREE	3
#define 	BOTH	2

#define		FLASH		0	/* flash download */
#define		RAM		1	/* RAM download */

#define 	PROMPTLEN	2	/* length of prompt */
#define 	LINELEN		40	/* length of input line */
#define 	MAXHIST		2	/* maximum history buffer */
#define 	XMODSIZE 	128	/* size of xmodem buffer */
#define 	NUMBREAK 	2	/* num of allowed hard brkpts */
#define 	NUMSBREAK 	2	/* num of allowed soft brkpts */
#define 	NUMDBREAK 	2	/* num of allowed data brkpts */
#define 	MAXDIGITS 	10	/* max num of digits in int */

#define 	B 	0		/* memb instruction */
#define 	A 	1		/* mema instrucion */

#define 	BRANCH 	0		/* branch trace */
#define 	CALL 	1		/* call trace */
#define 	RET 	2		/* return trace */
#define 	SUP 	3		/* supervisor trace */
#define 	OFF 	4		/* trace off */
#define 	ON 	5		/* trace on */
#define 	ALL 	6		/* all traces */

/* define ASCII characters */
#define		NUL	000		/* null */
#define 	SOH  	001 		/* start of header */
#define      	EOT	004		/* end of transmission */
#define      	ACK  	006		/* acnowledge */
#define		BS	010		/* backspace */
#define		TAB	011		/* tab */
#define		CR	015		/* carriage return */
#define		LF	012		/* line feed */
#define      	NAK  	025		/* no acnowledge */
#define	     	CAN	030		/* cancel */
#define		SP	040		/* space */
#define		DEL	177		/* delete */
#define		CTRL_P	020		/* Control P */
#define 	XON	021		/* flow control on */
#define		XOFF	023		/* flow control off */


#define 	BYTE		8	/* 8 bits */
#define 	SHORT		16	/* 16 bits */
#define 	INT		32	/* 32 bits */
#define 	LONG		64	/* 64 bits */
#define		TRIPLE		96	/* 96 bits */
#define 	QUAD		128	/* 128 bits */
#define 	EXTENDED	80	/* 80 bits */

/*  XMODEM Constants  */
#define      TIMEOUT  	-1
#define      ERRORMAX  	15    /* max errors tolerated */
#define	     BBUFSIZ	1024  /* buffer size */

/* defines for timeouts */
#define      MHZ		16
#define	     READ_CYCLES 	25	

/* defines for status of parser */
#define 	P_INIT 		0	/* parser initialize */
#define 	P_SECT 		1	/* parse sections */
#define 	P_RAWDATA 	2	/* parse raw data */
#define 	P_DONE 		3	/* parser finished */

/* define for break from fmark to monitor */
#define		MAGIC_BREAK	0xfeedface
