/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"

/************************************************/
/* Modify Memory or Register           		*/
/*                           			*/
/************************************************/
modify(size)
int size;
{
unsigned *addr;
unsigned int data;
int valid, reg;
int cycles,i;

	cycles = 1;
	reg = 1;
	addr = (unsigned *)get_word(&cycles, &reg, TWO, FALSE);
	if (errno == TRUE) {
		if (!reg)
			print ("\n\r Invalid address or register");
		return;
	}
	switch (size) {
		case INT:
			for (i=0; i<cycles; i++) {
				print("\n\r");
				out_hex(addr, INT, TRUE);
				print(" : ");
				data = *addr;
				out_hex(data, INT, TRUE);
				co (SP);
				print(" : ");
				data = get_data(&valid);
				if (valid == TRUE) 
					*addr = data;
				addr++;
			}
			break;
		case BYTE:
			print("\n\r");
			out_hex(addr, INT, TRUE);
			print(" : ");
			data = get_data(&valid);
			if (valid == TRUE) 
				store_byte(data, addr);
			break;
		default:
			break;
	}
}

/************************************************/
/* Display Memory               		*/
/*                           			*/
/************************************************/
display(size)
int size;
{
union {
	unsigned int *addr;
	unsigned int addr_byte;
	unsigned short *addr_short;
} a;
unsigned char byte_data;
int cycles;
char byt;
unsigned short shrt;
int i, j, reg;

	cycles = 1;
	reg = 0;
	a.addr=(unsigned int *)get_word(&cycles,&reg,TWO,FALSE);
	if (errno == TRUE) {
		if (!reg)
			print ("\n\r Invalid address or register");
		return;
	}
	switch (size) {
		case BYTE:
			for (i=0; i<cycles; i++) {
				print("\n\r");
				out_hex(a.addr, INT, TRUE);
				print(" : ");
				byte_data = load_byte((int)a.addr);
				out_hex(byte_data, BYTE, TRUE);
				a.addr_byte++;
			}
			break;
		case SHORT:
			for (i=0; i<cycles; i++) {
				print("\n\r");
				out_hex(a.addr, INT, TRUE);
				print(" : ");
				out_hex(*a.addr_short, SHORT, TRUE);
				a.addr_short++;
			}
			break;
		case INT:
			for (i=0; i<cycles; i++) {
				print("\n\r");
				out_hex(a.addr, INT, TRUE);
				print(" : ");
				out_hex(*a.addr, INT, TRUE);
				a.addr++;
			}
			break;
		case LONG:
			for (i=0; i<cycles; i++) {
				load_long(a.addr);
				for (j=0; j<=1; j++) {
					print("\n\r");
					out_hex(a.addr, INT, TRUE);
					print(" : ");
					out_hex(long_data[j], INT, TRUE);
					a.addr++;
				}
			}
			break;
		case TRIPLE:
			for (i=0; i<cycles; i++) {
				load_triple(a.addr);
				for (j=0; j<=2; j++) {
					print("\n\r");
					out_hex(a.addr, INT, TRUE);
					print(" : ");
					out_hex(long_data[j], INT, TRUE);
					a.addr++;
				}
			}
			break;
		case QUAD:
			for (i=0; i<cycles; i++) {
				load_quad(a.addr);
				for (j=0; j<=3; j++) {
					print("\n\r");
					out_hex(a.addr, INT, TRUE);
					print(" : ");
					out_hex(long_data[j], INT, TRUE);
					a.addr++;
				}
			}
			break;
		default:
			break;
	}
}
