/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
struct file {		/* file header structure */
	unsigned short	file_type;	/* file type */
	unsigned short	num_secs;	/* number of sections */
	long		time_date;	/* time and date stamp */
	long		symtbl_ptr; 	/* symbol table ptr */
	long		num_syms; 	/* num entries in symb tabl */
	unsigned short	opt_hdr;	/* size of optional header */
	unsigned short	flags;		/* flags */
};

struct sect { 		/* section header structure */
	char		sec_name[8];   	/* section name */
	long    	p_addr;		/* physical address */
	long    	v_addr;		/* virtual address */
	long    	sec_size;	/* size of sections */
	long    	data_ptr;	/* pointer to data */
	long    	reloc_ptr;      /* relocation pointer */
	long    	line_num_ptr;	/* line number pointer */
	unsigned short	num_reloc;	/* number of reloc entries */
	unsigned short	num_line; 	/* number line num entries */
	long    	flags;		/* flags */
	unsigned long	sec_align; 	/* alignment for sect bndry */
};

struct aout {		/* a.out header structure */
	unsigned short 	magic_nmbr;	/* magic number */
	unsigned short 	version;	/* version */
	long		text_size;	/* size of .text section */
	long		data_size;	/* size of .data section */
	long		bss_size;	/* size of .bss section */
	long		start_addr; 	/* starting address */
	long 		text_begin;	/* start of text section */
	long		data_begin; 	/* start of data section */
};

#define FHDRSIZE sizeof(struct file) 	/* size of file header */
#define SHDRSIZE sizeof(struct sect)    /* size of section header */
#define AOUTSIZE sizeof(struct aout)    /* size of optional header */

/* file header union */
union {
	unsigned char buff[FHDRSIZE];
	struct file filehead;
} filebuf;

/* section header union */
union {
	unsigned char buff[SHDRSIZE];
	struct sect secthead;
} sectbuf[12];

/* a.out header union */
union {
	unsigned char buff[AOUTSIZE];
	struct aout aouthead;
} aoutbuf;

unsigned char *secbuffptr;	  /* pointer to section info */
unsigned char *secbuffptr_holder; /* state of ptr to section info */
int buffindex;			  /* place holder for xmodem buffer */
unsigned char buff[BBUFSIZ];	  /* buffer for data */

/* global status to track parser */
int parser_state;			/* reentry state for parser */
int current_section;			/* section number */
int current_byte;			/* byte within section */

struct fault_data {
	unsigned reserved;
	unsigned override[3];
	unsigned fdata[3];
	unsigned override_data;
	unsigned pc;
	unsigned ac;
	unsigned int 	fsubtype:8,
			freserved:8,
			ftype:8,
			fflags:8;
	unsigned int *faddress;
} *return_fault_ptr();


char	cmd[3];				/* monitor command */
char  	prompt[PROMPTLEN];		/* prompt */
unsigned char linebuff[LINELEN];	/* command line buffer */
unsigned char histbuff[MAXHIST][LINELEN]; /* command history buffer */
int	histflag;			/* flag for command history */

int fault_flag;				/* flag for first fault */

extern  unsigned int *nindy_stack; 	/* stack for nindy use */

unsigned long errno;

unsigned int *ip;
unsigned int long_data[4];

#ifdef GDB
/*
 * THE FOLLOWING ARE HERE TO SUPPORT THE GDB INTERFACE TO NINDY
 *
 * GDB is the GNU symbolic debugger.  It runs on a remote host and talks
 * to NINDY via the serial I/O line.
 *
 * NINDY enters GDB mode as soon as it receives a GDB command.  A GDB
 * command is any command that begins with the character ^P.  The
 * characteristics of GDB mode are:
 *	(1) A limited number of commands, in a compact form.
 *	(2) All commands are followed by  the character "#", and then
 *		two hex digits representing a checksum for the command.
 *		All NINDY reponses are in the same form.
 *	(3) NINDY prompts are suppressed:  NINDY speaks only in reponse
 *		to a command.
 *	(4) Once GDB starts up the user program, user I/O is passed straight
 *		through the serial port (that's stdin/stdout.
 *		When the user program stops, NINDY writes ^P (DLE)
 *		to GDB, so it knows to go back to checksummed commands.
 *
 * See gdb.c for a list of legal GDB commands.
 */

extern char gdb;	/* TRUE after the first GDB command is seen.
			 * If FALSE, NINDY assumes it is
			 * interacting directly with a humanoid.
			 */

extern char stop_exit;
extern char stop_code;
			/* The reason why the user program last stopped.
			 * See fault.c for legal values.
			 */

extern char gdb_debug;	/* See gdb.c */
#endif
