/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "block_io.h"

extern unsigned prcb_ram;
/************************************************/
/*  Output					*/
/* 						*/
/* Memory mapped I/O routine, writes 8 bit value*/
/* to port 					*/
/************************************************/
output(port, value)
unsigned char *port, value;
{
	*port = value;
}

/************************************************/
/*  Input					*/
/* 						*/
/*  Memory mapped input routine, returns 8 bit  */
/* value from port				*/
/************************************************/
unsigned char input(port)
unsigned char *port;
{
	return(*port);
}

/************************************************/
/* read byte (timeout)                          */
/*                                              */
/* This routine waits until a character is      */
/* available at the console input.  If the char */
/* is available before the timeout on the serial*/
/* channel, it returns the character. Otherwise,*/
/* return TIMEOUT error.  			*/
/************************************************/
readbyte(seconds)
int 	seconds;
{
char c;
int ticks;

	/* return character when available */

	for (ticks = 0; ticks < (seconds*((MHZ*300000)/READ_CYCLES));
			ticks++) 
		if (csts() != 0) 
			return((int)ci());
		else 
			continue;
	
	/* if timeout error, return TIMEOUT */
	return(TIMEOUT);
}

/************************************************/
/* console io                                   */
/*                                              */
/* Provide system services console io.		*/
/* This routine will be entered from "calls 0"  */
/* in the supervisior table, thus allowing an   */
/* application to execute code and do I/O to    */
/* the serial device of this monitor through    */
/* run-time binding 				*/
/************************************************/
console_io(type, chr)
int type, chr;
{
unsigned char *temp;

	switch (type) {
		case 0: /* request type is console in */
			temp = (unsigned char *)chr;
			*temp = ci();
			break;
		case 1: /* request type is console out */
			buffco(chr);
			break;
		default:
			return (ERROR);
	}
	return(0);
}

/************************************************/
/* File (buffer) I/O Call			*/
/*                           			*/
/************************************************/
buffer_io (filename, v2, v3, v4, v5)
int filename, v2, v3, v4, v5;
{
int tmp;

	switch (filename) {
		case BS_ACCESS:	
				tmp = f_access(v2, v3);
				break;
		case BS_CLOSE:	
				tmp = f_close(v2);
				break;
		case BS_CREAT:	
				tmp = f_creat(v2, v3);
				break;
		case BS_LSEEK:	
				tmp = f_lseek(v2, v3, v4);
				break;
		case BS_OPEN:	
				tmp = f_open(v2, v3, v4);
				break;
		case BS_READ:	
				tmp = f_read(v2, v3, v4, v5);
				break;
		case BS_STAT:	
				tmp = f_stat(v2, v3);
				break;
		case BS_SYSTEMD:	
				tmp = f_systemd(v2);
				break;
		case BS_TIME:	
				tmp = f_time();
				break;
		case BS_UNMASK:	
				tmp = f_unmask(v2);
				break;
		case BS_UNLINK:	
				tmp = f_unlink(v2);
				break;
		case BS_WRITE:	
				tmp = f_write(v2, v3, v4, v5);
				break;
		default:
				return (ERROR);
	}
	return (tmp);
}

/************************************************/
/* Print routine                		*/
/*                           			*/
/************************************************/
print (str)
char *str;
{
	while (*str != NUL) 
		buffco(*str++);
}


/************************************************/
/* Output Hex Number         			*/
/*                           			*/
/* output a 32 bit value in hex to the console  */
/* leading determines whether or not to print   */
/* leading zeros				*/
/************************************************/
out_hex(value, type, leading)
unsigned int value;
int type;	/* type of access- byte, short, word, or long */
int leading;	/* leading 0 flag */
{
	int shift;
	register unsigned char out;

	for (shift = (type-4); shift >= 0; shift -= 4) {
		/* shift digits */
		out = ((value >> shift) & 0xf); /* capture digit */
		if (out >= 10 ) {	 /* is A - F */
			buffco((out-9) | 0x60); /* out ascii equiv */
			leading = TRUE;
			}
		else if (out > 0) {	/* is 1 - 9 */
			buffco(out | 0x30);	/* out ascii equiv */
			leading = TRUE;
			}
		else if ((leading == TRUE) || (shift == 0))
			/* 0 case, check for leading */
			buffco(0x30) ;	/* output "0" */
	}
}

/************************************************/
/* laser io                                     */
/*                                              */
/* Provide laser printer direct lpt I/O.	*/
/* This routine will be entered from "calls 2"  */
/* in the supervisior table, thus allowing an   */
/* application to execute code and do I/O to    */
/* the serial device of this monitor through    */
/* run-time binding 				*/
/************************************************/
lpt_io(type, chr)
int type, chr;
{
unsigned char *temp;

	switch (type) {
		case 0: /* request type is char in */
			temp = (unsigned char *)chr;
			*temp = ci();
			break;
		case 1: /* request type is char out */
			co(chr);
			break;
		default:
			return (ERROR);
	}
	return(0);
}

/***********************************************/
/* This routine allows the PRCB to be returned */
/* to the io libraries, in order to set        */
/* interrupts, modify control table, etc.      */
/***********************************************/
unsigned int get_prcb()
{
	return((int)&prcb_ram);
}

/************************************************/
/* Change the Baud rate           	 	*/
/*                           			*/
/************************************************/
baud()
{
unsigned char c;
int index;
int none;
unsigned char *buff;
unsigned char s[16];
int baud;

	buff = s;
	*buff = NUL;
	none = TRUE;
	index = 0;

	/* read past command to first space or determine no address
	   is given */
	while (((c = linebuff[index++]) != NUL) && 
		(c != SP) && (c != TAB));

	if (c == SP) {
		/* read to next non-blank character */
		while (((c = linebuff[index++]) == SP) || (c == TAB));

		/* otherwise, baud rate is given, pick it out */
		while ((c != NUL) && (c != SP) && (c != TAB)) {
			none = FALSE;
			*buff++ = c;
			c = linebuff[index++];
		}
	}
	if (!none) {
		*buff = NUL;
		baud = atod(s);
		if (errno == FALSE) {
			switch (baud) {
				case 1200:
				case 2400:
				case 9600:
				case 19200:
				case 38400:
					change_baud(baud);
					return;
				default:
					print("\n\rInvalid baud rate");
					return;
			}
		}
		print("\n\r No change");
		return;
	}
	print("\n\r No change");
}
