/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "regs.h"

/************************************************/
/* Display Registers                            */
/* 						*/
/* this routine will display the last stored    */
/* register values from the global register     */
/* storage area 				*/
/************************************************/
display_regs()
{
int tmp;
	print("\n\r");
	
	print(" g0 : ");
	out_hex(register_set[REG_G0], INT, TRUE);
	print(" g1 : ");
	out_hex(register_set[REG_G1], INT, TRUE);
	print(" g2 : ");
	out_hex(register_set[REG_G2], INT, TRUE);
	print(" g3 : ");
	out_hex(register_set[REG_G3], INT, TRUE);
	print("\n\r");

	print(" g4 : ");
	out_hex(register_set[REG_G4], INT, TRUE);
	print(" g5 : ");
	out_hex(register_set[REG_G5], INT, TRUE);
	print(" g6 : ");
	out_hex(register_set[REG_G6], INT, TRUE);
	print(" g7 : ");
	out_hex(register_set[REG_G7], INT, TRUE);
	print("\n\r");

	print(" g8 : ");
	out_hex(register_set[REG_G8], INT, TRUE);
	print(" g9 : ");
	out_hex(register_set[REG_G9], INT, TRUE);
	print(" g10: ");
	out_hex(register_set[REG_G10], INT, TRUE);
	print(" g11: ");
	out_hex(register_set[REG_G11], INT, TRUE);
	print("\n\r");

	print(" g12: ");
	out_hex(register_set[REG_G12], INT, TRUE);
	print(" g13: ");
	out_hex(register_set[REG_G13], INT, TRUE);
	print(" g14: ");
	out_hex(register_set[REG_G14], INT, TRUE);
	print(" fp : ");
	out_hex(register_set[REG_FP], INT, TRUE);
	print("\n\n\r");

	print(" pfp: ");
	out_hex(register_set[REG_PFP], INT, TRUE);
	print(" sp : ");
	out_hex(register_set[REG_SP], INT, TRUE);
	print(" rip: ");
	out_hex(register_set[REG_RIP], INT, TRUE);
	print(" r3 : ");
	out_hex(register_set[REG_R3], INT, TRUE);
	print("\n\r");

	print(" r4 : ");
	out_hex(register_set[REG_R4], INT, TRUE);
	print(" r5 : ");
	out_hex(register_set[REG_R5], INT, TRUE);
	print(" r6 : ");
	out_hex(register_set[REG_R6], INT, TRUE);
	print(" r7 : ");
	out_hex(register_set[REG_R7], INT, TRUE);
	print("\n\r");

	print(" r8 : ");
	out_hex(register_set[REG_R8], INT, TRUE);
	print(" r9 : ");
	out_hex(register_set[REG_R9], INT, TRUE);
	print(" r10: ");
	out_hex(register_set[REG_R10], INT, TRUE);
	print(" r11: ");
	out_hex(register_set[REG_R11], INT, TRUE);
	print("\n\r");

	print(" r12: ");
	out_hex(register_set[REG_R12], INT, TRUE);
	print(" r13: ");
	out_hex(register_set[REG_R13], INT, TRUE);
	print(" r14: ");
	out_hex(register_set[REG_R14], INT, TRUE);
	print(" r15: ");
	out_hex(register_set[REG_R15], INT, TRUE);
	print("\n\r");
 
	print(" pc : ");
	out_hex(register_set[REG_PC], INT, TRUE);
	print(" ac : ");
	out_hex(register_set[REG_AC], INT, TRUE);
	print(" tc : ");
	out_hex(register_set[REG_TC], INT, TRUE);
	print(" ip : ");
	out_hex(register_set[REG_IP], INT, TRUE);
	print("\n\r");

 }

/************************************************/
/* Display Floating Point       		*/
/*                           			*/
/************************************************/
disp_float(size)
int size;
{
	print ("\n\r Numerics not part of the architecture");
}

/************************************************/
/* Modify Register                  	 	*/
/*                           			*/
/************************************************/
mod_register(reg, num)
char reg[];
int num;
{
unsigned int data;
int valid, tmp;

	print ("\n\r");
	print (reg);
	print (" : ");
	out_hex(register_set[num], INT, TRUE);
	print (" : ");
	data = get_data(&valid);
	if (valid == TRUE){
		register_set[num] = data;
	}
}

/************************************************/
/* Display Register                  	 	*/
/*                           			*/
/************************************************/
disp_register(reg, num)
char reg[];
int num;
{
int tmp;
	print("\n\r");
	print (reg);
	print (" : ");
	out_hex(register_set[num], INT, TRUE);
}

/************************************************/
/* Get Register Number       			*/
/*                           			*/
/*	Returns:				*/
/*						*/
/*	- offset into 'register_set' array, if	*/
/*	  register is a local, global, or	*/
/*	  control register.			*/
/*						*/
/*	- ERROR if register name is unknown	*/
/*	a floating point register in the	*/
/*	'fp_register_set' array.		*/
/*						*/
/*	Returns TRUE on success, FALSE on error	*/
/************************************************/
get_regnum(reg)
char *reg;	/* Name of register	*/
{
struct tabentry { char *name; int num; };
static struct tabentry reg_tab[] = {
		"g0",	REG_G0,
		"g1",	REG_G1,
		"g2",	REG_G2,
		"g3",	REG_G3,
		"g4",	REG_G4,
		"g5",	REG_G5,
		"g6",	REG_G6,
		"g7",	REG_G7,
		"g8",	REG_G8,
		"g9",	REG_G9,
		"g10",	REG_G10,
		"g11",	REG_G11,
		"g12",	REG_G12,
		"g13",	REG_G13,
		"g14",	REG_G14,
		"fp",	REG_FP,
		"pfp",	REG_PFP,
		"sp",	REG_SP,
		"rip",	REG_RIP,
		"r3",	REG_R3,
		"r4",	REG_R4,
		"r5",	REG_R5,
		"r6",	REG_R6,
		"r7",	REG_R7,
		"r8",	REG_R8,
		"r9",	REG_R9,
		"r10",	REG_R10,
		"r11",	REG_R11,
		"r12",	REG_R12,
		"r13",	REG_R13,
		"r14",	REG_R14,
		"r15",	REG_R15,
		"pc",	REG_PC,
		"ac",	REG_AC,
		"ip",	REG_IP,
		"tc",	REG_TC,
		0,	0
};
struct tabentry *tp;

	for (tp=reg_tab; tp->name != 0; tp++) {
		if (!strcmp(reg,tp->name)) {
			return (tp->num);
		}
	}
	return(ERROR);
}
