/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include "defines.h"
#include "globals.h"
#include "regs.h"

/************************************************/
/* Trace Flags Set or Cleared        	 	*/
/*                           			*/
/************************************************/
trace()
{
int q, reg;
unsigned word, status;

	word = get_word(q, &reg, TWO, TRUE);
	if (errno == TRUE) {
		/* no option given, display all */
		display_trace(ALL);
		return;
	}
	status = get_word(q, &reg, THREE, TRUE);
	if (errno == TRUE) {
		/* no control given, display trace option status */
		display_trace(word);
		return;
	}
	switch (word) {
		case BRANCH: /* branch trace */
			if (status == ON)
				set_trace_branch();
			else
				rm_trace_branch();
			break;
		case CALL: /* call trace */
			if (status == ON)
				set_trace_call();
			else
				rm_trace_call();
			break;
		case RET: /* return trace */
			if (status == ON)
				set_trace_return();
			else
				rm_trace_return();
			break;
		case SUP: /* supervisor trace */
			if (status == ON)
				set_trace_sup();
			else
				rm_trace_sup();
			break;
		default: break;
	}
	display_trace(ALL);
}

/************************************************/
/* Set Branch Trace	            	 	*/
/*                           			*/
/************************************************/
set_trace_branch()
{
	/* set branch trace flag in TC reg */
	register_set[REG_TC] = register_set[REG_TC] | 0x4;
}
/************************************************/
/* Set Call Trace	            	 	*/
/*                           			*/
/************************************************/
set_trace_call()
{
	/* set call trace flag in TC reg */
	register_set[REG_TC] = register_set[REG_TC] | 0x8;
}
/************************************************/
/* Set Single Step Trace            	 	*/
/*                           			*/
/************************************************/
set_trace_step()
{
	/* set NIF flag for single step - CA A-step workaround */
	register_set[REG_AC] = register_set[REG_AC] | 0x8000;

	/* set single step in TC register */
	register_set[REG_TC] = register_set[REG_TC] | 0x2;
}
/************************************************/
/* Set Return Call Trace           	 	*/
/*                           			*/
/************************************************/
set_trace_return()
{
	/* set return trace flag in TC reg */
	register_set[REG_TC] = register_set[REG_TC] | 0x10;
}
/************************************************/
/* Set Supervisor Call Trace           	 	*/
/*                           			*/
/************************************************/
set_trace_sup()
{
	/* set supervisor trace flag in TC reg */
	register_set[REG_TC] = register_set[REG_TC] | 0x40;
}

/************************************************/
/* Remove Branch Trace	            	 	*/
/*                           			*/
/************************************************/
rm_trace_branch()
{
	/* turn off branch trace in TC register */
	register_set[REG_TC] = register_set[REG_TC] & 0xfffffffb;

}
/************************************************/
/* Remove Call Trace	            	 	*/
/*                           			*/
/************************************************/
rm_trace_call()
{
	/* turn off call trace in TC register */
	register_set[REG_TC] = register_set[REG_TC] & 0xfffffff7;
}
/************************************************/
/* Remove Single Step Trace            	 	*/
/*                           			*/
/************************************************/
rm_trace_step()
{
	/* turn off trace step in TC register */
	register_set[REG_TC] = register_set[REG_TC] & 0xfffffffd;

	/* turn off NIF in AC register - CA A-step workaround */
	register_set[REG_AC] = register_set[REG_AC] & 0xffff7fff;
}
/************************************************/
/* Remove Return Call Trace            		*/
/*                           			*/
/************************************************/
rm_trace_return()
{
	/* turn off return trace in TC register */
	register_set[REG_TC] = register_set[REG_TC] & 0xffffffef;
}
/************************************************/
/* Remove Supervisor Call Trace            	*/
/*                           			*/
/************************************************/
rm_trace_sup()
{
	/* turn off supervisor trace in TC register */
	register_set[REG_TC] = register_set[REG_TC] & 0xffffffbf;
}

/************************************************/
/* Display Trace Status                    	*/
/*                           			*/
/************************************************/
display_trace (trace)
int trace;
{
	if ((trace == ALL) || (trace == BRANCH)) {
		if (register_set[REG_TC] & 0x4)
			print ("\n\r Branch trace on");
		else
			print ("\n\r Branch trace off");
	}
	if ((trace == ALL) || (trace == CALL)) {
		if (register_set[REG_TC] & 0x8)
			print ("\n\r Call trace on");
		else
			print ("\n\r Call trace off");
	}
	if ((trace == ALL) || (trace == RET)) {
		if (register_set[REG_TC] & 0x10)
			print ("\n\r Return trace on");
		else
			print ("\n\r Return trace off");
	}
	if ((trace == ALL) || (trace == SUP)) {
		if (register_set[REG_TC] & 0x40)
			print ("\n\r Supervisor trace on");
		else
			print ("\n\r Supervisor trace off");
	}
}
