/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericController;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;

public abstract class GenericConglomerateController
extends GenericController
implements ConglomerateController {
    public void close() throws StandardException {
        super.close();
        if (this.open_conglom != null && this.open_conglom.getXactMgr() != null) {
            this.open_conglom.getXactMgr().closeMe(this);
        }
    }

    public boolean closeForEndTransaction(boolean bl) throws StandardException {
        super.close();
        if (!this.open_conglom.getHold() || bl) {
            if (this.open_conglom != null && this.open_conglom.getXactMgr() != null) {
                this.open_conglom.getXactMgr().closeMe(this);
            }
            return true;
        }
        return false;
    }

    public boolean delete(RowLocation rowLocation) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RowPosition rowPosition = new RowPosition();
        this.getRowPositionFromRowLocation(rowLocation, rowPosition);
        this.open_conglom.latchPage(rowPosition);
        this.open_conglom.lockPositionForWrite(rowPosition, false, true);
        boolean bl = true;
        if (rowPosition.current_page.isDeletedAtSlot(rowPosition.current_slot)) {
            bl = false;
        } else {
            rowPosition.current_page.deleteAtSlot(rowPosition.current_slot, true, null);
            if (rowPosition.current_page.nonDeletedRecordCount() == 0 || rowPosition.current_page.nonDeletedRecordCount() == 1 && rowPosition.current_page.getPageNumber() == 1L) {
                this.queueDeletePostCommitWork(rowPosition);
            }
        }
        rowPosition.current_page.unlatch();
        return bl;
    }

    public boolean fetch(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        boolean bl;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RowPosition rowPosition = new RowPosition();
        this.getRowPositionFromRowLocation(rowLocation, rowPosition);
        if (!this.open_conglom.latchPage(rowPosition)) {
            return false;
        }
        if (this.open_conglom.isForUpdate()) {
            this.open_conglom.lockPositionForWrite(rowPosition, false, true);
        } else {
            this.open_conglom.lockPositionForRead(rowPosition, null, false, true);
        }
        boolean bl2 = bl = rowPosition.current_page.fetchFromSlot(rowPosition.current_rh, rowPosition.current_slot, dataValueDescriptorArray, new FetchDescriptor(dataValueDescriptorArray.length, formatableBitSet, null), false) != null;
        if (!this.open_conglom.isForUpdate()) {
            this.open_conglom.unlockPositionAfterRead(rowPosition);
        }
        rowPosition.current_page.unlatch();
        return bl;
    }

    public boolean fetch(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, boolean bl) throws StandardException {
        boolean bl2;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RowPosition rowPosition = new RowPosition();
        this.getRowPositionFromRowLocation(rowLocation, rowPosition);
        this.open_conglom.latchPage(rowPosition);
        if (this.open_conglom.isForUpdate()) {
            this.open_conglom.lockPositionForWrite(rowPosition, false, bl);
        } else {
            this.open_conglom.lockPositionForRead(rowPosition, null, false, bl);
        }
        boolean bl3 = bl2 = rowPosition.current_page.fetchFromSlot(rowPosition.current_rh, rowPosition.current_slot, dataValueDescriptorArray, new FetchDescriptor(dataValueDescriptorArray.length, formatableBitSet, null), false) != null;
        if (!this.open_conglom.isForUpdate()) {
            this.open_conglom.unlockPositionAfterRead(rowPosition);
        }
        rowPosition.current_page.unlatch();
        return bl2;
    }

    public boolean replace(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RowPosition rowPosition = new RowPosition();
        this.getRowPositionFromRowLocation(rowLocation, rowPosition);
        this.open_conglom.latchPage(rowPosition);
        this.open_conglom.lockPositionForWrite(rowPosition, false, true);
        boolean bl = true;
        if (rowPosition.current_page.isDeletedAtSlot(rowPosition.current_slot)) {
            bl = false;
        } else {
            rowPosition.current_page.updateAtSlot(rowPosition.current_slot, dataValueDescriptorArray, formatableBitSet);
        }
        rowPosition.current_page.unlatch();
        return bl;
    }

    public int insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public void insertAndFetchLocation(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public boolean lockRow(RowLocation rowLocation, int n, boolean bl, int n2) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public boolean lockRow(long l, int n, int n2, boolean bl, int n3) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public void unlockRowAfterRead(RowLocation rowLocation, boolean bl, boolean bl2) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }
}

