/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.CastUtils;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleToChunkBox
extends AbstractFullBox {
    List<Entry> entries = Collections.emptyList();
    public static final String TYPE = "stsc";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public SampleToChunkBox() {
        super(TYPE);
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    /*
     * WARNING - void declaration
     */
    public void setEntries(List<Entry> list) {
        void entries;
        List<Entry> list2 = list;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, list2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    @Override
    protected long getContentSize() {
        return this.entries.size() * 12 + 8;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        int entryCount = CastUtils.l2i(IsoTypeReader.readUInt32(content));
        this.entries = new ArrayList<Entry>(entryCount);
        int i = 0;
        while (i < entryCount) {
            this.entries.add(new Entry(IsoTypeReader.readUInt32(content), IsoTypeReader.readUInt32(content), IsoTypeReader.readUInt32(content)));
            ++i;
        }
    }

    @Override
    protected void getContent(ByteBuffer bb) throws IOException {
        this.writeVersionAndFlags(bb);
        IsoTypeWriter.writeUInt32(bb, this.entries.size());
        for (Entry entry : this.entries) {
            IsoTypeWriter.writeUInt32(bb, entry.getFirstChunk());
            IsoTypeWriter.writeUInt32(bb, entry.getSamplesPerChunk());
            IsoTypeWriter.writeUInt32(bb, entry.getSampleDescriptionIndex());
        }
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return "SampleToChunkBox[entryCount=" + this.entries.size() + "]";
    }

    /*
     * WARNING - void declaration
     */
    public long[] blowup(int n) {
        void chunkCount;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        long[] numberOfSamples = new long[chunkCount];
        LinkedList<Entry> sampleToChunkEntries = new LinkedList<Entry>(this.entries);
        Collections.reverse(sampleToChunkEntries);
        Iterator iterator = sampleToChunkEntries.iterator();
        Entry currentEntry = (Entry)iterator.next();
        int i = numberOfSamples.length;
        while (i > 1) {
            numberOfSamples[i - 1] = currentEntry.getSamplesPerChunk();
            if ((long)i == currentEntry.getFirstChunk()) {
                currentEntry = (Entry)iterator.next();
            }
            --i;
        }
        numberOfSamples[0] = currentEntry.getSamplesPerChunk();
        return numberOfSamples;
    }

    static {
        SampleToChunkBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SampleToChunkBox.java", SampleToChunkBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.coremedia.iso.boxes.SampleToChunkBox", "", "", "", "java.util.List"), 46);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.coremedia.iso.boxes.SampleToChunkBox", "java.util.List", "entries", "", "void"), 50);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.coremedia.iso.boxes.SampleToChunkBox", "", "", "", "java.lang.String"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "blowup", "com.coremedia.iso.boxes.SampleToChunkBox", "int", "chunkCount", "", "[J"), 94);
    }

    public static class Entry {
        long firstChunk;
        long samplesPerChunk;
        long sampleDescriptionIndex;

        public Entry(long firstChunk, long samplesPerChunk, long sampleDescriptionIndex) {
            this.firstChunk = firstChunk;
            this.samplesPerChunk = samplesPerChunk;
            this.sampleDescriptionIndex = sampleDescriptionIndex;
        }

        public long getFirstChunk() {
            return this.firstChunk;
        }

        public void setFirstChunk(long firstChunk) {
            this.firstChunk = firstChunk;
        }

        public long getSamplesPerChunk() {
            return this.samplesPerChunk;
        }

        public void setSamplesPerChunk(long samplesPerChunk) {
            this.samplesPerChunk = samplesPerChunk;
        }

        public long getSampleDescriptionIndex() {
            return this.sampleDescriptionIndex;
        }

        public void setSampleDescriptionIndex(long sampleDescriptionIndex) {
            this.sampleDescriptionIndex = sampleDescriptionIndex;
        }

        public String toString() {
            return "Entry{firstChunk=" + this.firstChunk + ", samplesPerChunk=" + this.samplesPerChunk + ", sampleDescriptionIndex=" + this.sampleDescriptionIndex + '}';
        }
    }
}

