/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableD {
    private String name;
    private String location;
    private Map<Short, Descriptor> map;

    public TableD(String name, String location) {
        this.name = name;
        this.location = location;
        this.map = new HashMap<Short, Descriptor>();
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    Descriptor addDescriptor(short x, short y, String name, List<Short> seq) {
        short id = (short)(49152 + (x << 8) + y);
        Descriptor d = new Descriptor(x, y, name, seq);
        this.map.put(id, d);
        return d;
    }

    public Descriptor getDescriptor(short id) {
        return this.map.get(id);
    }

    public Collection<Descriptor> getDescriptors() {
        return this.map.values();
    }

    public void show(Formatter out) {
        Set<Short> keys = this.map.keySet();
        ArrayList<Short> sortKeys = new ArrayList<Short>(keys);
        Collections.sort(sortKeys);
        out.format("Table D %s %n", this.name);
        for (Short key : sortKeys) {
            Descriptor dd = this.map.get(key);
            dd.show(out, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Descriptor
    implements Comparable<Descriptor> {
        private short x;
        private short y;
        private String name;
        private List<Short> seq;
        private boolean localOverride;

        Descriptor(short x, short y, String name, List<Short> seq) {
            this.x = x;
            this.y = y;
            this.name = name;
            this.seq = seq;
        }

        public List<Short> getSequence() {
            return this.seq;
        }

        public void addFeature(short f) {
            this.seq.add(f);
        }

        public String getName() {
            return this.name;
        }

        public short getId() {
            return (short)(49152 + (this.x << 8) + this.y);
        }

        public String getFxy() {
            return "3-" + this.x + "-" + this.y;
        }

        public String toString() {
            return this.getFxy() + " " + this.getName();
        }

        public void show(Formatter out, boolean oneline) {
            out.format(" %8s: name=(%s) seq=", this.getFxy(), this.name);
            if (oneline) {
                for (short s : this.seq) {
                    out.format(" %s,", ucar.nc2.iosp.bufr.Descriptor.makeString(s));
                }
                out.format("%n", new Object[0]);
            } else {
                for (short s : this.seq) {
                    out.format("    %s%n", ucar.nc2.iosp.bufr.Descriptor.makeString(s));
                }
            }
        }

        @Override
        public int compareTo(Descriptor o) {
            return this.getId() - o.getId();
        }

        public boolean isLocal() {
            return this.x >= 48 || this.y >= 192;
        }

        public void setLocalOverride(boolean isOverride) {
            this.localOverride = isOverride;
        }

        public boolean getLocalOverride() {
            return this.localOverride;
        }
    }
}

