/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.AuxObject;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.LongColumnException;
import org.apache.derby.impl.store.raw.data.OverflowInputStream;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;

public abstract class BasePage
implements Page,
Lockable,
Observer,
TypedFormat {
    private AuxObject auxObj;
    protected PageKey identity;
    private StoredRecordHeader[] headers;
    private int recordCount;
    protected BaseContainerHandle owner;
    private int nestedLatch;
    private Latch myLatch;
    protected boolean inClean;
    protected boolean preLatch;
    private LogInstant lastLog;
    private long pageVersion = 0L;
    private byte pageStatus;
    public static final byte VALID_PAGE = 1;
    public static final byte INVALID_PAGE = 2;
    public static final int INIT_PAGE_REUSE = 1;
    public static final int INIT_PAGE_OVERFLOW = 2;
    public static final int INIT_PAGE_REUSE_RECORDID = 4;
    public static final int LOG_RECORD_DEFAULT = 0;
    public static final int LOG_RECORD_FOR_UPDATE = 1;
    public static final int LOG_RECORD_FOR_PURGE = 2;
    private static final RecordHandle InvalidRecordHandle = new RecordId(new PageKey(new ContainerKey(0L, 0L), -1L), 0);

    protected BasePage() {
    }

    protected void initialize() {
        this.setAuxObject(null);
        this.identity = null;
        this.recordCount = 0;
        this.clearLastLogInstant();
    }

    protected void initializeHeaders(int n) {
        this.headers = new StoredRecordHeader[n];
    }

    protected void fillInIdentity(PageKey pageKey) {
        this.identity = pageKey;
    }

    public void clearIdentity() {
        this.identity = null;
        this.cleanPageForReuse();
    }

    protected void cleanPageForReuse() {
        this.setAuxObject(null);
        this.recordCount = 0;
    }

    public Object getIdentity() {
        return this.identity;
    }

    public final RecordHandle getInvalidRecordHandle() {
        return InvalidRecordHandle;
    }

    public static final RecordHandle MakeRecordHandle(PageKey pageKey, int n) throws StandardException {
        if (n >= 6) {
            throw StandardException.newException("XSDAE.S", new Long(n));
        }
        return new RecordId(pageKey, n);
    }

    public final RecordHandle makeRecordHandle(int n) throws StandardException {
        return BasePage.MakeRecordHandle(this.getPageId(), n);
    }

    public final long getPageNumber() {
        return this.identity.getPageNumber();
    }

    public final RecordHandle getRecordHandle(int n) {
        int n2 = this.findRecordById(n, 0);
        if (n2 < 0) {
            return null;
        }
        return this.getRecordHandleAtSlot(n2);
    }

    public final RecordHandle getRecordHandleAtSlot(int n) {
        return this.getHeaderAtSlot(n).getHandle(this.getPageId(), n);
    }

    public final boolean recordExists(RecordHandle recordHandle, boolean bl) throws StandardException {
        if (recordHandle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", recordHandle);
        }
        if (recordHandle.getPageNumber() != this.getPageNumber()) {
            return false;
        }
        int n = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        return n >= 0 && (bl || !this.isDeletedAtSlot(n));
    }

    public RecordHandle fetch(RecordHandle recordHandle, Object[] objectArray, FormatableBitSet formatableBitSet, boolean bl) throws StandardException {
        this.owner.getLockingPolicy().lockRecordForRead(this.myLatch, recordHandle, bl);
        int n = this.getSlotNumber(recordHandle);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (storedRecordHeader.isDeleted()) {
            return null;
        }
        FetchDescriptor fetchDescriptor = new FetchDescriptor(objectArray.length, formatableBitSet, null);
        this.restoreRecordFromSlot(n, objectArray, fetchDescriptor, recordHandle, storedRecordHeader, true);
        this.owner.getLockingPolicy().unlockRecordAfterRead(this.owner.getTransaction(), this.owner, recordHandle, bl, true);
        return recordHandle;
    }

    public RecordHandle fetchFromSlot(RecordHandle recordHandle, int n, Object[] objectArray, FetchDescriptor fetchDescriptor, boolean bl) throws StandardException {
        this.checkSlotOnPage(n);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n);
        if (recordHandle == null) {
            recordHandle = storedRecordHeader.getHandle(this.getPageId(), n);
        }
        if (!bl && storedRecordHeader.isDeleted()) {
            return null;
        }
        return this.restoreRecordFromSlot(n, objectArray, fetchDescriptor, recordHandle, storedRecordHeader, true) ? recordHandle : null;
    }

    public final RecordHandle fetchFieldFromSlot(int n, int n2, Object object) throws StandardException {
        Object[] objectArray = new Object[n2 + 1];
        objectArray[n2] = object;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2 + 1);
        formatableBitSet.set(n2);
        FetchDescriptor fetchDescriptor = new FetchDescriptor(n2 + 1, formatableBitSet, null);
        return this.fetchFromSlot(null, n, objectArray, fetchDescriptor, true);
    }

    public final int getSlotNumber(RecordHandle recordHandle) throws StandardException {
        int n = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        if (n < 0) {
            throw StandardException.newException("XSRS9.S", recordHandle);
        }
        return n;
    }

    public final int getNextSlotNumber(RecordHandle recordHandle) throws StandardException {
        int n = this.findNextRecordById(recordHandle.getId());
        return n;
    }

    public RecordHandle insertAtSlot(int n, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n2) throws StandardException {
        if ((by & 1) == 1) {
            return this.insertNoOverflow(n, objectArray, formatableBitSet, logicalUndo, by, n2);
        }
        return this.insertAllowOverflow(n, objectArray, formatableBitSet, 0, by, n2, null);
    }

    protected RecordHandle insertNoOverflow(int n, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n2) throws StandardException {
        int n3;
        RecordId recordId;
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (n < 0 || n > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        if (!this.allowInsert()) {
            return null;
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        if (logicalUndo != null) {
            rawTransaction.checkLogicalOperationOk();
        }
        do {
            n3 = this.newRecordIdAndBump();
            recordId = new RecordId(this.getPageId(), n3, n);
        } while (!this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordId, true, false));
        this.owner.getActionSet().actionInsert(rawTransaction, this, n, n3, objectArray, formatableBitSet, logicalUndo, by, 0, false, -1, null, -1, n2);
        return recordId;
    }

    public final RecordHandle insert(Object[] objectArray, FormatableBitSet formatableBitSet, byte by, int n) throws StandardException {
        if ((by & 1) == 1) {
            return this.insertAtSlot(this.recordCount, objectArray, formatableBitSet, null, by, n);
        }
        return this.insertAllowOverflow(this.recordCount, objectArray, formatableBitSet, 0, by, n, null);
    }

    public RecordHandle insertAllowOverflow(int n, Object[] objectArray, FormatableBitSet formatableBitSet, int n2, byte by, int n3, RecordHandle recordHandle) throws StandardException {
        BasePage basePage = this;
        if (!basePage.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        RecordId recordId = null;
        RecordId recordId2 = null;
        RawTransaction rawTransaction = basePage.owner.getTransaction();
        while (basePage.allowInsert()) {
            if (basePage != this) {
                n = basePage.recordCount;
            }
            boolean bl = false;
            int n4 = -1;
            int n5 = -1;
            DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
            int n6 = basePage.newRecordIdAndBump();
            RecordId recordId3 = new RecordId(basePage.getPageId(), n6, n);
            if (basePage == this) {
                if (recordId2 == null) {
                    while (!this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordId3, true, false)) {
                        n6 = basePage.newRecordIdAndBump();
                        recordId3 = new RecordId(basePage.getPageId(), n6, n);
                    }
                }
                recordId = recordId3;
            }
            do {
                try {
                    n2 = this.owner.getActionSet().actionInsert(rawTransaction, basePage, n, n6, objectArray, formatableBitSet, null, by, n2, false, n4, dynamicByteArrayOutputStream, n5, n3);
                    bl = false;
                }
                catch (LongColumnException longColumnException) {
                    dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(longColumnException.getLogBuffer());
                    RecordHandle recordHandle2 = this.insertLongColumn(basePage, longColumnException, by);
                    int n7 = 0;
                    try {
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    n4 = longColumnException.getNextColumn() + 1;
                    n5 = longColumnException.getRealSpaceOnPage() - (n7 += this.appendOverflowFieldHeader(dynamicByteArrayOutputStream, recordHandle2));
                    bl = true;
                }
            } while (bl);
            if (recordId2 != null) {
                this.updateOverflowDetails(recordId2, recordId3);
            }
            if (n2 == -1) {
                if (basePage != this) {
                    basePage.unlatch();
                }
                if (recordHandle != null) {
                    this.updateOverflowDetails(recordId3, recordHandle);
                }
                return recordId;
            }
            recordId2 = recordId3;
            BasePage basePage2 = basePage.getOverflowPageForInsert(n, objectArray, formatableBitSet, n2);
            if (basePage != this) {
                basePage.unlatch();
            }
            basePage = basePage2;
        }
        return null;
    }

    protected RecordHandle insertLongColumn(BasePage basePage, LongColumnException longColumnException, byte by) throws StandardException {
        Object[] objectArray = new Object[]{longColumnException.getColumn()};
        RecordId recordId = null;
        RecordId recordId2 = null;
        RecordId recordId3 = null;
        BasePage basePage2 = basePage;
        BasePage basePage3 = null;
        boolean bl = true;
        int n = 0;
        RawTransaction rawTransaction = basePage2.owner.getTransaction();
        do {
            if (!bl) {
                basePage3 = basePage2;
                recordId3 = recordId2;
            }
            basePage2 = this.getNewOverflowPage();
            int n2 = basePage2.recordCount;
            int n3 = basePage2.newRecordId();
            recordId2 = new RecordId(basePage2.getPageId(), n3, n2);
            if (bl) {
                recordId = recordId2;
            }
            n = this.owner.getActionSet().actionInsert(rawTransaction, basePage2, n2, n3, objectArray, null, null, by, n, true, -1, null, -1, 100);
            if (!bl) {
                basePage3.updateFieldOverflowDetails(recordId3, recordId2);
                basePage3.unlatch();
                basePage3 = null;
                continue;
            }
            bl = false;
        } while (n != -1);
        if (basePage2 != null) {
            basePage2.unlatch();
            basePage2 = null;
        }
        return recordId;
    }

    public abstract void preDirty();

    public abstract void updateOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract void updateFieldOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract int appendOverflowFieldHeader(DynamicByteArrayOutputStream var1, RecordHandle var2) throws StandardException, IOException;

    public abstract BasePage getOverflowPageForInsert(int var1, Object[] var2, FormatableBitSet var3, int var4) throws StandardException;

    protected abstract BasePage getNewOverflowPage() throws StandardException;

    public final boolean update(RecordHandle recordHandle, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        this.owner.getLockingPolicy().lockRecordForWrite(this.myLatch, recordHandle);
        int n = this.getSlotNumber(recordHandle);
        if (this.isDeletedAtSlot(n)) {
            return false;
        }
        this.doUpdateAtSlot(rawTransaction, n, recordHandle.getId(), objectArray, formatableBitSet);
        return true;
    }

    public boolean delete(RecordHandle recordHandle, LogicalUndo logicalUndo) throws StandardException {
        this.owner.getLockingPolicy().lockRecordForWrite(this.myLatch, recordHandle);
        int n = this.getSlotNumber(recordHandle);
        if (this.isDeletedAtSlot(n)) {
            return false;
        }
        this.deleteAtSlot(n, true, logicalUndo);
        return true;
    }

    public final RecordHandle updateAtSlot(int n, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (this.isDeletedAtSlot(n)) {
            throw StandardException.newException("XSDA2.S");
        }
        RecordHandle recordHandle = this.getRecordHandleAtSlot(n);
        RawTransaction rawTransaction = this.owner.getTransaction();
        this.doUpdateAtSlot(rawTransaction, n, recordHandle.getId(), objectArray, formatableBitSet);
        return recordHandle;
    }

    public abstract void doUpdateAtSlot(RawTransaction var1, int var2, int var3, Object[] var4, FormatableBitSet var5) throws StandardException;

    public RecordHandle updateFieldAtSlot(int n, int n2, Object object, LogicalUndo logicalUndo) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (this.isDeletedAtSlot(n)) {
            throw StandardException.newException("XSDA2.S");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        RecordHandle recordHandle = this.getRecordHandleAtSlot(n);
        this.owner.getActionSet().actionUpdateField(rawTransaction, this, n, recordHandle.getId(), n2, object, logicalUndo);
        return recordHandle;
    }

    public final int fetchNumFields(RecordHandle recordHandle) throws StandardException {
        return this.fetchNumFieldsAtSlot(this.getSlotNumber(recordHandle));
    }

    public int fetchNumFieldsAtSlot(int n) throws StandardException {
        return this.getHeaderAtSlot(n).getNumberFields();
    }

    public RecordHandle deleteAtSlot(int n, boolean bl, LogicalUndo logicalUndo) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (bl) {
            if (this.isDeletedAtSlot(n)) {
                throw StandardException.newException("XSDA2.S");
            }
        } else if (!this.isDeletedAtSlot(n)) {
            throw StandardException.newException("XSDA5.S");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        if (logicalUndo != null) {
            rawTransaction.checkLogicalOperationOk();
        }
        RecordHandle recordHandle = this.getRecordHandleAtSlot(n);
        this.owner.getActionSet().actionDelete(rawTransaction, this, n, recordHandle.getId(), bl, logicalUndo);
        return recordHandle;
    }

    public void purgeAtSlot(int n, int n2, boolean bl) throws StandardException {
        if (n2 <= 0) {
            return;
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (n < 0 || n + n2 > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        int[] nArray = new int[n2];
        PageKey pageKey = this.getPageId();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.getHeaderAtSlot(n + i).getId();
            RecordHandle recordHandle = this.getRecordHandleAtSlot(n);
            this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordHandle, false, true);
            if (this.owner.isTemporaryContainer() || this.entireRecordOnPage(n + i)) continue;
            RecordHandle recordHandle2 = this.getHeaderAtSlot(n + i).getHandle(pageKey, n + i);
            this.purgeRowPieces(rawTransaction, n + i, recordHandle2, bl);
        }
        this.owner.getActionSet().actionPurge(rawTransaction, this, n, n2, nArray, bl);
    }

    protected abstract void purgeRowPieces(RawTransaction var1, int var2, RecordHandle var3, boolean var4) throws StandardException;

    public void copyAndPurge(Page page, int n, int n2, int n3) throws StandardException {
        if (n2 <= 0) {
            throw StandardException.newException("XSDAD.S");
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (n < 0 || n + n2 > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        BasePage basePage = (BasePage)page;
        PageKey pageKey = this.getPageId();
        if (!pageKey.getContainerId().equals(basePage.getPageId().getContainerId())) {
            throw StandardException.newException("XSDAC.S", pageKey.getContainerId(), (Object)basePage.getPageId().getContainerId());
        }
        int[] nArray = new int[n2];
        RawTransaction rawTransaction = this.owner.getTransaction();
        for (int i = 0; i < n2; ++i) {
            RecordHandle recordHandle = this.getRecordHandleAtSlot(n + i);
            this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordHandle, false, true);
            nArray[i] = this.getHeaderAtSlot(n + i).getId();
        }
        basePage.copyInto(this, n, n2, n3);
        this.owner.getActionSet().actionPurge(rawTransaction, this, n, n2, nArray, true);
    }

    public void unlatch() {
        this.releaseExclusive();
    }

    public boolean isLatched() {
        return this.owner != null;
    }

    public final int recordCount() {
        return this.recordCount;
    }

    protected abstract int internalDeletedRecordCount();

    protected int internalNonDeletedRecordCount() {
        if (this.pageStatus != 1) {
            return 0;
        }
        int n = this.internalDeletedRecordCount();
        if (n == -1) {
            int n2 = 0;
            int n3 = this.recordCount;
            for (int i = 0; i < n3; ++i) {
                if (this.isDeletedOnPage(i)) continue;
                ++n2;
            }
            return n2;
        }
        return this.recordCount - n;
    }

    public int nonDeletedRecordCount() {
        return this.internalNonDeletedRecordCount();
    }

    protected final boolean isDeletedOnPage(int n) {
        return this.getHeaderAtSlot(n).isDeleted();
    }

    public boolean isDeletedAtSlot(int n) throws StandardException {
        this.checkSlotOnPage(n);
        return this.isDeletedOnPage(n);
    }

    public void setAuxObject(AuxObject auxObject) {
        if (this.auxObj != null) {
            this.auxObj.auxObjectInvalidated();
        }
        this.auxObj = auxObject;
    }

    public AuxObject getAuxObject() {
        return this.auxObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockEvent(Latch latch) {
        BasePage basePage = this;
        synchronized (basePage) {
            this.myLatch = latch;
            this.owner = (BaseContainerHandle)latch.getQualifier();
            this.owner.addObserver(this);
            this.preLatch = true;
        }
    }

    public boolean requestCompatible(Object object, Object object2) {
        return false;
    }

    public boolean lockerAlwaysCompatible() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockEvent(Latch latch) {
        BasePage basePage = this;
        synchronized (basePage) {
            this.owner.deleteObserver(this);
            this.owner = null;
            this.myLatch = null;
            if (this.inClean) {
                this.notifyAll();
            }
        }
    }

    public void update(Observable observable, Object object) {
        this.releaseExclusive();
    }

    public PageKey getPageId() {
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExclusive(BaseContainerHandle baseContainerHandle) throws StandardException {
        RawTransaction rawTransaction = baseContainerHandle.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && rawTransaction == this.owner.getTransaction() && rawTransaction.inAbort()) {
                ++this.nestedLatch;
                return;
            }
        }
        rawTransaction.getLockFactory().latchObject(rawTransaction, this, baseContainerHandle, -1);
        basePage = this;
        synchronized (basePage) {
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.preLatch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setExclusiveNoWait(BaseContainerHandle baseContainerHandle) throws StandardException {
        RawTransaction rawTransaction = baseContainerHandle.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && rawTransaction == this.owner.getTransaction() && rawTransaction.inAbort()) {
                ++this.nestedLatch;
                return true;
            }
        }
        boolean bl = rawTransaction.getLockFactory().latchObject(rawTransaction, this, baseContainerHandle, 0);
        if (!bl) {
            return false;
        }
        BasePage basePage2 = this;
        synchronized (basePage2) {
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.preLatch = false;
        }
        return true;
    }

    protected void releaseExclusive() {
        if (this.nestedLatch > 0) {
            --this.nestedLatch;
            return;
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        rawTransaction.getLockFactory().unlatch(this.myLatch);
    }

    protected final void setHeaderAtSlot(int n, StoredRecordHeader storedRecordHeader) {
        if (n < this.headers.length) {
            if (storedRecordHeader != null) {
                this.headers[n] = storedRecordHeader;
            }
        } else {
            StoredRecordHeader[] storedRecordHeaderArray = new StoredRecordHeader[n + 1];
            System.arraycopy(this.headers, 0, storedRecordHeaderArray, 0, this.headers.length);
            this.headers = storedRecordHeaderArray;
            this.headers[n] = storedRecordHeader;
        }
    }

    protected final void bumpRecordCount(int n) {
        this.recordCount += n;
    }

    public final StoredRecordHeader getHeaderAtSlot(int n) {
        if (n < this.headers.length) {
            StoredRecordHeader storedRecordHeader = this.headers[n];
            return storedRecordHeader != null ? storedRecordHeader : this.recordHeaderOnDemand(n);
        }
        return this.recordHeaderOnDemand(n);
    }

    public abstract boolean entireRecordOnPage(int var1) throws StandardException;

    public abstract StoredRecordHeader recordHeaderOnDemand(int var1);

    private final void checkSlotOnPage(int n) throws StandardException {
        if (n >= 0 && n < this.recordCount) {
            return;
        }
        throw StandardException.newException("XSDA1.S");
    }

    public int setDeleteStatus(int n, boolean bl) throws StandardException, IOException {
        return this.getHeaderAtSlot(n).setDeleted(bl);
    }

    public void deallocatePage() throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        this.owner.getActionSet().actionInvalidatePage(rawTransaction, this);
    }

    public void initPage(int n, long l) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        this.owner.getActionSet().actionInitPage(rawTransaction, this, n, this.getTypeFormatId(), l);
    }

    public int findRecordById(int n, int n2) {
        if (n2 == 0) {
            n2 = n - 6;
        }
        int n3 = this.recordCount();
        if (n2 > 0 && n2 < n3 && n == this.getHeaderAtSlot(n2).getId()) {
            return n2;
        }
        for (int i = 0; i < n3; ++i) {
            if (n != this.getHeaderAtSlot(i).getId()) continue;
            return i;
        }
        return -1;
    }

    private int findNextRecordById(int n) {
        int n2 = this.recordCount();
        for (int i = 0; i < n2; ++i) {
            if (this.getHeaderAtSlot(i).getId() <= n) continue;
            return i;
        }
        return -1;
    }

    private void copyInto(BasePage basePage, int n, int n2, int n3) throws StandardException {
        if (n3 < 0 || n3 > this.recordCount) {
            throw StandardException.newException("XSDA1.S");
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        int[] nArray = new int[n2];
        PageKey pageKey = this.getPageId();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i == 0 ? this.newRecordId() : this.newRecordId(nArray[i - 1]);
            RecordId recordId = new RecordId(pageKey, nArray[i], i);
            this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordId, false, true);
        }
        this.owner.getActionSet().actionCopyRows(rawTransaction, this, basePage, n3, n2, n, nArray);
    }

    protected void removeAndShiftDown(int n) {
        System.arraycopy(this.headers, n + 1, this.headers, n, this.headers.length - (n + 1));
        this.headers[this.headers.length - 1] = null;
        --this.recordCount;
    }

    protected StoredRecordHeader shiftUp(int n) {
        if (n < this.headers.length) {
            System.arraycopy(this.headers, n, this.headers, n + 1, this.headers.length - (n + 1));
            this.headers[n] = null;
        }
        return null;
    }

    public void compactRecord(RecordHandle recordHandle) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1");
        }
        if (recordHandle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", recordHandle);
        }
        if (recordHandle.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException("XSDAK.S", recordHandle);
        }
        if (this.isOverflowPage()) {
            throw StandardException.newException("XSDAL.S", recordHandle);
        }
        int n = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        if (n >= 0) {
            this.compactRecord(this.owner.getTransaction(), n, recordHandle.getId());
        }
    }

    public final LogInstant getLastLogInstant() {
        return this.lastLog;
    }

    protected final void clearLastLogInstant() {
        this.lastLog = null;
    }

    protected final void updateLastLogInstant(LogInstant logInstant) {
        if (logInstant != null) {
            this.lastLog = logInstant;
        }
    }

    public final long getPageVersion() {
        return this.pageVersion;
    }

    protected final long bumpPageVersion() {
        return ++this.pageVersion;
    }

    public final void setPageVersion(long l) {
        this.pageVersion = l;
    }

    protected void setPageStatus(byte by) {
        this.pageStatus = by;
    }

    public byte getPageStatus() {
        return this.pageStatus;
    }

    protected abstract boolean restoreRecordFromSlot(int var1, Object[] var2, FetchDescriptor var3, RecordHandle var4, StoredRecordHeader var5, boolean var6) throws StandardException;

    protected abstract void restorePortionLongColumn(OverflowInputStream var1) throws StandardException, IOException;

    public abstract int newRecordId() throws StandardException;

    public abstract int newRecordIdAndBump() throws StandardException;

    protected abstract int newRecordId(int var1) throws StandardException;

    public abstract boolean spaceForCopy(int var1, int[] var2) throws StandardException;

    public abstract int getTotalSpace(int var1) throws StandardException;

    public abstract int getReservedCount(int var1) throws IOException;

    public abstract int getRecordLength(int var1) throws IOException;

    public abstract void restoreRecordFromStream(LimitObjectInput var1, Object[] var2) throws StandardException, IOException;

    public abstract void logRecord(int var1, int var2, int var3, FormatableBitSet var4, OutputStream var5, RecordHandle var6) throws StandardException, IOException;

    public abstract int logRow(int var1, boolean var2, int var3, Object[] var4, FormatableBitSet var5, DynamicByteArrayOutputStream var6, int var7, byte var8, int var9, int var10, int var11) throws StandardException, IOException;

    public abstract void logField(int var1, int var2, OutputStream var3) throws StandardException, IOException;

    public abstract void logColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4, int var5) throws StandardException, IOException;

    public abstract int logLongColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4) throws StandardException, IOException;

    public abstract void storeRecord(LogInstant var1, int var2, boolean var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void storeField(LogInstant var1, int var2, int var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void reserveSpaceForSlot(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract void skipField(ObjectInput var1) throws StandardException, IOException;

    public abstract void skipRecord(ObjectInput var1) throws StandardException, IOException;

    public abstract void setDeleteStatus(LogInstant var1, int var2, boolean var3) throws StandardException, IOException;

    public abstract void purgeRecord(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    protected abstract void compactRecord(RawTransaction var1, int var2, int var3) throws StandardException;

    public abstract void setPageStatus(LogInstant var1, byte var2) throws StandardException;

    public abstract void initPage(LogInstant var1, byte var2, int var3, boolean var4, boolean var5) throws StandardException;

    public abstract void setReservedSpace(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract boolean isOverflowPage();

    public abstract boolean allowInsert();

    public abstract boolean unfilled();

    public abstract void setContainerRowCount(long var1);

    protected String slotTableToString() {
        String string = null;
        return string;
    }

    public boolean lockAttributes(int n, Hashtable hashtable) {
        if ((n & 1) == 0) {
            return false;
        }
        PageKey pageKey = this.identity;
        if (pageKey == null) {
            return false;
        }
        hashtable.put("CONTAINERID", new Long(pageKey.getContainerId().getContainerId()));
        hashtable.put("LOCKNAME", pageKey.toString());
        hashtable.put("TYPE", "LATCH");
        return true;
    }
}

