/* Hashpw.c

   by William K. Nickless, November, 1992.
   for the Mathematics & Computer Science Division of Argonne National Lab.

   This is an addition to the Crack system.  It builds against crack-lib.
    
   The purpose is to generate all of Crack's manglings of words from
   words on the standard input.  The only command line argument should be
   a list of Crack v4.1 rules.  Standard input should be a dictionary of 
   words, one word per line.  Standard output (if all goes well) will be
   the mangled versions of the input words.

*/

#include <stdio.h>
#include <malloc.h>
#include "crack.h"

main(argc,argv)	
int argc;
char **argv;
{
	char buf[STRINGSIZE],*s;
	int loop;
	FILE *rulefile;
	struct RULE *ruleptr, rulehead;

	rulehead.next=(struct RULE *)NULL;
	rulehead.rule=(char *)NULL;
	ruleptr=&rulehead;

	if(argc!=2) { 
		fprintf(stderr, "Usage: %s rulefile\n", argv[0]);
		exit(-1);
	}

	if(!(rulefile=fopen(argv[1],"r"))) {
		fprintf(stderr, "Unable to open %s\n", argv[1]);
		exit(-2);
	}

	while(fgets(buf,STRINGSIZE,rulefile)) {
		buf[strlen(buf)-1]=0;
		if(!buf[0]) continue;
		if(buf[0]=='#') continue;
		if(isspace(buf[0])) continue;
		s=(char *)malloc(STRINGSIZE);
		strcpy(s,buf);
		ruleptr->rule=s;
		ruleptr->next=(struct RULE *)malloc(sizeof(struct RULE));
		ruleptr=ruleptr->next;
		ruleptr->rule=NULL;
	}	

	fclose(rulefile);

	while(fgets(buf,STRINGSIZE,stdin)) {
		buf[strlen(buf)-1]=0;
		ruleptr=&rulehead;
		while(ruleptr->rule) {
			if(s=Mangle(buf,ruleptr->rule))
				puts(s);
			ruleptr=ruleptr->next;
		}
	}		

}

/* We're not debugging the rule file here, so ignore any problems. */

Log()
{}
