/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/* Generated by Interface Builder */

#import <objc/Object.h>
#import <appkit/graphics.h>

/* Manages global operations: does new, open, save.
 * Also manages inspector panels.
 */

@interface Distributor:Object
{
  NXCoord linkx, linky;  /* Coordinates for next link window to appear at */
  int nextUntNum;        /* Next number for untitled window */
  id toolPanel, toolMatrix;
  
  /*** Inspector variables ***/
  BOOL inspectorOn;      /* YES if inspector is on-screen */
  id currentPanel;       /* Either editor or displayer inspector */
  NXCoord topLeftx;
  NXCoord topLefty;

  
  /*** Outlets to Inspector panels ***/
  id editorInspector;
  id displayerInspector;
  id nonInspector;

  /*** Editor Inspector Controls ***/
  id rulersB;
  id arrowsB;
  id axesB;
  id verticesB;
  id anchorPointsB;
  id sparseSlider;
  id sparseText;
  
  /*** Displayer Inspector Controls ***/
  
  /* Sliders */
  id ampSlider;
  id ampBSlider;
  id fffaSlider;
  id fffbSlider;
  id ppcSlider;
  id segMaxSlider;
  id segScaleSlider;
  id sepSlider;

  /* Text fields */
  id ampText;
  id ampBText;
  id fffaText;
  id fffbText;
  id ppcText;
  id segMaxText;
  id segScaleText;
  id sepText;

  /* Radio button matrices */
  id redrawRB;
  id textureRB;


  /***** File operation stuff *****/
  id saveAccessory;
  id formatRB;

  /***** Global settings *****/
  char segmentSounds;      /* ... whether to play the sounds */
  char obnoxiousSounds;

  /***** Formatting *****/
  id list;                 /* List of all links in memory */
  id browser;              /* Displays all links in memory */
  BOOL isBrowserValid;     /* Whether list in browser is valid */
  id formatCP;             /* Formatting control panel */
  id formatWindow;
  id fullView;
  id fullViewBox;
  id fStatusPanel;
  id fStatusText;

  /**** Info panel ****/
  id infoPanel;
}


/*** Inspector actions ***/

/* Editor setting RB tags */
#define RULERS        0
#define ARROWS        1
#define AXES          2
#define VERTICES      3
#define ANCHOR_POINTS 4
- updateESettings:sender;
- setDefaults:sender;
- revert:sender;
- applyToAll:sender;
- redraw:sender;

/*** Other inspector methods ***/

- showInspector:sender;
- readParametersTo:(float **) values;
- writeParametersFrom:(float **) values;
- (char) getRedrawType;
- switchInspectorTo: (char) mode;

- Quit:sender;
- Print:sender;
- getNextWinLoc :(NXCoord *) x :(NXCoord *) y;

/*** File operation stuff ***/
/* File format constants */
#define FF_LINKTOOL    0
#define FF_EDITOR      1
#define FF_MATRIX      2
#define FF_STRINGBEAN  3
#define FF_THREE_D     4
/* Extensions for different file formats */
#define EXT_LINKTOOL   "ltl"
#define EXT_EDITOR     "lnkp"
#define EXT_MATRIX     "mat"
#define EXT_STRINGBEAN "sbn"
#define EXT_THREE_D    "thd"
#define EXT_FORMAT     "fmt"
- New:sender;
- NewTitle:sender :(char *) title;
- NewFromFile:(const char *) filename;
- open:sender;
- save:sender;
- saveAs:sender;
- doSave:(const char *) filename :(char) file_type;
- openFormat:(const char *) filename;
  
- setTool:sender;
- selectIfNecessary:(int) emode;

/*** Delegate methods for inspector panels ***/

- windowDidMove:sender;
- windowWillClose:sender;
- windowDidResignKey:sender;

/*** Formatting methods ***/

- makeKeyFormatControls:sender;
- deleteMeFromList:link;
- getNewList:(float) sideLength :(id *) imagelist :(id *) labellist;

/* Browser delegate methods */
- (BOOL) browser:callingDude columnIsValid:(int) columnDude;
- (int) browser:sender fillMatrix:matrix inColumn:(int)column;

- showInfo:sender;
@end
