/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/****KEEP FILE****/
/* The main module for wave */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#import <objc/objc.h>
#include "link_types.h"
#include "link_edit_types.h"
#include "link_edit_global.h"
#include "link.h"
#import "EditView.h"
#import "Link.h"


void LinkSetUp(id linkObj)
{
  /*******CHANGE SOME OF THESE VALUES***********/
/*  data->root = box_status.TopWindow; */
  LinkData *data;
  data = [linkObj get_data];
  data->x = 3.169; 
  data->y = 6.856;
  [[linkObj get_editView] getBounds:&data->width :&data->height];
  data->border = LINK_BORDER;

  data->title_present = LINK_NO;
  data->message_present = LINK_YES;
  data->urgent_present = LINK_YES;

  data->xruler = LINK_NO;  /* Show ruler */
  data->yruler = LINK_NO;
  data->xscale = 1.0;
  data->yscale = 1.0;
  strcpy(data->data_font,"6x10");

  strcpy(data->title,"Link Title");
  strcpy(data->message,"Link Message");
  strcpy(data->font,"9x15");

  data->gray = 0.7;
}
