/* $Id: defines.h,v 1.18 90/04/23 13:58:04 pturner Exp Locker: pturner $
 * defines.h
 *
 */

#define onoff(x) ((x)?"ON":"OFF")

#define BIG 1.0e+307
#define MBIG -1.0e+307

#define MAXPLOT 15		/* max number of sets in a graph */
#define MAXGRAPH 10		/* max number of graphs */

#ifndef MAXARR
#	define MAXARR 20000	/* max elements in an array */
#endif

#ifndef GRTOOL_WINFONT
#	define GRTOOL_WINFONT "/usr/lib/fonts/fixedwidthfonts/cour.b.12"
#endif

#define MAXFIT 7		/* max degree of polynomial+1 that can be
				 * fitted */

#define GRAPHXY 1		/* types of graphs */
#define GRAPHBAR 2		/* not used in this version */
#define GRAPHSTACKEDBAR 3
#define GRAPHPOLAR 4

#define MAXBOXES 15		/* max number of boxes */
#define MAXLINES 15		/* max number of lines */

#define MAXSYM 26		/* max number of symbols */

#define MAXSTR 25		/* max number of strings */

#define HISTOSYM 19	/* plotsymbol for histograms */

/* graphics output to the following */
#define GR_SUNVIEW 	0
#define GR_HPGL7550_1L 	1 /* HP 7550 8.5x11 landscape */
#define GR_HPGL7550_1P 	2 /* HP 7550 8.5x11 portrait */
#define GR_HPGL7550_2L 	3 /* HP 7550 11x17 landscape */
#define GR_HPGL7550_2P 	4 /* HP 7550 11x17 portrait */
#define GR_PS_L 	5 /* PostScript landscape */
#define GR_PS_P 	6 /* PostScript portrait */
#define GR_HPGL_II_1L 	7 /* HPGL cartridge in LaserJet II landscape */
#define GR_HPGL_II_1P 	8 /* HPGL cartridge in LaserJet II portrait */
#define GR_RASTER_L 	9 /* Rasterfile landscape (resolution defaults to that of a 300 dpi laser) */
#define GR_RASTER_P 	10 /* Rasterfile portrait (resolution defaults to that of a 300 dpi laser) */
#define GR_GENERIC_L 	11 /* Generic */
#define GR_GENERIC_P 	12 /* Generic */
#define GR_HPLJ300_L 	13 /* hp laser at 300 dpi landscape */
#define GR_HPLJ300_P 	14 /* hp laser at 300 dpi portrait */
#define GR_HPLJ150_L 	15 /* hp laser at 150 dpi landscape */
#define GR_HPLJ150_P 	16 /* hp laser at 150 dpi portrait */
#define GR_HPLJ75_L 	17 /* hp laser at 75 dpi landscape */
#define GR_HPLJ75_P 	18 /* hp laser at 75 dpi portrait */

#ifndef HDEV
/* set HDEV to the default hardcopy device */
#	define HDEV GR_HPLJ150_L
#endif

/* TDEV is always Sunview */
#define TDEV GR_SUNVIEW	

#define TRUE 1
#define FALSE 0

#ifdef HIRES
/* window dimensions for our hi-res mono monitor */
#	define WINDOWW 1261		
#	define WINDOWH 1047
#else
/* window dimensions for lower res screens */
#	define WINDOWW 1000
#	define WINDOWH 800
#endif

/* for canvas event proc */
#define SELECT_REGION 256
#define RUBBER_BAND 512
#define ZOOM_1ST 3
#define ZOOM_2ND 4
#define VIEW_1ST 5
#define VIEW_2ND 6
#define STR_LOC 7
#define LEG_LOC 8
#define FIND_POINT 9
#define DEL_POINT 10
#define DEL_OBJECT 11
#define MOVE_OBJECT_1ST 12
#define MOVE_OBJECT_2ND 13
#define MAKE_BOX_1ST 14
#define MAKE_BOX_2ND 15
#define MAKE_LINE_1ST 16
#define MAKE_LINE_2ND 17
#define SEL_POINT 18
#define STR_EDIT 19
#define COMP_AREA 20
#define COMP_PERIMETER 21
