
#include<stream.h>
#include<stdlib.h>
#include<stdio.h>

const MAX_STATES= 50;
const MAX_LINKS= MAX_STATES*MAX_STATES;
const MAX_STRING_LEN= 20;
const NUM_INPUTS= 2;
const MAX_INPUTS= 20;


class Fsa {
 public:

 Fsa();
 void simulation_loop();
 void initialize();
 void display_link();
 void display_status();

private:


struct {
 int state;
 float time;
} transition[MAX_STATES][MAX_INPUTS];

char state[MAX_STATES][MAX_STRING_LEN];
int state_freq[MAX_STATES],link_freq[MAX_LINKS];
int index,current_state,num_states,control_length,total,i;
int row,col,save_state,tr_index;
float current_time,state_time[MAX_STATES],total_state_time[MAX_STATES];
int control[MAX_STATES];
};


 Fsa::Fsa()
{
int i;
current_state = 0; 
current_time    = 0.0;
 for (i=0;i<MAX_LINKS;i++) link_freq[i] = 0;
index = 0;
}


void Fsa::simulation_loop()
{

 int i;

for (i=0;i<num_states;i++) {
   state_freq[i] = 0;
   total_state_time[i] = 0.0;
  }

  cout << "FSA Simulator Output\n\n";
  while (index <= control_length) {
   cout << form("Time: %f, ",current_time);
   cout << form("State: %s\n",state[current_state]); 
   /* gather statistics */
   state_freq[current_state] += 1;
   current_time += state_time[current_state];
   total_state_time[current_state] += state_time[current_state];
   if(index != control_length) {
     current_time += transition[current_state][control[index]].time;
     save_state = current_state;
     current_state = transition[current_state][control[index]].state;
     tr_index = save_state*num_states+current_state;
     link_freq[tr_index] += 1;
   }
   index++;
 }/* end while */
}

void Fsa::display_status()
{
int i;
cout << "\n\nFSA Model Statistics\n\n";
  cout << "State Statistics\n";
  cout << "----------------\n";
  total = 0;
  for (i=0;i<num_states;i++)
       total += state_freq[i];
  cout << "State   " << "Name                "  << "  Freq  ";
  cout << "Freq %%   " << "  Time  " << " Time %%\n";
  for (i=0;i<num_states;i++) {
   cout << form("%-3d     ",i);
   cout << form("%-20s",state[i]);
   cout << form("%6d  ",state_freq[i]);
   cout << form("%5.1f%%   ",(float) state_freq[i] * 100.0/ (float) total);
   cout << form("%6.1f  ",total_state_time[i]);
   cout << form(" %5.1f%%\n",(float) total_state_time[i]* 100.0/ 
                              (float) current_time);
  } /* end for */

       }

void Fsa::display_link()
{
 int i;
  cout << "\n\n";
  cout << "Link Statistics\n";
  cout << "----------------\n";
  total = 0;
  for (i=0;i<MAX_LINKS;i++) total += link_freq[i];
  cout << "Link     " << "Id      ";
  cout <<"  Freq  "  << "Freq %%\n";
  for (i=0;i<MAX_LINKS;i++)
  {
  if(link_freq[i] > 0) 
	{
  	 cout << form("%-3d     ",i);
  	 row = i/num_states;
  	 col = i%num_states;
  	 cout << form("%2d -> %2d ",row,col);
  	 cout << form("%6d  ",link_freq[i]);
  	 cout << form("%5.1f%%\n",(float) link_freq[i] * 100.0/ (float) total);
  	} /* end if */
  } /* end for */
}


void Fsa::initialize()
{
  int i,j;
  char  string[15];

// read in number of states 

  cin >> num_states;

// read in the length of time for each state 
  
for (i=0;i<num_states;i++)
    cin >> state_time[i];

// read in transition array
 for (i=0;i<num_states;i++) 
	{
	    for (j=0;j<NUM_INPUTS;j++)
        	 cin >> transition[i][j].state; 
	}

// read in state descriptors
 for (i=0;i<num_states;i++) 
      cin >> state[i];
     
// read in control string length 

  cin >> control_length;

// read in control (input) string

  cin >> string;
  for (i=0;i<control_length;i++) 
 	{
          if ( int(string[i]) == 49)
		control[i]=1;
	  else
		control[i]=0;
	}

}// end init()


main()
{
  Fsa fsa;
  fsa.initialize();
  fsa.simulation_loop();
  fsa.display_status();
  fsa.display_link();
} /* end main() */







