//---------------------------------------------
//               S I M P A C K + +
//            Simulation Tool Package
//        Copyright 1992, Paul A. Fishwick
//---------------------------------------------

#include <stream.h>

// Homoclinic Orbits (Silnikov) 

class Silnikov {
 private:
   float in[4],out[4],f[4],savevar[4],delta_time;
   int count,num_equations;
 public:
   Silnikov();
   void next_state();
   void integrate();
   void print_time();
 };

Silnikov sil1;
float simtime;

main()
{
  simtime = 0.0;
  while (simtime < 250.0) {
   sil1.next_state();
   sil1.integrate(); 
   // output time,x 
   sil1.print_time();
  } // end while 
  cout<<"\n";
} // end main 

Silnikov::Silnikov()
{
  out[1] = 0.1234;
  out[2] = 0.2;
  out[3] = 0.1;
  num_equations = 3;
  delta_time = 0.05;
}

void Silnikov::next_state()
{ 
 float a=0.4,b=0.65,c=0.0,d=1.0;
 // Calculate state:
 //   x1' = x2
 //   x2' = x3
 //   x3' = -ax3 - x2 +bx1(1 - cx1 - dx1(2))

 in[1] = out[2];
 in[2] = out[3];
 in[3] = -a*out[3] - out[2] + b*out[1]*(1.0 - c*out[1] - d*out[1]*out[1]);
}
 
void Silnikov::integrate()
{
  int i;

  for (i=1;i<=num_equations;i++) {
    f[i] = delta_time*in[i];
    savevar[i] = out[i];
    out[i] += f[i]/2;
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i]/2;
  }
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i];
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) 
    out[i] = savevar[i] + (f[i] + delta_time*in[i])/6;
}

void Silnikov::print_time()
{
  cout<<out[1]<<"  "<<out[2]<<"\n";
}

