/*---------------------------------------------
                S I M P A C K++
            Simulation Tool Package
        Copyright 1992, Paul A. Fishwick
---------------------------------------------*/


#include "../../queuing/queuing.h"

#define ARRIVAL 1
#define REQUEST_SERVER 2
#define RELEASE_SERVER 3
main()
  { 
    int event,iteration;
    init_simpack(LINKED);
    Facility server(1,1);
    Token customer;
    double sample;

    customer.id = 1;
    event_list.schedule(ARRIVAL,0.0,customer);
    iteration = 0;
    while (time() < 1000.0)
      {
        event_list.next_event(event,customer); 
        iteration++;
        switch(event)
          {
	  case ARRIVAL:
              update_arrivals();
              event_list.schedule(REQUEST_SERVER,0.0,customer);
              customer.id += 1;
              event_list.schedule(ARRIVAL,2.0,customer);
              break;
          case REQUEST_SERVER:
              if (server.request(customer,0) == FREE) {
                sample = expntl(2.0);
                event_list.schedule(RELEASE_SERVER,sample,customer);  
              }
              break;
          case RELEASE_SERVER:
              server.release(customer);
              update_completions();
              break;
          }
      }
  report_stats(); 
  } /* end main() */



