/* ------------------------------------------------------------------------- */
/* alg-pcf.c  i2c-bus with the PCF 8584 				     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 19996 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char rcsid[] = "$Id: alg-pcf.c,v 1.2 1996/11/20 20:20:46 i2c Exp $";
/*
 * $Log: alg-pcf.c,v $
 * Revision 1.2  1996/11/20 20:20:46  i2c
 * major cleanups.
 *
 * Revision 1.1  1996/11/18 22:24:45  i2c
 * Initial revision
 *
 *
 */

/*****************************************************************************
 WARNING: THIS CODE DOES NOT WORK YET! 

 It compiles, but it is only a blind transcript of the Philips data sheets.
 If you are adventurous, try it out & tell me!
 *****************************************************************************/

#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/lp.h>

#include "i2c.h"
#include "i2c_priv.h"
#include "pcf8584.h"

/* ----- global defines ---------------------------------------------------- */
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/
#define DEBI(x) x	/* ioctl and its arguments 			*/
#define DEBACK(x)	/* ack failed message - may be annoying		*/


#if (PCFADAPS > 1)
/*
 *  This array contains the hw-specific functions for
 *  each port (hardware) type.
 */
struct i2c_pcf_opns *pcf_adaps[I2C_HW_ADAPS];
#endif

#if (PCFADAPS) > 1
/* --- dummy functions for empty entries ------------------------------	*/
static int __dummy_read_port(int minor,int adr)
{
	return 0;
}
static void __dummy_write_port(int minor, int adr, char data) 
{
}
static int  __dummy_init(int minor) 
{
	return -ENODEV;
}
static void __dummy_exit(int minor)
{
}

static struct i2c_bit_opns dummy_bitops={
	__dummy_read_port,
	__dummy_write_port,
	__dummy_init,
	__dummy_exit,
};
#endif


/* ----- global variables -------------------------------------------------- */
/* ----- local functions --------------------------------------------------- */

static int i2c_open(struct inode * inode, struct file * file) 
{
	return 0;
}


static void i2c_release (struct inode * inode, struct file * file) 
{
}


static int i2c_write(struct inode * inode, struct file * file,
	const char * buf, int count)
{
	unsigned int minor = MINOR(inode->i_rdev);
	const char *temp = buf;
	char status;
	int  i;
	struct i2c_data *data;

	data=(struct i2c_data *)file->private_data;
	if (!data || (data->magic!=I2C_MAGIC))
		return -EINVAL;

	while ( !( stat() & PCF_BB ) );  /* wait till bus free*/
	dta(data->address&0xfe);
	cmd(0xc5);               /* start, transmit address */
	
	i=0;
	while (1){
	  do {
	    status = stat();
	  } while ( ( status & PCF_PIN ) ); /* transmitting */
	  if (status & PCF_LRB ) /* slave acked? */
	    break;
	  if (i==count)
	    break;
	  dta(get_user(temp));
	  i++;temp++;
	}
	cmd(0xc3);
	return i;
}

static int i2c_read(struct inode * inode, struct file * file,
	char * buf, int count) 
{
	unsigned int minor = MINOR(inode->i_rdev);
	char *temp = buf, status;
	int i;
	struct i2c_data *data;

	data=(struct i2c_data *)file->private_data;
	if (!data || (data->magic!=I2C_MAGIC))
		return -EINVAL;

	while ( !( stat() & PCF_BB ) );  /* wait till bus free*/

	dta(data->address|0x01);
	cmd(0xc5);               /* start, transmit address */
        do {
	  status = stat();
        } while ( ( status & PCF_PIN ) ); /* transmitting */
	if (status & PCF_LRB ) { /* slave acked? */
	  cmd(0xc3);             /* no, didn't */
	  return -EIO;
	}
	recv();         /* discard slave address */
	i=0;
	while (1){
	  do {
	    status = stat();
	  } while ( ( status & PCF_PIN ) ); /* transmitting */
	  i++;
	  if (i == count)
	    break;
	  put_user(recv(),temp);
	  temp++;
	}
	cmd(0x40); /* neg. acknowledge on next byte */
	put_user(recv(),temp);
        temp++;
	do {
	  status = stat();
        } while ( ( status & PCF_PIN ) ); /* transmitting */
	cmd(0xc3);
	put_user(recv(),temp);
	temp++;
	return temp-buf;
}

static int i2c_ioctl(struct inode *inode, struct file *file,/********CHANGE!*/
	unsigned int cmd, unsigned long arg)
{
	unsigned int minor = MINOR(inode->i_rdev);

	return 0;
}


static int i2c_init(int minor)
{	
	int ret;
	ret = pcf_init(minor);
	if (!ret) { /*init chip*/
		cmd(0x80); /* reset chip */
		dta(0x55); /* interface address -- This will change! */

		cmd(0xa0); /* load clock  */
		dta(PCF_CLK12 | PCF_TRNS11); /* 12MHz clock, 90kHz transfer */
	
		cmd(0xc1); /* enable interface */
	}
	return ret;
}


static void i2c_exit(int minor)
{
	pcf_exit(minor);
}

                
/* -----exported file operations: -------------------------------------	*/
struct i2c_opns alg_pcf_opns = {
	i2c_read,
	i2c_write,
	i2c_ioctl,
	i2c_open,
	i2c_release,
	i2c_init,
	i2c_exit
};


/*
 *  Global init function - sets up internal data structures
 */
int alg_pcf_init (void)
{
	printk("alg_bit_init\n");
#if (PCFADAPS > 1)
	int i;
	for (i=0;i<I2C_HW_ADAPS;i++){	/* set dummy values first... */
		pcf_adaps[i]=&dummy_bitops;
	}
#ifdef PCF_LP
	pcf_adaps[IDX_B_LP]=&pcf_lp_ops;
#endif
#ifdef PCF_ISA
	pcf_adaps[IDX_B_ISA]=&pcf_isa_ops;
#endif
#else	
	/* only one adapter type defined -- nothing to do. */
#endif
	return 0;
}
