/* ------------------------------------------------------------------------- */
/* alg-illeg.c  i2c dummy stub						     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-97 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char rcsid[] = "$Id: alg-illeg.c,v 1.4 1997/05/29 17:33:56 i2c Exp $";
/*
 * $Log: alg-illeg.c,v $
 * Revision 1.4  1997/05/29 17:33:56  i2c
 * *** empty log message ***
 *
 * Revision 1.3  1996/11/16 18:48:41  i2c
 * changed debugging messages
 *
 * Revision 1.2  1996/03/28 20:34:31  i2c
 * added exit
 *
 * Revision 1.1  1996/03/28 19:37:58  root
 * Initial revision
 *
 */

#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/lp.h>

#include "i2c.h"
#include "i2c-priv.h"

/* ----- global defines ---------------------------------------------------- */
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/
#define DEBI(x) x	/* ioctl and its arguments 			*/
#define DEBACK(x)	/* ack failed message				*/

/* ----- global variables -------------------------------------------------- */

/* ----- local functions --------------------------------------------------- */

/* ----- level 2: communication with the kernel  ----- */

static int alg_illeg_open(struct inode * inode, struct file * file) 
{
	unsigned int minor = MINOR(inode->i_rdev);
	printk("i2c: invalid device called (illeg) - minor %d !\n",minor);
	return -EINVAL;
}


static void alg_illeg_release (struct inode * inode, struct file * file) 
{
	printk("i2c: invalid device called (illeg)!\n");
}


static int alg_illeg_write(struct inode * inode, struct file * file,
	const char * buf, int count)
{
	unsigned int minor = MINOR(inode->i_rdev);
	printk("i2c: invalid device called (illeg) - write minor %d !\n",minor);
	return -EINVAL;
}

static int alg_illeg_read(struct inode * inode, struct file * file,
	char * buf, int count) 
{
	unsigned int minor = MINOR(inode->i_rdev);
	printk("i2c: invalid device called (illeg) - read minor %d !\n",minor);
	return -EINVAL;
}

static int alg_illeg_ioctl(struct inode *inode, struct file *file,
	unsigned int cmd, unsigned long arg)
{
	unsigned int minor = MINOR(inode->i_rdev);
	printk("i2c: invalid device called (illeg) ioctl - minor %d !\n",minor);
	return -EINVAL;
}

static int alg_illeg_init(int minor)
{	
	printk("i2c: invalid device called (illeg) init - minor %d !\n",minor);
	return -EINVAL;
}

static void alg_illeg_exit(int minor)
{	
}
                
/* -----exported file operations: -------------------------------------	*/
struct i2c_opns illegops = {
	alg_illeg_read,
	alg_illeg_write,
	alg_illeg_ioctl,
	alg_illeg_open,
	alg_illeg_release,
	alg_illeg_init,
	alg_illeg_exit
};
