/* ------------------------------------------------------------------------- */
/* bit-lp.c i2c-hw access for philips style parallel port adapters	     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-97 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char rcsid[] = "$Id: bit-lp.c,v 1.2 1997/05/29 17:33:56 i2c Exp $";
/*
 * $Log: bit-lp.c,v $
 * Revision 1.2  1997/05/29 17:33:56  i2c
 * *** empty log message ***
 *
 * Revision 1.1  1996/11/17 11:00:03  i2c
 * Initial revision
 *
 *
 */

#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/errno.h>
#include "i2c.h"
#include "i2c-priv.h"


/* ----- global defines -----------------------------------------------	*/
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/

					/* Pin Port  Inverted	name	*/
#define I2C_ON		0x20		/* 12 status N	paper		*/
					/* ... only for phil. not used  */
#define I2C_SDA		0x80		/*  9 data   N	data7		*/
#define I2C_SCL		0x08		/* 17 ctrl   N	dsel		*/

#define I2C_SDAIN	0x80		/* 11 stat   Y	busy		*/
#define I2C_SCLIN	0x08		/* 15 stat   Y	enable		*/

#define I2C_DMASK	0x7f
#define I2C_CMASK	0xf7

/* ----- local functions ----------------------------------------------	*/
#if (BITADAPS) == 1
#define Local inline
#define bit_lp_getscl getscl
#define bit_lp_setscl setscl
#define bit_lp_getsda getsda
#define bit_lp_setsda setsda
#define bit_lp_bit_init bit_init
#define bit_lp_bit_exit bit_exit 
#else
#define Local static
#endif


Local void bit_lp_setscl(int minor, int state)
{
	if (state) {
		outb(I2C_SCL,   CTRL);
	} else {
		outb(I2C_CMASK, CTRL);
	}
	
}

Local void bit_lp_setsda(int minor, int state)
{
	if (state) {
		outb(I2C_DMASK , DATA);
	} else {
		outb(I2C_SDA , DATA);
	}
	
} 

Local int bit_lp_getscl(int minor)
{
	return ( 0 != ( (inb_p(STAT)) & I2C_SCLIN ) );
}

Local int bit_lp_getsda(int minor)
{
	return ( 0 != ( (inb_p(STAT)) & I2C_SDAIN ) );
}

Local int bit_lp_bit_init(int minor)
{
	char ctrl,ecr,cfgA,cfgB; /* parallel port registers for detection	*/
	if (check_region(i2c_table[minor].base, 
		(i2c_table[minor].base == 0x3bc)? 3 : 8) < 0 ) {
		return -ENODEV;	
	} else {
		request_region(i2c_table[minor].base, 
			(i2c_table[minor].base == 0x3bc)? 3 : 8, 
			"i2c (parallel port adapter)");
		bit_lp_setsda(minor,1);
		bit_lp_setscl(minor,1);
	}
	printk("i2c%d: scl: %d     sda %d \n",minor,bit_lp_getscl(minor),bit_lp_getsda(minor));
//	return 0;
	/* now detect, what kind of parallel port we have: */
	/* ... actually, this is not needed here. It is just for debugging
	 * & testing reasons in this file, and may be moved to pcf-lp.c or
	 * something later...
	 */
	ecr = inb(i2c_table[minor].base+0x402);
	ctrl= inb(i2c_table[minor].base+0x002);
	if (ecr!=ctrl) {		/* Okay, we seem to have an extended port :)	*/
		if (check_region(i2c_table[minor].base + 0x400, 8) < 0 ) {
			DEBE(printk(	"i2c_init, port %#x: ext. ports already in use "
				   	"using only standard driver.\n",
				i2c_table[minor].base));
			return 0;
		} else {
			printk("i2c%d: scl: %d     sda %d \n",minor,bit_lp_getscl(minor),bit_lp_getsda(minor));
			printk("i2c%d:      ports: %2x  %2x  %2x  %2x    %2x  %2x  %2x  %2x\n", minor,
				inb(i2c_table[minor].base+0x00), inb(i2c_table[minor].base+0x01),
				inb(i2c_table[minor].base+0x02), inb(i2c_table[minor].base+0x03),
				inb(i2c_table[minor].base+0x04), inb(i2c_table[minor].base+0x05),
				inb(i2c_table[minor].base+0x06), inb(i2c_table[minor].base+0x07)
				);
			printk("i2c%d: ext. ports: %2x  %2x  %2x  %2x    %2x  %2x  %2x  %2x\n", minor,
				inb(i2c_table[minor].base+0x0400), inb(i2c_table[minor].base+0x0401),
				inb(i2c_table[minor].base+0x0402), inb(i2c_table[minor].base+0x0403),
				inb(i2c_table[minor].base+0x0404), inb(i2c_table[minor].base+0x0405),
				inb(i2c_table[minor].base+0x0406), inb(i2c_table[minor].base+0x0407)
				);
			if ( (ecr & 0x03) != 0x01 ) {		/* FIFO empty? 		*/
				printk("FIFO not empty\n");
				return 0;	
			}
			outb(0x34,i2c_table[minor].base+0x402);
			/*... this doesn't seem to be right....*/
			if (inb(i2c_table[minor].base+0x402) != 0x35 ){	/* bits 0,1 readonly	*/
				printk("bits 0,1 not rd/only");
				return 0;
			}
			/* Okay, now we should have an ECP-capable printer port	*/
			printk("i2c%d: ECP parallel port.\n",minor);
			request_region(i2c_table[minor].base+0x0400, 8 , 
				"i2c (Extended Parallel port adapter)");
			outb(0xf4,i2c_table[minor].base+0x402);	/* Config. mode		*/
			cfgA = inb(i2c_table[minor].base+0x400);
			cfgB = inb(i2c_table[minor].base+0x401);
			printk("i2c%d: Configuration A: %2x    B: %2x\n",minor,cfgA,cfgB);
			outb(0x34,i2c_table[minor].base+0x402);	/* bidir. lp mode */
			
			/* now we set the correct line states 		*/
			
		}
	} else {
		printk("i2c%d: standard parallel port found.\n",minor);
	}
	return 0;
}

Local void bit_lp_bit_exit(int minor)
{	
	release_region( i2c_table[minor].base , 
		(i2c_table[minor].base == 0x3bc)? 3 : 8 );
	release_region( i2c_table[minor].base + 0x0400, 8 );
}


/* ------------------------------------------------------------------------
 * Encapsulate the above functions in the correct operations structure.
 * This is only done when more than one hardware adapter is supported.
 */
#if (BITADAPS) > 1
struct i2c_bit_opns bit_lp_ops = {
	bit_lp_setscl,
	bit_lp_setsda,
	bit_lp_getscl,
	bit_lp_getsda,
	bit_lp_bit_init,
	bit_lp_bit_exit
};
#endif
