/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.1						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/*								*/
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/TextSrc.h>
#include <X11/Xaw/Dialog.h>

#include <ctype.h>
#include <stdio.h>

#include <msql.h>
#include "xwidgets.h"
#include "common.h"
#include "flist.h"

#define BUFSIZE 1024

typedef struct _XawListReturnStruct {
  String string;
  int list_index;
} XawListReturnStruct;  


/* Widgets (global) */
extern Widget appShell;
extern CWidgets cWidgets;
/* Database engine info (global) */
extern CMsql cMsql;

extern char *formattedOutput(m_result*, int);
  
/*-------------------------------------------------------------------*/
/* convenience functions 					     */
/* ------------------------------------------------------------------*/

void setStatusLine(String msg)
{
  Arg wargs[1];
  
  XtSetArg(wargs[0], XtNstring, msg);
  XtSetValues(cWidgets.status, wargs, 1); 
}

void popupPosition(Widget widget, int *root_x, int *root_y)
{
  Window dummyWindow;
  int dummyInt;
  unsigned int dummyUInt;

  XQueryPointer(XtDisplay(widget), XtWindow(widget),
        	&dummyWindow, &dummyWindow,
                root_x, root_y,
                &dummyInt, &dummyInt, &dummyUInt);
  *root_x = (*root_x >= 50 ? *root_x-50 : *root_x);
  *root_y = (*root_y >= 50 ? *root_y-50 : *root_y);
}    

/* ----------------------------------------------------------------- */
/* misc functions						     */
/* ------------------------------------------------------------------*/

void doOnSelect(char *filename, char doWhat)
{
  char buf[BUFSIZE];
  FILE *input, *output;
  unsigned int nread, nwrite;
  Arg wargs[5];
  int n, len;
  Widget textSrc, prompter;
  char *str, *strptr;
  XawTextBlock textBlock;
  int exists = 0;
  static int promptAnswer;
  
  if (!filename) {
    setStatusLine("File dialog canceled.");
    return;
  }
    
  /* get TextSrc-widget */
  n = 0;
  XtSetArg(wargs[n], XtNtextSource, &textSrc); n++;
  XtGetValues(cWidgets.stext, wargs, n);
  if (!textSrc) {
    setStatusLine("Internal error.");
    return;
  }
  n = 0;
  XtSetArg(wargs[n], XtNstring, &str); n++;
  XtGetValues(cWidgets.stext, wargs, n);
  len = strlen(str);
  
  if (LOAD == doWhat) {
    input = fopen(filename,"r");               
     if (!(input)) {
       XBell(XtDisplay(appShell), 0);                           
       puts("Failed to open source file!");
       return;
     }
    nread = fread(buf,1,BUFSIZE,input);
    textBlock.firstPos = 0;
    textBlock.length = nread;
    textBlock.ptr = buf;
    /* replace whole text with first block read from file */ 
    XawTextSourceReplace(textSrc, 0, len, &textBlock); 
    /* append next blocks read from file */
    len = nread;
    while (nread = fread(buf,1,BUFSIZE,input)) {
      textBlock.length = nread;
      textBlock.ptr = buf;
      XawTextSourceReplace(textSrc, len, len, &textBlock);
      len += nread;
    }
    fclose(input);
    n = 0;
    XtSetArg(wargs[n], XtNstring, &str); n++;
    XtGetValues(cWidgets.stext, wargs, n);
    len = strlen(str);
    /* redisplay text */
    XawTextInvalidate(cWidgets.stext, 0, len);
    XawTextDisplay(cWidgets.stext); 
  }
  /* end LOAD */
  else if (doWhat = SAVE) {             
    output = fopen(filename,"w");
    if (!output) {
      setStatusLine("Failed to open file.");
      return;
    }
    strptr = str;
    while (len > 0) {
      strncpy(buf, strptr, BUFSIZE);
      nwrite = fwrite(buf, 1, (len <= BUFSIZE ? len : BUFSIZE), output); 
      len -= nwrite; 
    }
    fclose(output);  
  } /* end SAVE */
}


/* ------------------------------------------------------------------ */

void connectDBServer(String hostname)
{
  int sock, dbCount, i;
  m_result *dbs;
  m_row row;

  sock = msqlConnect(hostname); /* make connection to DB server */
  if (sock == -1) {
    setStatusLine((String)msqlErrMsg);
    return;
  }  
  dbs = msqlListDBs(sock);
  if (!dbs) {
    setStatusLine(msqlErrMsg);
    cMsql.connection = -1;
    return;
  }
  /* set global data */
  cMsql.connection = sock;
  dbCount = msqlNumRows(dbs);
  cMsql.dbs = (char **)XtMalloc((dbCount+1) * sizeof(char *));
  for (i = 0; i < dbCount; i++) {
    row = msqlFetchRow(dbs);
    cMsql.dbs[i] = (char *)XtCalloc((strlen(row[0])+1), sizeof(char));
    strcpy(cMsql.dbs[i], row[0]);
  }
  cMsql.dbs[i] = NULL; /* end list with  NULL  */
  cMsql.count = dbCount;  /* number of DBs */
  
  /* pass created structure to list-widget */
  XawListChange(cWidgets.list, cMsql.dbs, 0, 0, False); 
  /* free m_result-structur */
  msqlFreeResult(dbs);
    
  setStatusLine("Successfully connected to msql-Server.");     
}  

/* --------------------------------------------------------------------- */

void doQuery(char *text)
{
  m_result *qresult;  
  m_row row;
  Arg wargs[5];
  int n, rowCount;
  char *output, buffer[50];
  
  if ((cMsql.connection == -1) || (cMsql.currentDB == -1)) {
    setStatusLine("Not connected or no DB selected.");
    return;
  }
                  
  /* selektierter Text als Query */
  if (-1 == msqlQuery(cMsql.connection, text)) {
    setStatusLine(msqlErrMsg);
    return;
  }
  setStatusLine("Query executed.");
  
  /* Ergebnis holen und anzeigen */
  qresult = msqlStoreResult();
  if (!qresult) /* nothing more to be done */
    return;  
  rowCount = msqlNumRows(qresult);   
  output = formattedOutput(qresult, rowCount);
  if (!output)
    return;
  n = 0;
  XtSetArg(wargs[n], XtNstring, output); n++;
  XtSetValues(cWidgets.dtext, wargs, n);
  sprintf(buffer, "%d Row(s) fetched.", rowCount);
  setStatusLine(buffer);
  XtFree(output);
  msqlFreeResult(qresult);
}

/* ---------------------- */
/* Callbacks and Actions  */
/* -----------------------*/

void quit(Widget widget, XtPointer clientData, XtPointer callData)
{ 
  if (cMsql.connection != -1)
    msqlClose(cMsql.connection);
  exit(0);
}

/* ------------------------------------------------------------------ */

void load(Widget widget, XtPointer clientData, XtPointer callData)
{
  Widget fileList;
  
  fileList = FileDialog(appShell, doOnSelect, LOAD, NULL);
}

/* ------------------------------------------------------------------ */

void save(Widget widget, XtPointer clientData, XtPointer callData)
{
  Widget fileList;
  
  fileList = FileDialog(appShell, doOnSelect, SAVE, NULL);
}

/* ------------------------------------------------------------------ */

void openPopup(widget, clientData, callData)
  Widget widget;
  XtPointer clientData, callData;
{
  Widget popupShell;

   if (clientData == NULL)
     return;
   popupShell = MakePopup((Widget)clientData, "Popup", NULL);  
   if (popupShell != NULL) {
     XtRealizeWidget(popupShell);
     XtPopup(popupShell, XtGrabExclusive);
   }       
}

/* ------------------------------------------------------------------ */

void openNotify(Widget widget, XtPointer clientData, XtPointer callData)
{
  Widget popupShell, parent;
  notifyInfo *ni;
  String notifyString;

   if (clientData == NULL)
     return;
   ni = (notifyInfo *)clientData;  
   parent = ni->w;
   notifyString = ni->s;  
   popupShell = MakeNotify(parent, notifyString);  
   if (popupShell != NULL) {
     XtRealizeWidget(popupShell);
     XtPopup(popupShell, XtGrabExclusive);
   }       
}

/* ------------------------------------------------------------------ */

void listTables(Widget widget, XtPointer clientData, XtPointer callData)
{  
  m_result *result;
  m_row row;
  int i;
   
  if (-1 == cMsql.connection) {
    setStatusLine("Not connected.");
    return;
  }   
  result = msqlListTables(cMsql.connection);
  if (result) {
    if (cMsql.tbls) {
      setStatusLine("Info already open.");
      return;
    }          
    cMsql.tblsCount = msqlNumRows(result);
    cMsql.tbls = (char **)XtMalloc((cMsql.tblsCount+1) * sizeof(char *));
    for (i = 0; i < cMsql.tblsCount; i++) {
      row = msqlFetchRow(result);
      cMsql.tbls[i] = (char *)XtCalloc((strlen(row[0])+1), sizeof(char));
      strcpy(cMsql.tbls[i], row[0]);
    }
    cMsql.tbls[i] = NULL; /* Liste mit NULL abschlieen */
    /* m_result Struktur freigeben */
    msqlFreeResult(result);
    MakeLookup(appShell, cMsql.tbls, cMsql.tblsCount);  
  }
  else
    setStatusLine("No info available.");  
}

/* ------------------------------------------------------------------ */

void listFields(Widget widget, XtPointer clientData, XtPointer callData)
{
  int i;
  m_result *result;
  m_field *field;
  XawListReturnStruct *li;
 
  if (!clientData)
    return;
  if (-1 == cMsql.connection) {
     setStatusLine("Not tableSelected.");
     return;
  }   
  li = (XawListReturnStruct *)callData;
  result = msqlListFields(cMsql.connection, li->string);
  if (!result)
    return;
  /* alte Feldlidste freigeben */
  if (cMsql.flds) {
    for (i = 0; i < cMsql.fldsCount; i++)
      XtFree(cMsql.flds[i]);
    XtFree((char *)cMsql.flds);
  }
  /* neue Feldliste anlegen */
  cMsql.fldsCount = msqlNumFields(result);
  cMsql.flds = (char **)XtMalloc((cMsql.fldsCount+1) * sizeof(char *));
  for (i = 0; i < cMsql.fldsCount; i++) {
    field = msqlFetchField(result);
    cMsql.flds[i] = (char *)XtCalloc((strlen(field->name)+1), sizeof(char));
    strcpy(cMsql.flds[i], field->name);
  }
  cMsql.flds[i] = NULL; /* Liste mit NULL abschlieen */
  /* m_result Struktur freigeben */
  msqlFreeResult(result);
  XawListChange((Widget)clientData, cMsql.flds, 0, 0, False);
}    

/* ------------------------------------------------------------------ */

void closeLookup(Widget widget, XtPointer clientData, XtPointer callData)
{
  int i;
  
  if (!clientData)
    return;
  XtDestroyWidget((Widget)clientData);    
  /* alte Tabellenstrultur freigeben */
  if (cMsql.tbls) {
    for (i = 0; i < cMsql.tblsCount; i++)
      XtFree(cMsql.tbls[i]);
  XtFree((char *)cMsql.tbls);
  cMsql.tbls = NULL;
  }
  /* alte Feldlidste freigeben */
  if (cMsql.flds) {
    for (i = 0; i < cMsql.fldsCount; i++)
      XtFree(cMsql.flds[i]);
    XtFree((char *)cMsql.flds);
    cMsql.flds = NULL;
  }    
}

/* ------------------------------------------------------------------ */

void connectLocalServer(Widget widget, XtPointer clientData, XtPointer callData)
{
  connectDBServer(NULL);
}  

/* ------------------------------------------------------------------ */

void connectServerNamed(Widget widget, XtPointer clientData, XtPointer callData)
{
  Widget dlg;
  String hostname;
  
  if (!clientData)
    return;
  dlg = (Widget)clientData;
  hostname = XawDialogGetValueString(dlg);
    
  connectDBServer(hostname);
  
  XtDestroyWidget(XtParent(dlg));
} 

/* ------------------------------------------------------------------ */


void connectRemoteServer(Widget widget, XtPointer clientData, XtPointer callData)
{
  Widget pShell;
  
  pShell = MakePopup(XtParent(widget), "Query Host", 
                	connectServerNamed);
  XtPopup(pShell, XtGrabExclusive);              
} 

/* ------------------------------------------------------------------ */


void selectDB(Widget widget, XtPointer clientData, XtPointer callData)
{
  XawListReturnStruct *listInfo;
 
  if (cMsql.connection != -1) {
    listInfo = (XawListReturnStruct *)callData;
    if (-1 == msqlSelectDB(cMsql.connection, listInfo->string)) {
      cMsql.currentDB = -1;
      setStatusLine(msqlErrMsg);
      return;
    }
    cMsql.currentDB = listInfo->list_index;
    setStatusLine("Database selected."); 
  }
}  

/* ------------------------------------------------------------------ */     


void executeSql(Widget widget, XtPointer clientData, XtPointer callData)
{
  XawTextPosition beginSelection, endSelection;
  String str;
  char *p1, *p2;
  int i, n, rowCount, fieldsCount;
  Arg wargs[5];
  
  XawTextGetSelectionPos(cWidgets.stext, &beginSelection, &endSelection);
  if (beginSelection == endSelection) {
    setStatusLine("No code selected in SQL-Window.");
    return;
  } 
  n = 0;
  XtSetArg(wargs[n], XtNstring, &str); n++;
  XtGetValues(cWidgets.stext, wargs, n);
  *(str + endSelection) = '\0';
  p1 = p2 = str + beginSelection;
  while (*p2)
    if (*p2 == ';') {
      *p2 = '\0';
      doQuery(p1);
      p1 = ++p2;  
    }
    else
      p2++;
  if (p1 != p2)
    doQuery(p1);      
}  

/* ------------------------------------------------------------------ */     


void showAbout(Widget widget, XtPointer clientData, XtPointer callData)
{
  static char about[] = "xmsql version 0.1\n\
Copyright (C) 1995 Stefan Dupont-Christ\n\
xmsql comes with ABSOLUTELY NO WARRENTY";
                         
  MakeNotify(appShell, about);
}                            

/* ------------------------------------------------------------- */

void closeWidget(Widget widget, XtPointer clientData, XtPointer callData)
{
   if (clientData == NULL)
     return;
   XtDestroyWidget((Widget)clientData);  
}

/* ------------------------------------------------------------- */
/* eigene Aktionen, die in Translations verwendet werden knnen. */ 
/* --------------------------------------------------------------*/

void closeWin(Widget widget, XEvent *eventAdr, 
	      String *params, Cardinal *paramsAnzAdr)
{
  exit(0);
}

/* ------------------------------------------------------------- */

void evaluate(Widget widget, XEvent *eventAdr, 
	      String *params, Cardinal *paramsAnzAdr)
{
  int n, pos, end, begin, len;
  Widget textSrc; 
  Arg wargs[5];
  String src;
  XawTextPosition ins;
  
  ins = XawTextGetInsertionPoint(cWidgets.stext);
  n = 0;
  XtSetArg(wargs[n], XtNstring, &src); n++;
  XtGetValues(cWidgets.stext, wargs, n);
  len = strlen(src);
  
  begin = 0; end = len; pos = ins;
  while (src[pos] && (src[pos++] != '\n'))  /* search forward for delimiter ';' */
    if (src[pos] == ';') {  /* end-delimiter found */
      end = pos - 1;
      break;
    }  
  for (pos = ins; pos > 0; pos--) /* search backward for delimiter ';' */
    if (src[pos] == ';')  /* delimiter found */
      if (end == len)      /* end-delimiter already found ? */
        end = pos - 1;
      else {
        begin = pos + 1;  /* otherwise begin-delimiter found */
        break;
      }     
            
  src[end+1] = '\0';   
  
  doQuery(src+begin);
}           

/* -------------------------------------------------------------------- */

void dropLine(Widget widget, XEvent *eventAdr, 
	      String *params, Cardinal *paramsAnzAdr)
{
  setStatusLine("Enter a SQL statements, separate with \";\", hit <Ctrl>Return to execute");
}

/* -------------------------------------------------------------------- */

void clearStatus(Widget widget, XEvent *eventAdr, 
	      String *params, Cardinal *paramsAnzAdr)
{
  setStatusLine("");
}                 
