/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.1						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/*								*/
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/AsciiText.h>
#include <sys/param.h>

#ifdef NO_XAW
#define XawRubber XtRubber
#define XawChainTop XtChainTop
#define XawChainBottom XtChainBottom
#define XawChainLeft XtChainLeft
#define XawChainRight XtChainRight
#endif

#define arrow_width 10
#define arrow_height 10
static char arrow_bits[] = {
   0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
   0xfe, 0x00, 0x7c, 0x00, 0x38, 0x00, 0x10, 0x00};

/* Typen */

typedef struct tagNotify {
  Widget widget;
  char *notifyString;
} Notify; 

typedef struct tagCWidgets {
  Widget list;
  Widget stext;
  Widget dtext;
  Widget status;
} CWidgets; 

typedef void (*ListCB)(Widget, XtPointer, XtPointer);
 
/* globaler Widget-Container */
extern CWidgets cWidgets;

/* extern functions */
extern void popupParent(Widget, int*, int*);

/* misc functions */

Widget GrabUntilButtonDown(Widget widget)
{
  XtAppContext appContext;
  XEvent event;
  

  XGrabPointer(XtDisplay(widget), XtWindow(widget), True, ButtonPressMask,
	       GrabModeAsync, GrabModeAsync, None, None, CurrentTime); 
  appContext = XtWidgetToApplicationContext(widget);
  for (;;) {
    XtAppNextEvent(appContext, &event);
    switch (event.type) {
    case ButtonPress:        
       break;
    default:
      XtDispatchEvent(&event);
      continue;
    }
    break;
  }
  XUngrabPointer(XtDisplay(widget),CurrentTime);
  XtDispatchEvent(&event);
  XtPopdown(widget);
  return XtWindowToWidget(XtDisplay(widget),event.xbutton.window);
}

/* Funktionen fr Translations (Aktionen) */

void listPopup(Widget, XEvent *, String *, Cardinal *);
     	   
/* Callbacks */

void closeWidget(Widget, XtPointer, XtPointer);
void popList(Widget, XtPointer, XtPointer); 
void listCB(Widget, XtPointer, XtPointer);
void closeLookup(Widget, XtPointer, XtPointer);
void listFields(Widget, XtPointer, XtPointer);

/* spezielle Callbacks */

void sendSelection(Widget, String);

/* Dialoge und Widgets */

Widget MakeScrollList(Widget listParent, char *name,
                      char **item_list, int width, int height,
		      ListCB func, void *data)
{
  int    n = 0;
  Arg    wargs[10];		/* Used to set widget resources */
  Widget list, vport;
  static char *emptyList[] = { NULL }; 

  if (listParent == NULL)
    return NULL;

  n = 0;
  XtSetArg(wargs[n], XtNwidth,  width);             n++;
  XtSetArg(wargs[n], XtNheight, height);            n++;
  XtSetArg(wargs[n], XtNallowVert, True);           n++;
  XtSetArg(wargs[n], XtNallowHoriz, False);         n++;
  XtSetArg(wargs[n], XtNuseBottom, True);           n++;

  vport = XtCreateManagedWidget("vport", viewportWidgetClass,listParent,wargs,n);
  if (vport == NULL)
    return NULL;

  n = 0;
  if (item_list) {
    XtSetArg(wargs[n], XtNlist,   item_list);         n++; }
  else {
    XtSetArg(wargs[n], XtNlist,   emptyList);         n++; }
  XtSetArg(wargs[n], XtNverticalList, True);        n++;
  XtSetArg(wargs[n], XtNforceColumns, True);        n++;
  XtSetArg(wargs[n], XtNdefaultColumns, 1);         n++;
  XtSetArg(wargs[n], XtNborderWidth, 1);            n++;
  
  /*
   * Here we create the list widget and make it the child of the
   * viewport widget so that the viewport will properly handle scrolling
   * it and all that jazz.
   */
  if (!name) 
    name = "list"; 
  list = XtCreateManagedWidget(name, listWidgetClass,vport,wargs,n);
  if (list == NULL) {
     XtDestroyWidget(vport);
     return NULL;
   }

  if (func)
    XtAddCallback(list, XtNcallback, func, (XtPointer)data);

  return list;
}    /* end of MakeScrollList() */

Widget MakeCombo(Widget comboParent)
{
  Widget comboLabel, comboButton, comboList, list, form;
  Arg wargs[10];
  int n = 0;
  Pixmap arrowPixmap;
 
  if (comboParent == NULL)
    return NULL;
    
  n=0;
  XtSetArg(wargs[n], XtNvertDistance, 0);     	n++;
  XtSetArg(wargs[n], XtNhorizDistance, 0);     	n++;
  XtSetArg(wargs[n], XtNborderWidth, 0);      	n++;   
  form = XtCreateManagedWidget("aForm", formWidgetClass, comboParent, wargs, n);
  
  n=0;
  XtSetArg(wargs[n], XtNwidth, 60);      	n++;
  XtSetArg(wargs[n], XtNheight, 18);      	n++;  
  XtSetArg(wargs[n], XtNlabel, "<no selection>");      	n++;
  XtSetArg(wargs[n], XtNwrap, XawtextWrapNever);      	n++; 
  XtSetArg(wargs[n], XtNdisplayCaret, False);      	n++;  
  comboLabel = XtCreateManagedWidget("comboLabel", asciiTextWidgetClass, form, wargs, n);              
  arrowPixmap = XCreateBitmapFromData(XtDisplay(comboParent), 
				RootWindowOfScreen(XtScreen(comboParent)),
				arrow_bits, arrow_width, arrow_height);
  n=0;
  XtSetArg(wargs[n], XtNwidth, 15);      	n++;
  XtSetArg(wargs[n], XtNheight, 18);      	n++;  
  XtSetArg(wargs[n], XtNbitmap, arrowPixmap);      	n++;                  
  comboButton = XtCreateManagedWidget("comboButton", commandWidgetClass, form, wargs, n);  
  
  comboList = XtCreatePopupShell("comboList", overrideShellWidgetClass, form, (Arg *)NULL, 0);

  list = MakeScrollList(comboList, NULL, NULL, 70, 100,
                	listCB, /* List Callback Funktion */
                        (XtPointer)comboLabel); /* Client Data (Empfnger der Auswahl) */
  /* list wird noch gebraucht */
  cWidgets.list = list; 
 
  n = 0; 
  XtSetArg(wargs[n], XtNtop, XawChainTop);      n++;
  XtSetArg(wargs[n], XtNbottom, XawChainTop);      n++;
  XtSetArg(wargs[n], XtNright, XawChainLeft);      n++;
  XtSetArg(wargs[n], XtNleft, XawChainLeft);      n++;
  XtSetValues(comboLabel, wargs, n);
  XtSetValues(comboButton, wargs, n);
  n = 0;
  XtSetArg(wargs[n], XtNfromHoriz, comboLabel);      n++;
  XtSetValues(comboButton, wargs, n);                

  XtAddCallback(comboButton, XtNcallback, popList, (XtPointer)comboList);
  return form;                    
}

/* Popup Dialog */

Widget MakePopup(Widget popupParent, char *window_name,
        	 void (*ok_callback)())
{
  Display *d=NULL;
  Arg wargs[20];
  int n=0;
  int root_x, root_y;
  char *wName;
  char default_name[] = "Noname"; 
  Widget popupShell, popup, pform, pbutton;

  if (popupParent == NULL)
    return NULL;

  if (window_name == NULL)
    wName = default_name;
  else 
    wName = window_name;   

  popupPosition(popupParent, &root_x, &root_y);

  n=0;
  XtSetArg(wargs[n], XtNtitle,    wName);      	n++;
  XtSetArg(wargs[n], XtNiconName, wName);     	n++;
  XtSetArg(wargs[n], XtNx, root_x);      	n++;
  XtSetArg(wargs[n], XtNy, root_y);     	n++;
  
  popupShell = XtCreatePopupShell("popupShell", transientShellWidgetClass,
        	popupParent, wargs, n);
  if (popupShell == NULL)
    return NULL;  
  
  n = 0;  
  XtSetArg(wargs[n], XtNlabel, "Enter name of remote host"); 	n++;
  XtSetArg(wargs[n], XtNvalue, ""); 	n++; 
    
  popup = XtCreateManagedWidget("dialog", dialogWidgetClass,
          popupShell, wargs, n);              

  if (ok_callback)
    XawDialogAddButton(popup, "Connect", ok_callback, (XtPointer)popup); 
  else
    XawDialogAddButton(popup, "Connect", closeWidget, (XtPointer)popup);
  XawDialogAddButton(popup, "Cancel", closeWidget, (XtPointer)popupShell);   
  
  return popupShell;
}

/* Notify-Window */

Widget MakeNotify(Widget popupParent, char *notifyString)
{
  Widget popupShell, popup, form;
  Arg wargs[20];
  int n, root_x, root_y, dummyInt;
  
  if (popupParent == NULL)
    return NULL;
  
  popupPosition(popupParent, &root_x, &root_y);
  
  n = 0;  
  XtSetArg(wargs[n], XtNx, root_x); 	n++;
  XtSetArg(wargs[n], XtNy, root_y); 	n++;
  popupShell = XtCreatePopupShell("Notify Window", transientShellWidgetClass,
        	popupParent, wargs, n);
  if (popupShell == NULL)
    return NULL;  
  n = 0;  
  XtSetArg(wargs[n], XtNlabel, notifyString); 	n++;
  popup = XtCreateManagedWidget("Notify", dialogWidgetClass,
          popupShell, wargs, n);                      
  XawDialogAddButton(popup, "Dismiss", closeWidget, (XtPointer)popupShell); 
  XtRealizeWidget(popupShell);
  XtPopup(popupShell, XtGrabExclusive);
  return popupShell;
}

Widget MakeLookup(Widget parent, char **tbls, int tblsCount)
{ 
  int n, parentx, parenty;
  Arg wargs[20];
  Widget lookupShell, form, tlist, flist, button;

  /* Popup position */
  n = 0;
  XtSetArg(wargs[n], XtNx, &parentx);      n++;
  XtSetArg(wargs[n], XtNy, &parenty);      n++;
  XtGetValues(parent, wargs, n);
  n = 0;
  n = 0;
  XtSetArg(wargs[n], XtNx, parentx + 20);      n++;
  XtSetArg(wargs[n], XtNy, parenty + 20);      n++;
  
  lookupShell = XtCreatePopupShell("DB Lookup", transientShellWidgetClass,
                	parent, wargs, n);
  if (lookupShell == NULL)
    return NULL;  
  
  n=0;
  XtSetArg(wargs[n], XtNvertDistance, 2);     	n++;
  XtSetArg(wargs[n], XtNhorizDistance, 0);     	n++;
  XtSetArg(wargs[n], XtNborderWidth, 0);      	n++;   
  form = XtCreateManagedWidget("lookupForm", formWidgetClass, 
        	lookupShell, wargs, n);
  
  tlist = MakeScrollList(form, "<tables>", NULL, 70, 150,
                	NULL, /* List Callback Funktion */
                        (XtPointer)NULL);
  n=0;
  XtSetArg(wargs[n], XtNlist, tbls);     	n++;
  XtSetArg(wargs[n], XtNnumberStrings, tblsCount);     	n++;
  XtSetValues(tlist, wargs, n);
                        
  flist = MakeScrollList(form, "<fields>", NULL, 70, 150,
                	NULL, /* List Callback Funktion */
                        (XtPointer)NULL); 
                        
  XtAddCallback(tlist, XtNcallback, listFields, (XtPointer)flist); 
                        
  n=0;
  XtSetArg(wargs[n], XtNwidth, 142);     	n++;
  XtSetArg(wargs[n], XtNlabel, "Dismiss");     	n++;                                               
  button = XtCreateManagedWidget("lookupButton", commandWidgetClass, 
                	form, wargs, n);
  XtAddCallback(button, XtNcallback, closeLookup, (XtPointer)lookupShell); 
  
  n = 0; 
  XtSetArg(wargs[n], XtNtop, XawChainTop);      n++;
  XtSetArg(wargs[n], XtNbottom, XawChainBottom); n++;
  XtSetValues(XtParent(tlist), wargs, n);
  XtSetValues(XtParent(flist), wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XtNleft, XawChainLeft);      n++;
  XtSetArg(wargs[n], XtNright, XawRubber);      n++;
  XtSetValues(XtParent(tlist), wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XtNright, XawChainRight);      n++;
  XtSetArg(wargs[n], XtNleft, XawRubber);      n++;
  XtSetValues(XtParent(flist), wargs, n);
  
  n = 0; 
  XtSetArg(wargs[n], XtNtop, XawChainBottom);      n++;
  XtSetArg(wargs[n], XtNbottom, XawChainBottom); n++;
  XtSetArg(wargs[n], XtNright, XawRubber);      n++;
  XtSetArg(wargs[n], XtNbottom, XawRubber); n++;
  XtSetValues(button, wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XtNfromHoriz, XtParent(tlist));      n++;
  XtSetValues(XtParent(flist), wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XtNfromVert, XtParent(flist));      n++;
  XtSetValues(button, wargs, n);
  
  XtRealizeWidget(lookupShell);
  XtPopup(lookupShell, XtGrabNone);
  
  return lookupShell;
}

/* -------------------------------------------------------------------- */
/* Implementationen der Callbacks					*/
/* -------------------------------------------------------------------- */

void popList(Widget widget, XtPointer clientData, XtPointer callData)
{
  Widget comboList;
  XWindowAttributes winAttr;
  int x, y, width, height, d_x, d_y, n;
  Arg wargs[10];
  Window winDummy;

  if (clientData == NULL)
     return;
  comboList = (Widget)clientData;
  n = 0;
  XtSetArg(wargs[n], XtNx, &x);      n++; 
  XtSetArg(wargs[n], XtNy, &y);      n++;
  XtSetArg(wargs[n], XtNwidth, &width);      n++;
  XtSetArg(wargs[n], XtNheight, &height);      n++;
  XtGetValues(widget, wargs, n);
  XTranslateCoordinates(XtDisplay(widget), XtWindow(widget),
                	RootWindowOfScreen(XtScreen(widget)),
    		    x,y, &d_x, &d_y, &winDummy);
  n = 0;
  XtSetArg(wargs[n], XtNx, d_x-135);      n++; 
  XtSetArg(wargs[n], XtNy, d_y+height-1);      n++;
  XtSetValues(comboList, wargs, n);
  XtPopup(comboList, XtGrabExclusive);
  GrabUntilButtonDown(comboList);
}

void listCB(Widget widget, XtPointer clientData, XtPointer callData)
{
  Widget callWidget;
  XawListReturnStruct *listData;
  Arg wargs[1];
  
  /* String des bergebenen Text-Widgets setzen */
  if (clientData != NULL) {
    callWidget = (Widget)clientData;
    listData = (XawListReturnStruct *)callData;
    XtSetArg(wargs[0], XtNstring, listData->string);
    XtSetValues(callWidget, wargs, 1);
  }  
  /* ... und Liste Schlieen */  
  XtPopdown(XtParent(XtParent(widget)));
} 

