/*


 Copyright (C) 1990 Texas Instruments Incorporated.

 Permission is granted to any individual or institution to use, copy, modify,
 and distribute this software, provided that this complete copyright and
 permission notice is maintained, intact, in all copies and supporting
 documentation.

 Texas Instruments Incorporated provides this software "as is" without
 express or implied warranty.


 *
 * Defaults for compiler configuration.
 *
 * CC_libdir	default cpp include library
 * CPPARGS	default cpp arguments
 * CCFRONTARGS	default cfront arguments
 * CCARGS	default cc arguments
 * OBJ_Suffix	File extension for object files
 * CC_Suffix	File extension for translated source
 * CC_Library	default link library name
 * CC_lib       library name
 * CC_rt	For G++ only - runtime library object
 *
 * CC_cpp	cpp pathname
 * CC_compiler	C++ translator or compiler pathname
 * CC_cc	Standard C language compiler pathname
 * CC_as	Assembler pathname
 * CC_ld	Linker pathname
 * CC_munch	C++ muncher pathname
 * CC_patch	C++ patcher pathname
 */

/* CC_libdir */
#  define CC_libdir ""

/* C preprocessor */
#if !defined(CC_cpp)
# if defined(DOS)
#   define CC_cpp "\\ice\\cpp\\cpp"
# elif defined(M_XENIX)
#   define CC_cpp "/u/ice/cpp/cpp"
# else
#   define CC_cpp "/tan/u1/ice/cpp/cpp"
# endif
#endif

/* CC_compress */
#if !defined(CC_compress)
# if defined(DOS)
#   define CC_compress "\\ice\\id_comp"
# elif defined(M_XENIX)
#  define CC_compress "/u/ice/id_comp"
# else
#  define CC_compress ""
# endif
#endif


/* CPPARGS */
#if defined(hpux)
#  define CPPARGS ""
#elif defined(mips)
#  define CPPARGS "-B -DLANGUAGE_C -C"
#elif defined(DOS)
/*
 * Run under protected mode
 * Don't use pascal, near, far, etc.
 */
#  define CPPARGS "-D__PROT__"
#elif defined(M_XENIX)
#  define CPPARGS "-DM_I86 -DM_I86SM -DM_SDATA -DM_STEXT -DM_I386 -DM_XENIX -DM_BITFIELDS -DM_SYS5 -DM_SYS3 -DM_SYSIII -DM_WORDSWAP -C"
#else
#  define CPPARGS "-C"
#endif

/* CCFRONTARGS */ 
#if defined(DOS)
/*
 * +Q        Donot print logo
 * +zl30000  Lex input buffer size
 * +zf127    Max of 127 files??
 * +MX       Optimization flag
 * +ME       Use extended keywords. e.g. CDECL, PASCAL
 */
#  define CCFRONTARGS "+Q +Zl30000 +zf127 +MX +ME"
#elif defined(M_XENIX)
#  define CCFRONTARGS "+Z30000 +zf127"
#else
#  define CCFRONTARGS ""
#endif

/* CCARGS */
#if defined(DOS)
/* 
 * -w      Don't print warning messages
 * -G2     80286 instruction set
 * -Gt1    Put all static and global data over 1 byte in another segment
 * -nologo Suppress copyright print
 * -AL     Large storage model
 * -Zp     Pack data structures
 * -Zi     object includes debugging information
 */
/*
 * -Dconst= fixes bug in code generated by Glockenspeil C++ which causes
 *          Microsoft C to error about assigning to a const lvalue
*/
#  define CCARGS "-w -nologo -G2s -Gt1 -Alfu -Dconst="
#elif defined(M_XENIX)
/*
 * -w     Don't print warning messages
 * -g     object includes debugging information
 * -Zl    don't put default library information in object module
*/
#  define CCARGS ""
#else
#  define CCARGS ""
#endif

/* CC_compiler (translator/compiler) */
#if !defined(CC_compiler)
#   if defined(DOS) || defined(M_XENIX)
#       define CC_compiler "cfxx"
#   elif defined(cfront)
#       define CC_compiler "cfront"
#   elif defined(cfront2)
#       define CC_compiler "cfront2"
#   elif defined(cfront21)
#       define CC_compiler "cfront21"
#   else
#       define CC_compiler "g++"
#   endif
#endif

/* OBJ_Suffix (compiler output, linker input) */
#if !defined(OBJ_Suffix)
# if defined(DOS)
#   define OBJ_Suffix ".obj"
# else
#   define OBJ_Suffix ".o"
# endif
#endif

/* CC_suffix (cpp output suffix, compiler input suffix,  */
#if !defined(CC_suffix)
# if defined(DOS)
#   define CC_suffix ".i"
# elif defined(M_XENIX)
#   define CC_suffix ".c"
# elif defined(cfront)
#   define CC_suffix "..c"
# elif defined(cfront2) || defined(cfront21)
#   define CC_suffix ".c"
# else
#   define CC_suffix ".s"
# endif
#endif

/*  CC_library (library to search) */
#if !defined(CC_library)
#   if defined(DOS) && !defined(cfront2)
#       define CC_library "LLcxx5ep"
#   elif defined(DOS) && defined(cfront2)
#       define CC_library "Lcxxce"
#   elif defined(M_XENIX)
#       define CC_library "-lcxx"
#   elif defined(cfront21)
#       define CC_library "-lC21"
#   elif defined(cfront2)
#       define CC_library "-lC2"
#   elif defined(cfront)
#       define CC_library "-lC"
#   else
#       define CC_library "-lgnulib"
#   endif
#endif

/*  CC_lib  (utility for maintaining libraries) */
#if !defined(CC_lib)
#   if defined(DOS)
#       define CC_lib "Lib"
#   else
#       define CC_lib "ar"
#   endif
#endif

/*  CC_rt  (G++ only runtime support) */
#if !defined(CC_rt)
#   if defined(cfront) || defined(cfront2) || defined(cfront21)
#       define CC_rt ""
#   else
#       define CC_rt "/usr/local/lib/crt0+.o"
#   endif
#endif

/* CC_cc (compile and link routine) */
#if !defined(CC_cc)
#  if defined(DOS)
#    define CC_cc "cl"
#  elif defined(M_XENIX)
#    define CC_cc "cc"
#  else
#    define CC_cc "cc"
#  endif
#endif

#if !defined(CC_as)
#   define CC_as "as"
#endif

/*  CC_ld  (standalone linker) */
#if !defined(CC_ld)
# if defined(DOS)
#   define CC_ld "Link"
# elif defined(M_XENIX)
#   define CC_ld "cc"
# else
#   define CC_ld "cc"
# endif
#endif

/* CC 1.2 uses munch, CC 2.0 and 2.1 uses patch */
#if defined(cfront) || defined(CC_munch)
#   define CC_domunch
#endif

/*  CC_munch  (routine that modifies linked object for static inits) */
#if !defined(CC_munch)
#  if defined(DOS) || defined(M_XENIX)
#   define CC_munch "mxx"
#  elif defined(cfront)
#   define CC_munch "munch"
#  elif defined(cfront2)
#   define CC_munch "munch2"
#  elif defined(cfront21)
#   define CC_munch "munch21"
#  endif
#endif

/*  CC_patch  (routine for static inits) */
#if !defined(CC_patch)
# if defined(DOS) || defined(M_XENIX)
#  define CC_patch ""
# elif defined(cfront)
#  define CC_patch "patch"
# elif defined(cfront2)
#  define CC_patch "patch2"
# elif defined(cfront21)
#  define CC_patch "patch21"
# endif
#endif

#if !defined(CC_mv)
# if defined(DOS)
#   define CC_mv "ren"
# elif defined(M_XENIX)
#   define CC_mv "mv"
# else
#   define CC_mv "mv"
# endif
#endif

#if !defined(CC_tmp)
# if defined(DOS)
#  define CC_tmp "E:\\"
# else
#  define CC_tmp "/tmp/"
# endif
#endif
