//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Bignum.h>
#include <test.h>

void run_constructor_tests() {
  cout << "\nBignum constructor tests:\n";

  cout << "long constructor:\n";
  {Bignum b2(long(0));
  TEST ("Bignum b2(long(0));", (long)b2 == (long)0, TRUE);}

  {Bignum b3(long(1));
  TEST ("Bignum b3(long(1));", (long)b3 == (long)1, TRUE);}

  {Bignum b4(long(-1));
  TEST ("Bignum b4(long(-1));", (long)b4 == (long)-1, TRUE);}

  {Bignum b5(long(MAXSHORT));
  TEST ("Bignum b5(long(MAXSHORT));", (long)b5 == (long)MAXSHORT, TRUE);}
  
  {Bignum b6(long(-MAXSHORT));
  TEST ("Bignum b6(long(-MAXSHORT));", (long)b6 == (long)-MAXSHORT, TRUE);}

  {Bignum b7(long(MAXINT));
  TEST ("Bignum b7(long(MAXINT));", (long)b7 == (long)MAXINT, TRUE);}

  {Bignum b8(long(-MAXINT));
  TEST ("Bignum b8(long(-MAXINT));", (long)b8 == (long)-MAXINT, TRUE);}

  {Bignum b9(long(MAXLONG));
  TEST ("Bignum b9(long(MAXLONG));", (long)b9 == (long)MAXLONG, TRUE);}

  {Bignum b10(long(-MAXLONG));
  TEST ("Bignum b10(long(-MAXLONG));", (long)b10 == (long)-MAXLONG, TRUE);}

  {Bignum b10l(long(0xF00000l));
  TEST ("Bignum b10l(long(0xF00000l));", (long)b10l == 0xF00000, TRUE);}

  cout << "double constructor:\n";
  {Bignum b11(0.0);
  TEST ("Bignum b11(0.0);", (double)b11 == 0.0, TRUE);}

  {Bignum b12(1.0);
  TEST ("Bignum b12(1.0);", (double)b12 == 1.0, TRUE);}

  {Bignum b13(-1.0);
  TEST ("Bignum b13(-1.0);", (double)b13 == -1.0, TRUE);}

  {Bignum b14(MAXDOUBLE);
  TEST ("Bignum b14(MAXDOUBLE);", (double)b14 == MAXDOUBLE, TRUE);}

  {Bignum b15(-MAXDOUBLE);
  TEST ("Bignum b15(-MAXDOUBLE);", (double)b15 == -MAXDOUBLE, TRUE);}

  {Bignum b16(1234567.0);
  TEST ("Bignum b16(1234567.0);", (double)b16 == 1234567.0, TRUE);}

  {Bignum b17(-1234567.0);
  TEST ("Bignum b17(-1234567.0);", (double)b17 == -1234567.0, TRUE);}

  {Bignum b18(1234567000.0);
  TEST ("Bignum b18(1234567000.0);", (double)b18 == 1234567000.0, TRUE);}

  {Bignum b19(-1234567000.0);
  TEST ("Bignum b19(-1234567000.0);", (double)b19 == -1234567000.0, TRUE);}

  {Bignum b20(double(0xF00000)); TEST ("Bignum b20(double(0xF00000));",
				      (double)b20 == (double)0xF00000, TRUE);}

  cout << "char* constructor:\n";
  {Bignum b21("-1");
  TEST ("Bignum b21(\"-1\");", (long)b21 == -1, TRUE);}

  {Bignum b22("+1");
  TEST ("Bignum b22(\"+1\");", (long)b22 == 1, TRUE);}

  {Bignum b23("1");
  TEST ("Bignum b23(\"1\");", (long)b23 == 1, TRUE);}

  {Bignum b24("123");
  TEST ("Bignum b24(\"123\");", (long)b24 == 123, TRUE);}

  {Bignum b25("123e12");
  TEST ("Bignum b25(\"123e12\");", (double)b25 == 123e12, TRUE);}

  {Bignum b26("123e120");
  TEST ("Bignum b26(\"123e120\");", (double)b26 == 123e120, TRUE);}

  {Bignum b27("0x0");
  TEST ("Bignum b27(\"0x0\");", (long)b27 == 0x0, TRUE);}

  {Bignum b28("0x9");
  TEST ("Bignum b28(\"0x9\");", (long)b28 == 0x9, TRUE);}

  {Bignum b29("0xa");
  TEST ("Bignum b29(\"0xa\");", (long)b29 == 0xa, TRUE);}

  {Bignum b30("0xf");
  TEST ("Bignum b30(\"0xf\");", (long)b30 == 0xf, TRUE);}

  {Bignum b31("0xA");
  TEST ("Bignum b31(\"0xA\");", (long)b31 == 0xA, TRUE);}

  {Bignum b32("0xF");
  TEST ("Bignum b32(\"0xF\");", (long)b32 == 0xF, TRUE);}

  {Bignum b33("0x1aF");
  TEST ("Bignum b33(\"0x1aF\");", (long)b33 == 0x1aF, TRUE);}

  {Bignum b34("0");
  TEST ("Bignum b34(\"0\");", (long)b34 == 0, TRUE);}

  {Bignum b35("00");
  TEST ("Bignum b35(\"00\");", (long)b35 == 0, TRUE);}

  {Bignum b36("012334567");
  TEST ("Bignum b36(\"012334567\");", (long)b36 == 012334567, TRUE);}

  {Bignum b37("9");
  TEST ("Bignum b37(\"9\");", (long)b37 == 9, TRUE);}

//  Bignum b38("09");
//  TEST ("Bignum b38(\"09\");", (long)b38 == 9, TRUE);

//  Bignum b39(" 9");
//  TEST ("Bignum b39(\" 9\");", (long)b39 == 9, TRUE);

  {Bignum b40("0XF");
  TEST ("Bignum b40(\"0XF\");", (long)b40 == 0XF, TRUE);}

  cout << "Bignum& constructor:\n";
  {Bignum b50(Bignum(0l));
  TEST ("Bignum b50(Bignum(0l));", (long)b50 == 0l, TRUE);}

  {Bignum b51(Bignum(100l));
  TEST ("Bignum b51(Bignum(100l));", (long)b51 == 100l, TRUE);}
}

void run_conversion_operator_tests() {
  cout << "\nConversion operator tests:\n";

  cout << "short conversion operator:\n";
  TEST("short(Bignum(0l)) == 0", short(Bignum(0l)) == 0, TRUE);
  TEST("short(Bignum(long(MAXSHORT))) == MAXSHORT",
       short(Bignum(long(MAXSHORT))) == MAXSHORT, TRUE);
  TEST("short(Bignum(long(-MAXSHORT))) == -MAXSHORT",
       short(Bignum(long(-MAXSHORT))) == -MAXSHORT, TRUE);

  TEST("short(Bignum(long(-MAXSHORT+1))) == short(-MAXSHORT+1)",
       short(Bignum(long(-MAXSHORT+1))) == short(-MAXSHORT+1), TRUE);

//  TEST("short(Bignum(long(MAXSHORT+1))) == short(MAXSHORT+1)",
//       short(Bignum(long(MAXSHORT + 1))) == short(MAXSHORT + 1), TRUE);

  cout << "int conversion operator:\n";
  TEST("int(Bignum(0l)) == 0", int(Bignum(0l)) == 0, TRUE);
  TEST("int(Bignum(long(MAXINT))) == MAXINT",
      int(Bignum(long(MAXINT))) == MAXINT, TRUE);
  TEST("int(Bignum(long(-MAXINT))) == -MAXINT",
       int(Bignum(long(-MAXINT))) == -MAXINT, TRUE);

  {Bignum b(long(MAXINT));
  b++;
//  TEST("Bignum b(long(MAXINT); b++; (int)b == int(MAXINT+1)",
//       (int)b == int(MAXINT+1), TRUE);

  b = -b;
//  TEST("Bignum b(long(MAXINT); b++; b=-b; (int)b == int(-(MAXINT+1))",
//       (int)b == int(-(MAXINT+1)), TRUE);

  cout << "long conversion operator:\n";
  TEST("long(Bignum(0l)) == 0", long(Bignum(0l)) == 0, TRUE);
  TEST("long(Bignum(MAXLONG)) == MAXLONG",
       long(Bignum(MAXLONG)) == MAXLONG, TRUE);
  TEST("long(Bignum(-MAXLONG)) == -MAXLONG",
       long(Bignum(-MAXLONG)) == -MAXLONG, TRUE);

  b = long(MAXLONG);
  b++;
//  TEST("Bignum b; b =(long(MAXLONG); b++; (long)b == long(MAXLONG+1)",
//       (long)b == long(MAXLONG+1), TRUE);

  b = -b;
//  TEST("Bignum b = (long(MAXLONG); b++; b=-b; (long)b == long(-(MAXLONG+1))",
//       (long)b == long(-(MAXLONG+1)), TRUE);

  cout << "float conversion operator:\n";
  float f;
  TEST("float(Bignum(0.0)) == 0.0", ((float) Bignum(0.0)) == 0.0, TRUE);
  TEST("float(Bignum(99999.0)) == 99999.0",
       ((float) Bignum(99999.0)) == 99999.0, TRUE);
  TEST("float(Bignum(MAXFLOAT)) == MAXFLOAT",
       ((f = MAXFLOAT) == (float) Bignum(MAXFLOAT)), TRUE);
  TEST("float(Bignum(-MAXFLOAT)) == -MAXFLOAT",
       ((f = -MAXFLOAT) == float(Bignum(-MAXFLOAT))), TRUE);
  b = MAXDOUBLE;
  b++;
//  f = (float) b;
//  TEST("Bignum b = MAXDOUBLE; b++; (float)b == float(MAXDOUBLE+1)",
//       f == float(MAXDOUBLE+1), TRUE);

//  f = (float) (-b);
//  TEST("Bignum b = MAXDOUBLE; b++, b=-b; (float)b == float(-(MAXDOUBLE+1))",
//       f = float(-(MAXDOUBLE+1)), TRUE);


  cout << "double conversion operator:\n";
  double d;
  TEST("double(Bignum(0.0)) == 0.0", ((double) Bignum(0.0)) == 0.0, TRUE);
  TEST("double(Bignum(99999.0)) == 99999.0",
       (double) Bignum(99999.0) == 99999.0, TRUE);
  TEST("double(Bignum(1e300)) == 1e300",
       double(Bignum(1e300)) == 1e300, TRUE);
  TEST("double(Bignum(-1e300)) == -1e300",
       double(Bignum(-1e300)) == -1e300, TRUE);
  TEST("double(Bignum(MAXFLOAT)) == MAXFLOAT",
       ((d = MAXFLOAT) == (double) Bignum(MAXFLOAT)), TRUE);
  TEST("double(Bignum(-MAXFLOAT)) == -MAXFLOAT",
       ((d = -MAXFLOAT) == double(Bignum(-MAXFLOAT))), TRUE);
  TEST("double(Bignum(MAXDOUBLE)) == MAXDOUBLE",
       (double) Bignum(MAXDOUBLE) == MAXDOUBLE, TRUE);
  TEST("double(Bignum(-MAXDOUBLE)) == -MAXDOUBLE",
       (double) Bignum(-MAXDOUBLE) == -MAXDOUBLE, TRUE);
//  d = (double) b;
//  TEST("Bignum b = MAXDOUBLE; b++; (double)b == double(MAXDOUBLE+1)",
//       d == float(MAXDOUBLE+1), TRUE);

//  d = (double) (-b);
//  TEST("Bignum b =MAXDOUBLE; b++, b=-b; (double)b == double(-(MAXDOUBLE+1))",
//       d = float(-(MAXDOUBLE+1)), TRUE);
}}

void run_assignment_tests() {
  cout << "\nStarting assignment tests:\n";
  Bignum b1;

  TEST_RUN ("Bignum b1; b1 = 0xffff;", b1 = 0xffffl,
	    long(b1) == 0xffffl, TRUE);

  // double assignment operator
  TEST_RUN ("double(b1) == -1.23e6", b1 = -1.23e6,
	    double(b1) == -1.23e6, TRUE);

  // long assignment operator
  TEST_RUN ("long(b1) = -MAXINT", b1 = long(-MAXINT),
	    long(b1) == -MAXINT, TRUE);

  // char * assignment operator
  TEST_RUN ("long(b1) = 0x1FFFFFl", b1 = "0x1FFFFF",
	    long(b1) == 0x1fffffl, TRUE);


  // Bignum& assignment operator
  b1 = "0x1FFFFF";
  Bignum b5(0x1FFFFl);
  TEST_RUN ("b1 = b5", b1 = b5, b1 == b5, TRUE);
}

void run_logical_comparison_tests() {
  cout << "\nStarting logical comparison tests:\n";
  Bignum b0(long(0));
  Bignum b1(long(1));
  Bignum b2(long(MAXSHORT));
  Bignum b3(long(-MAXSHORT));

  TEST("b0 == b0", b0 == b0, TRUE);
  TEST("b0 == b1", b0 == b1, FALSE);
  TEST("b0 == b2", b0 == b2, FALSE);
  TEST("b0 == b3", b0 == b3, FALSE);
  TEST("b1 == b2", b1 == b2, FALSE);
  TEST("b1 == b3", b1 == b3, FALSE);
  TEST("b2 == b3", b2 == b3, FALSE);

  TEST("b0 != b0", b0 != b0, FALSE);
  TEST("b0 != b1", b0 != b1, TRUE);
  TEST("b0 != b2", b0 != b2, TRUE);
  TEST("b0 != b3", b0 != b3, TRUE);
  TEST("b1 != b2", b1 != b2, TRUE);
  TEST("b1 != b3", b1 != b3, TRUE);
  TEST("b2 != b3", b2 != b3, TRUE);

  TEST("b0 < b0", b0 < b0, FALSE);
  TEST("b0 < b1", b0 < b1, TRUE);
  TEST("b0 < b2", b0 < b2, TRUE);
  TEST("b0 < b3", b0 < b3, FALSE);
  TEST("b1 < b2", b1 < b2, TRUE);
  TEST("b1 < b3", b1 < b3, FALSE);
  TEST("b2 < b3", b2 < b3, FALSE);

  TEST("b0 > b0", b0 > b0, FALSE);
  TEST("b0 > b1", b0 > b1, FALSE);
  TEST("b0 > b2", b0 > b2, FALSE);
  TEST("b0 > b3", b0 > b3, TRUE);
  TEST("b1 > b2", b1 > b2, FALSE);
  TEST("b1 > b3", b1 > b3, TRUE);
  TEST("b2 > b3", b2 > b3, TRUE);

  TEST ("b3 != b2", b3 != b2, TRUE);
  TEST ("b3 != b3", b3 != b3, FALSE);
  TEST ("b3 < b2", b3 < b2, TRUE);
  TEST ("b3 <= b2", b3 <= b2, TRUE);
  TEST ("b3 <= b3", b3 <= b3, TRUE);
  TEST ("b3 > b3", b3 > b3, FALSE);
  TEST ("b3 > b2", b3 > b2, FALSE);
  TEST ("b3 >= b2", b3 >= b2, FALSE);
  TEST ("b3 >= b3", b3 >= b3, TRUE);
  TEST ("b2 >= b2", b2 >= b2, TRUE);
}

void run_division_tests() {
  cout << "\nStarting division tests:\n";

  TEST("long(Bignum(0l)/Bignum(1l))", long(Bignum(0l)/Bignum(1l)), 0);
  TEST("long(Bignum(-1l)/Bignum(1l))", long(Bignum(-1l)/Bignum(1l)), -1);

  Bignum b1,b2,b3;
  long i,j,k,l;
  long div_errors = 0;
  long mod_errors = 0;

  cout << " for (i = 0xFFFFFF; i > 0; i /= 0x10) \n";
  cout << "   for (j = 0x7FFFFFF; j > 0; j /= 0x10) \n";
  cout << "     for (k = 1; k < 17; k++) \n";
  cout << "       for (l = 1; l < 17; l++) \n         ";
  {for (i = 0xFFFFFF; i > 0; i /= 0x10) {
    cout.put('.');
    cout.flush();
    for (j = 0x7FFFFFF; j > 0; j /= 0x10) {
      for (k = 1; k < 17; k++) {
	for (l = 1; l < 17; l++) {
	  b1 = Bignum(i+k);
	  b2 = Bignum(j+l);
	  b3 = Bignum(long((i+k)/(j+l)));
	  if (b1/b2 != b3) {
	    TEST("(Bignum(i+k)/Bignum(j+l)) == Bignum(long((i+k)/(j+l)))",
		 FALSE, TRUE);
	    cout << form("i=%X, j=%X, k=%X, l=%X\n",i,j,k,l);
	    div_errors++;
	  }
	  b3 = Bignum(long((i+k)%(j+l)));
	  if (b1%b2 != b3) {
	    TEST("(Bignum(i+k)%Bignum(j+l)) == Bignum(long((i+k)%(j+l)))",
		 FALSE, TRUE);
	    cout << form("i=%X, j=%X, k=%X, l=%X\n",i,j,k,l);
	    mod_errors++;
	  }
	}
      }
    }
  }}

  cout << "\n";
  TEST("(Bignum(i+k)/Bignum(j+l)) == Bignum(long((i+k)/(j+l)))",
       div_errors == 0, TRUE);
  TEST("(Bignum(i+k)%Bignum(j+l)) == Bignum(long((i+k)%(j+l)))",
       mod_errors == 0, TRUE);

/*
  char num[130], den[130];
  Bignum b,r;
  
  while (1) {
    cout << "Enter next numerator:  ";
    cin >> num;
    cout << "Enter next denominator:  ";
    cin >> den;

    b = Bignum(num)/Bignum(den);
    r = Bignum(num) % Bignum(den);
    cout << "\nquotient  = " << b << "\n";
    cout <<   "            "; b.dump(); cout << "\n";
    cout << "\nremainder = " << r << "\n";
    cout <<   "            "; r.dump(); cout << "\n";

  }
*/
}

void run_addition_subtraction_tests() {
  cout << "\nStarting addition, subtraction tests:\n";

  long i,j;
  long add_errors = 0;
  long sub_errors = 0;
  Bignum bi,bj,bij;

  cout << " for (i = 1; i < 0xFFFFFFF;  i *= 3) \n";
  cout << "   for (j = 1; j < 0xFFFFFFF; j *= 3) \n      ";

  {for (i = 1; i < 0xFFFFFFF;  i *= 3) {
    cout.put('.');
    cout.flush();
    for (j = 1; j < 0xFFFFFFF; j *= 3) {
      bi = i;
      bj = j;
      bij = Bignum(i+j);
      if (bi + bj != bij) {
	TEST("bi + bj == Bignum(i + j)", FALSE, TRUE);
	cout << form("i = %X, j = %X\n",i,j);
	add_errors++;
      }
      bij = Bignum(i-j);
      if (bi - bj != bij) {
        TEST("bi - bj == Bignum(i - j)", FALSE, TRUE);
	cout << form("i = %X, j = %X\n",i,j);
	sub_errors++;
      }
    }
  }}
  cout << "\n";
  TEST("bi + bj == Bignum(i + j)", add_errors==0, TRUE);
  TEST("bi - bj == Bignum(i - j)", sub_errors==0, TRUE);

  Bignum b0(0l);
  Bignum zillion("1000000000000000000");
  Bignum b1000(1000l), b1000000(1000000l);

  TEST("-b0 == b0", (-b0 == b0), TRUE);
  TEST("-b1000 == Bignum(-1l)*b1000", (-b1000 == Bignum(-1l)*b1000), TRUE);
  TEST("-(-b1000000) == b1000000", (-(-b1000000) == b1000000), TRUE);
  TEST("b0 + b1000 == b1000", (b0 + b1000 == b1000), TRUE);
  TEST("b0 + b1000000 == b1000000", (b0 + b1000000 == b1000000), TRUE);
  TEST("b1000 + b0 == b1000", (b1000 + b0 == b1000), TRUE);
  TEST("b1000000 + b0 == b1000000", (b1000000 + b0 == b1000000), TRUE);
  TEST("b0 + (-b1000) == -b1000", (b0 + (-b1000) == -b1000), TRUE);
  TEST("-b1000 + b0 == -b1000", (-b1000 + b0 == -b1000), TRUE);
  TEST("-b1000 + (-b1000) == (Bignum(2l)*(-b1000))",
       (-b1000 + (-b1000) == (Bignum(2l)*(-b1000))), TRUE);
  TEST("-b1000000 + (-b1000000) == (Bignum(2l)*(-b1000000))",
       (-b1000000 + (-b1000000) == (Bignum(2l)*(-b1000000))), TRUE);
  TEST("b1000000 + (-b1000000) == b0", (b1000000 + (-b1000000) == b0), TRUE);
  TEST("zillion + (-zillion) == b0", (zillion + (-zillion) == b0), TRUE);
  TEST("zillion + b1000 == b1000000*b1000000*b1000000 + b1000",
       (zillion + b1000 == b1000000*b1000000*b1000000 + b1000), TRUE);

  TEST("-b0 == b0", (-b0 == b0), TRUE);
  TEST("-b1000 == Bignum(-1l)*b1000", (-b1000 == Bignum(-1l)*b1000), TRUE);
  TEST("-(-b1000000) == b1000000", (-(-b1000000) == b1000000), TRUE);

  TEST("b0 - b1000 == -b1000", (b0 - b1000 == -b1000), TRUE);
  TEST("b0 - b1000000 == -b1000000", (b0 -b1000000 == -b1000000), TRUE);
  TEST("b1000 - b0 == b1000", (b1000 - b0 == b1000), TRUE);
  TEST("b1000000 - b0 == b1000000", (b1000000 - b0 == b1000000), TRUE);
  TEST("b0 - (-b1000) == b1000", (b0 - (-b1000) == b1000), TRUE);
  TEST("-b1000 - b0 == -b1000", (-b1000 - b0 == -b1000), TRUE);
  TEST("-b1000 - (-b1000) == b0", (-b1000 - (-b1000) == b0), TRUE);
  TEST("-b1000 - (-zillion) == zillion - b1000",
       (-b1000 - (-zillion) == zillion - b1000), TRUE);
  TEST("-b1000000 - (-b1000000) == b0", (-b1000000 - (-b1000000) == b0), TRUE);
  TEST("-b1000000 - (b1000000) == -Bignum(2l)*b1000000",
       (-b1000000 - (b1000000) == -Bignum(2l)*b1000000), TRUE);
  TEST("b1000000 - (-b1000000) == Bignum(2l)*b1000000",
       (b1000000 - (-b1000000) == Bignum(2l)*b1000000), TRUE);
  TEST("zillion - (-zillion) == Bignum(2l)*zillion",
       (zillion - (-zillion) == Bignum(2l)*zillion), TRUE);
  TEST("zillion - b1000 == b1000000*b1000000*b1000000 - b1000",
       (zillion - b1000 == b1000000*b1000000*b1000000 - b1000), TRUE);
  TEST("-zillion - b1000 == -b1000000*b1000000*b1000000 - b1000",
       (-zillion - b1000 == -b1000000*b1000000*b1000000 - b1000), TRUE);
}

void run_multiplication_tests() {
  cout << "\nStarting multiplication tests:\n";

  Bignum b0(0l), b1000(1000l), b1000000(1000000l),
  zillion("1000000000000000000");

  
  TEST("b0*b0 == b0", (b0*b0 == b0), TRUE);
  TEST("b0*b1000 == b0", (b0*b1000 == b0), TRUE);
  TEST("b1000*b0 == b0", (b1000*b0 == b0), TRUE);
  TEST("b1000*b1000 == b1000000", (b1000*b1000 == b1000000), TRUE);
  TEST("b1000*b1000000 == b1000000*b1000",
       (b1000*b1000000 == b1000000*b1000), TRUE);
  TEST("-b1000000*b1000000*b1000000 == -zillion",
       (-b1000000*b1000000*b1000000 == -zillion), TRUE);
  TEST("zillion*-b1000 == b1000*-zillion",
       (zillion*-b1000 == b1000*-zillion), TRUE);
}

void run_left_shift_tests() {

  Bignum b1(1l);

  // left shift
  TEST("int(b1) == 1",int(b1) == 1,TRUE);
  TEST("long(b1 << 1) == 2",long(b1 << 1) == 2,TRUE);
  TEST("long(b1 << 2) == 4",long(b1 << 2) == 4,TRUE);
  TEST("long(b1 << 3) == 8",long(b1 << 3) == 8,TRUE);
  TEST("long(b1 << 4) == 16",long(b1 << 4) == 16,TRUE);
  TEST("long(b1 << 5) == 32",long(b1 << 5) == 32,TRUE);
  TEST("long(b1 << 6) == 64",long(b1 << 6) == 64,TRUE);
  TEST("long(b1 << 7) == 128",long(b1 << 7) == 128,TRUE);
  TEST("long(b1 << 8) == 256",long(b1 << 8) == 256,TRUE);
  TEST("long(b1 << 9) == 512",long(b1 << 9) == 512,TRUE);
  TEST("long(b1 << 10) == 1024",long(b1 << 10) == 1024,TRUE);
  TEST("long(b1 << 11) == 2048",long(b1 << 11) == 2048,TRUE);
  TEST("long(b1 << 12) == 4096",long(b1 << 12) == 4096,TRUE);
  TEST("long(b1 << 13) == 8192",long(b1 << 13) == 8192,TRUE);
  TEST("long(b1 << 14) == 16384",long(b1 << 14) == 16384,TRUE);
  TEST("long(b1 << 15) == 32768",long(b1 << 15) == 32768,TRUE);
  TEST("long(b1 << 16) == 65536",long(b1 << 16) == 65536,TRUE);
  TEST("(b1 << 32) == Bignum(\"4294967296\")",
       (b1 << 32) == Bignum("4294967296"),TRUE);
  TEST("long(-b1 << 1) == -2",long(-b1 << 1) == -2,TRUE);
  TEST("long(-b1 << 2) == -4",long(-b1 << 2) == -4,TRUE);
  TEST("long(-b1 << 3) == -8",long(-b1 << 3) == -8,TRUE);
  TEST("long(-b1 << 4) == -16",long(-b1 << 4) == -16,TRUE);
  TEST("long(-b1 << 5) == -32",long(-b1 << 5) == -32,TRUE);
  TEST("long(-b1 << 6) == -64",long(-b1 << 6) == -64,TRUE);
  TEST("long(-b1 << 7) == -128",long(-b1 << 7) == -128,TRUE);
  TEST("long(-b1 << 8) == -256",long(-b1 << 8) == -256,TRUE);
  TEST("long(-b1 << 9) == -512",long(-b1 << 9) == -512,TRUE);
  TEST("long(-b1 << 10) == -1024",long(-b1 << 10) == -1024,TRUE);
  TEST("long(-b1 << 11) == -2048",long(-b1 << 11) == -2048,TRUE);
  TEST("long(-b1 << 12) == -4096",long(-b1 << 12) == -4096,TRUE);
  TEST("long(-b1 << 13) == -8192",long(-b1 << 13) == -8192,TRUE);
  TEST("long(-b1 << 14) == -16384",long(-b1 << 14) == -16384,TRUE);
  TEST("long(-b1 << 15) == -32768",long(-b1 << 15) == -32768,TRUE);
  TEST("long(-b1 << 16) == -65536",long(-b1 << 16) == -65536,TRUE);
  TEST("(-b1 << 32) == Bignum(\"-4294967296\")",
       (-b1 << 32) == Bignum("-4294967296"),TRUE);
  TEST("long(b1 << -16) == 0",long(b1 << -16) == 0,TRUE);
  TEST("long(-b1 << -16) == 0",long(-b1 << -16) == 0,TRUE);
}

void run_right_shift_tests() {
  // right shift
  Bignum b2("4294967296");
  TEST("b2 == Bignum(\"4294967296\")",b2 == Bignum("4294967296"), TRUE);
  TEST("(b2 >> 1) == Bignum(\"2147483648\")",
       (b2 >> 1) == Bignum("2147483648"),TRUE);
  TEST("long(b2 >> 2) == 1073741824",long(b2 >> 2) == 1073741824l,TRUE);
  TEST("long(b2 >> 3) == 536870912",long(b2 >> 3) == 536870912l,TRUE);
  TEST("long(b2 >> 4) == 268435456",long(b2 >> 4) == 268435456l,TRUE);
  TEST("long(b2 >> 5) == 134217728",long(b2 >> 5) == 134217728l,TRUE);
  TEST("long(b2 >> 6) == 67108864",long(b2 >> 6) == 67108864l,TRUE);
  TEST("long(b2 >> 7) == 33554432",long(b2 >> 7) == 33554432l,TRUE);
  TEST("long(b2 >> 8) == 16777216",long(b2 >> 8) == 16777216l,TRUE);
  TEST("long(b2 >> 9) == 8388608",long(b2 >> 9) == 8388608l,TRUE);
  TEST("long(b2 >> 10) == 4194304",long(b2 >> 10) == 4194304l,TRUE);
  TEST("long(b2 >> 11) == 2097152",long(b2 >> 11) == 2097152l,TRUE);
  TEST("long(b2 >> 12) == 1048576",long(b2 >> 12) == 1048576l,TRUE);
  TEST("long(b2 >> 13) == 524288",long(b2 >> 13) == 524288l,TRUE);
  TEST("long(b2 >> 14) == 262144",long(b2 >> 14) == 262144l,TRUE);
  TEST("long(b2 >> 15) == 131072",long(b2 >> 15) == 131072l,TRUE);
  TEST("long(b2 >> 16) == 65536",long(b2 >> 16) == 65536l,TRUE);
  TEST("long(b2 >> 32) == 1",long(b2 >> 32) == 1l,TRUE);
  TEST("long(b2 >> 33) == 0",long(b2 >> 33) == 0l,TRUE);
  TEST("long(b2 >> 67) == 0",long(b2 >> 67) == 0l,TRUE);
  TEST("(-b2 >> 1) == Bignum(\"-2147483648\")",
       (-b2 >> 1) == Bignum("-2147483648"),TRUE);
  TEST("long(-b2 >> 2) == -1073741824",long(-b2 >> 2) == -1073741824l,TRUE);
  TEST("long(-b2 >> 3) == -536870912",long(-b2 >> 3) == -536870912l,TRUE);
  TEST("long(-b2 >> 4) == -268435456",long(-b2 >> 4) == -268435456l,TRUE);
  TEST("long(-b2 >> 5) == -134217728",long(-b2 >> 5) == -134217728l,TRUE);
  TEST("long(-b2 >> 6) == -67108864",long(-b2 >> 6) == -67108864l,TRUE);
  TEST("long(-b2 >> 7) == -33554432",long(-b2 >> 7) == -33554432l,TRUE);
  TEST("long(-b2 >> 8) == -16777216",long(-b2 >> 8) == -16777216l,TRUE);
  TEST("long(-b2 >> 9) == -8388608",long(-b2 >> 9) == -8388608l,TRUE);
  TEST("long(-b2 >> 10) == -4194304",long(-b2 >> 10) == -4194304l,TRUE);
  TEST("long(-b2 >> 11) == -2097152",long(-b2 >> 11) == -2097152l,TRUE);
  TEST("long(-b2 >> 12) == -1048576",long(-b2 >> 12) == -1048576l,TRUE);
  TEST("long(-b2 >> 13) == -524288",long(-b2 >> 13) == -524288l,TRUE);
  TEST("long(-b2 >> 14) == -262144",long(-b2 >> 14) == -262144l,TRUE);
  TEST("long(-b2 >> 15) == -131072",long(-b2 >> 15) == -131072l,TRUE);
  TEST("long(-b2 >> 16) == -65536",long(-b2 >> 16) == -65536l,TRUE);
  TEST("long(-b2 >> 32) == -1",long(-b2 >> 32) == -1,TRUE);
  TEST("long(-b2 >> 33) == -0",long(-b2 >> 33) == 0,TRUE);
  TEST("long(-b2 >> 67) == -0",long(-b2 >> 67) == 0,TRUE);
}
void run_shift_tests() {
  cout << "\nStarting shift tests:\n";

  run_left_shift_tests();
  run_right_shift_tests();
/*
  Bignum b;
  char s[100];
  int sh;

  while (1) {
    cout << "Enter next Bignum:  ";
    cin >> s;
    b = s;
    cout << "Enter shift amount: ";
    cin >> sh;
    cout << "Shift == " << sh << "\n";

    b = b << sh;
  }
*/    
}

int main (void) {
  START("Bignum");

  run_constructor_tests();
  run_conversion_operator_tests();
  run_assignment_tests();
  run_addition_subtraction_tests();
  run_multiplication_tests();
  run_division_tests();
  run_shift_tests();
  run_logical_comparison_tests();

  SUMMARY();
  return 0;
}
