//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/23/90 -- Changed handler func to a default handler method.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

#if defined(DOS)
extern "C" {
#include <stdlib.h>				// For abort()
}
#else
#include <stdlib.h>				// For abort()
#endif


// ******************************************************
// Member function for Fatal class
// ******************************************************

// Fatal::default_handler() -- the default handler for Fatal exceptions
//                             reports its error message on standard error
//                             and terminates program with abort().
// INPUT:   None.
// OUTPUT:  None.

void Fatal::default_handler() {
  this->report(cerr);		// report error message
  abort();			// and terminates with core dump
}
