//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate files.
// Updated: LGO 10/05/89 -- Use error_msg_buffer, instead of throwing
//                          MSG_MAX bytes to the heap every time.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/char.h>
#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

#ifndef STDARGH					// If variable args not defined
# if defined(M_XENIX)
#  include <stdarg.hxx>
# else
#  include <stdarg.h>
# endif
#define STDARGH
#endif

// ***************************************************************************
// hprintf - a heap vprintf
// ***************************************************************************

char error_msg_buffer[MSG_MAX];	// Temporary storage for error message 

char* hprintf(const char* format_string, ...) {
  va_list format_args;
  va_start(format_args, format_string);
  // The char* cast below is a Cfront 2.0 stdarg.h bug workaround
  vsprintf(error_msg_buffer, (char*) format_string, format_args);
  va_end(format_args);
  return strdup(error_msg_buffer);
}

