//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 06/06/89 -- Initial implementation
// Updated: LGO 09/19/89 -- Split into one file per method
// Updated: MBN 10/12/89 -- Changed "current_position" to "curpos" 

#include <cool/Generic.h>
#include <cool/Base_Hash.h>

// clear -- Empty the hash table, but don't change allocated space
// Input:   this*
// Output   None

void Hash_Table::clear () {
  for (int i = 0; i < hash_primes[this->current_bucket]; i++) // For each bucket
    this->items_in_buckets[i] = 0;			      // Zero count
  this->entry_count = 0;				      // Entries to 0
  this->curpos = INVALID;				      // Invalid curpos
}
