//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created:  MBN 08/31/89 -- Initial design and implementation
// Modified: LGO 09/19/89 -- Split into seperate files
// Updated:  MBN 10/11/89 -- Changed "current_position" to "curpos"
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>				// Include the class header

// Vector (long) -- Constructor that specifies number of elements.
// Input:           Number of elements 
// Output:          None

Vector::Vector (long n) {
  this->size = n;				// Element capacity
  this->number_elements = 0;			// No elements in Vector
  this->curpos = INVALID;			// Invalidate current position
  alloc_size = MEM_BLK_SZ;			// Set memory block size
#ifndef __cplusplus
  if (this->growth_ratio == 0.0)		// If not initialized
    this->growth_ratio = 0.0;			// Initialize growth ratio
#endif
}




