(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 14 08:04:13 PST 1992 by kalsow     *)

UNSAFE INTERFACE RT0u;

(* This interface is almost "the bottom of the world".  It contains
   variables that are shared by multiple modules of the runtime
   and/or the compiler and linker.

   If you're using this interface, you're a wizard!

   This interface and its implemenation MUST NOT import any
   interface other than RT0.
*)

IMPORT RT0;

(*------------------------------------------------------ linker interface ---*)

(* these variables are initialized by the linker *)

TYPE LOTS = [ 0 .. 999999 ];

VAR
  nModules : LOTS;   (* == number of compilation units in program *)
  nTypes   : LOTS;   (* == max allocated typecode *)

VAR modules: UNTRACED REF ARRAY LOTS OF RT0.ModuleInfo;
(* allocated by the linker, its actual bounds are [0..nModules-1] *)

VAR types: UNTRACED REF ARRAY LOTS OF RT0.TypeDefinition;
(* allocated by the linker, its actual bounds are [0..nTypes-1] *)

(*------------------------------------------------------ mutual exclusion ---*)

VAR inCritical: INTEGER := 0;
(* inCritical provides low-level mutual exclusion between the thread
   runtime, garbage collector and the Unix signal that triggers thread
   preemption.  If inCritical is greater than zero, thread preemption
   is disabled.  We *ASSUME* that "INC(inCritical)" and "DEC(inCritical)"
   generate code that is atomic with respect to Unix signal delivery. *)

END RT0u.
