(* PC version *)

UNSAFE MODULE System EXPORTS System;

IMPORT M3toC, Cstdlib, Text, Word, Time, Fmt, Filename, NameMap,
    Wr, Rd, Stdio, Thread, RdUtils,
    Ustat, Unix, Uprocess, Usignal, Uregexp, Udos, Uerror, Utime;
FROM Ctypes IMPORT char_star, long_star;



PROCEDURE FatalNameMapError(err: REFANY) =                 
    <*FATAL Thread.Alerted, Wr.Failure*>
    BEGIN
        Wr.PutText(Stdio.stderr, "NameMap: *** fatal error ***: "&
                            RdUtils.FailureText(err)&"\n");
        Wr.Flush(Stdio.stderr);
        Exit(-1);
    END FatalNameMapError;

(* System() *)

PROCEDURE CallProg (Command: TEXT) RAISES {Error} =
    BEGIN
        TRY
            IF Unix.system(M3toC.TtoS(NameMap.GetDos(Command))) < 0 THEN
                RAISE Error("Error in Unixcommand: " & Command);
            END;
        EXCEPT
            Rd.Failure(err)=> FatalNameMapError(err);  <*ASSERT FALSE*>
        END;
    END CallProg;


(* Exit() *)

PROCEDURE Exit (code: INTEGER) =
    BEGIN
        Unix.exit(code);
    END Exit;


(* GetHostname() *)

PROCEDURE GetHostname (): TEXT RAISES {Error} =
    BEGIN
        RETURN "PC";
    END GetHostname;


(* TimeToString() *)

PROCEDURE TimeToText (t: Time.T): TEXT =
    CONST SecondsAweek = 60*60*24*7;
    TYPE WochenTage = ARRAY [0..6] OF TEXT;
        Monate = ARRAY [0..11] OF TEXT;
    VAR result:= "";
        wochenTage:= WochenTage{"So", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
        monate:= Monate{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
                                  "Aug", "Sep", "Oct", "Nov", "Dec"};
        seconds:= NEW(long_star);
        timerec: Utime.struct_tm_star;
    BEGIN
        seconds^:= t.seconds;
        timerec:= Utime.localtime(seconds);
        DISPOSE(seconds);
        result:= wochenTage[timerec.tm_wday] & ", ";
        result:= result & Fmt.F("%2s", Fmt.Int(timerec.tm_mday)) & ". ";
        result:= result & monate[timerec.tm_mon] & " ";
        IF Time.Compare(t, Time.Now()) <0 AND
            Time.Subtract(Time.Now(), t).seconds > SecondsAweek 
        THEN
            result:= result & "19" & Fmt.F("%02s", Fmt.Int(timerec.tm_year))&" ";
        ELSE
            result:= result & Fmt.F("%2s", Fmt.Int(timerec.tm_hour)) &":";
            result:= result & Fmt.F("%02s", Fmt.Int(timerec.tm_min));
        END;
        RETURN result;
    END TimeToText;

(******************)
(* Prozessnummern *)
(******************)

PROCEDURE GetPID (): PID RAISES {Error} =
    BEGIN
        RETURN Uprocess.getpid();
    END GetPID;

PROCEDURE TestPID (pid: PID): BOOLEAN RAISES {Error} =
    BEGIN
        IF Usignal.kill(pid, 0) < 0 THEN
            IF Uerror.errno = Uerror.ESRCH THEN (*no such process*)
                RETURN FALSE
            ELSE
                RAISE Error("TestPID: missing privileges or other error");
            END;
        ELSE
            RETURN TRUE;
        END;
    END TestPID;


(***************)
(* TestRegExpr *)
(***************)

PROCEDURE TestRegExpr (TestString, Muster: TEXT): BOOLEAN RAISES {Error} =
    VAR Expression: char_star;
    BEGIN
        Expression := Uregexp.re_comp(M3toC.TtoS(Muster));
        IF Expression = M3toC.null THEN
            RAISE Error("Invalid Regular Expression: " & Muster);
        ELSE
            Cstdlib.free(Expression);
            IF Uregexp.re_exec(M3toC.TtoS(TestString)) = NIL THEN
                RETURN FALSE;
            ELSE
                RETURN TRUE;
            END;
        END;
    END TestRegExpr;


(******************)
(* ParseDirectory *)
(******************)

REVEAL
    Dir = BRANDED REF RECORD
                          handle: Udos.DIR_star;
                          selection: TEXT;
                      END;

PROCEDURE OpenDir (path: TEXT; fileSelection := ".*"): Dir RAISES {Error} =
    VAR dirhandle: Udos.DIR_star;
    BEGIN
        dirhandle := Udos.opendir(M3toC.TtoS(path));
        IF dirhandle = NIL THEN
            RAISE Error("Directory " & path & " cannot be opened");
        END;
        RETURN NEW(Dir, handle := dirhandle, selection := fileSelection);
    END OpenDir;

PROCEDURE GetnextDirentry (dir: Dir): TEXT RAISES {Error} =
    VAR
        entryhandle: Udos.dirent_star;
        filename: TEXT;
    BEGIN
        TRY
            entryhandle := Udos.readdir(dir^.handle);
            WHILE entryhandle # NIL DO
                filename := "";
                FOR i := 0 TO entryhandle^.d_namelen - 1 DO
                    filename := filename
                        & Text.FromChar(VAL(entryhandle^.d_name[i], CHAR));
                END;
                filename:= NameMap.GetLong(filename);
                IF TestRegExpr(filename, dir^.selection) THEN
                    RETURN filename;
                END;
                entryhandle := Udos.readdir(dir^.handle);
            END;
            RETURN NIL;              (*nichts gefunden*)
        EXCEPT
            Rd.Failure(err)=> FatalNameMapError(err);  <*ASSERT FALSE*>
        END;
    END GetnextDirentry;


(* unique to the PC-version (see System.i3!) *)

PROCEDURE SeekDirentry (dir: Dir; pos: CARDINAL): TEXT RAISES {Error} =
    VAR
        entryhandle: Udos.dirent_star;
        filename: TEXT;
    BEGIN
        Udos.seekdir(dir^.handle, pos);
        entryhandle := Udos.readdir(dir^.handle);
        IF entryhandle # NIL THEN
            filename := "";
            FOR i := 0 TO entryhandle^.d_namelen - 1 DO
                filename :=
                    filename
                        & Text.FromChar(VAL(entryhandle^.d_name[i], CHAR));
            END;
            RETURN filename;
        ELSE
            RETURN NIL;
        END;
    END SeekDirentry;

PROCEDURE CloseDir (dir: Dir) RAISES {Error} =
    BEGIN
        IF Udos.closedir(dir^.handle) < 0 THEN
            RAISE Error("Directory cannot be closed!");
        END;
    END CloseDir;


(* Andere Directory-Funktionen *)

PROCEDURE ChangeDir(path: TEXT) RAISES {Error} =
    BEGIN
        IF Unix.chdir(M3toC.TtoS(path)) < 0 THEN
            RAISE Error("Change to directory "&path&" failed");
        END;
    END ChangeDir;

PROCEDURE GetCurrentDir(): TEXT =
(* geklaut von UnixUtils.m3 aus dem VBT-Kit *)
    VAR
        pathname := NEW (UNTRACED REF ARRAY [0 .. Unix.MaxPathLen] OF CHAR);
        result   := Unix.getwd (pathname);
    BEGIN
        IF result = NIL THEN
            <* ASSERT FALSE *>
        ELSE
            RETURN M3toC.CopyStoT (pathname)
        END
    END GetCurrentDir;

PROCEDURE FileIsDirectory(path: TEXT): BOOLEAN =
(* geklaut von UnixUtils.m3 aus dem VBT-Kit *)
    VAR
        string := M3toC.TtoS (path);
        ref    := NEW (Ustat.struct_stat_star);
        val    := Ustat.stat (string, ref);
        mode   := ref.st_mode;
    BEGIN
        M3toC.FreeS (string);
        DISPOSE (ref);
        RETURN val = 0 AND Word.And (mode, Ustat.S_IFMT) = Ustat.S_IFDIR
    END FileIsDirectory;

PROCEDURE FileIsReadable(path: TEXT): BOOLEAN =
    BEGIN
        TRY
            RETURN Unix.access(M3toC.TtoS(NameMap.GetDos(path)), Unix.R_OK) = 0;
        EXCEPT
            Rd.Failure(err)=> FatalNameMapError(err); <*ASSERT FALSE*>
        END;
    END FileIsReadable;

PROCEDURE FileIsWriteable(path: TEXT): BOOLEAN =
    BEGIN
        TRY
            RETURN Unix.access(M3toC.TtoS(NameMap.GetDos(path)), Unix.W_OK) = 0;
        EXCEPT
            Rd.Failure(err)=> FatalNameMapError(err);  <*ASSERT FALSE*>
        END;
    END FileIsWriteable;

PROCEDURE FileIsExecutable(path: TEXT): BOOLEAN =
    VAR ext:= Filename.Extension(path);
    BEGIN
        RETURN FileIsReadable(path) AND
               Text.Equal(ext, "bat") OR
               Text.Equal(ext, "com") OR
               Text.Equal(ext, "exe");
    END FileIsExecutable;

PROCEDURE FileModifyTime(path: TEXT): Time.T RAISES {Error} =
(* geklaut von UnixUtils.m3 aus dem VBT-Kit *)
    BEGIN
        TRY
            VAR
                string := M3toC.TtoS (NameMap.GetDos(path));
                ref    := NEW (Ustat.struct_stat_star);
                val    := Ustat.stat (string, ref);
                mtime  := ref.st_mtime;
                t: Time.T;
            BEGIN
                M3toC.FreeS (string);
                DISPOSE (ref);
                IF val = 0 THEN
                    t.microseconds:= 0;  t.seconds:= mtime;
                    RETURN t;
                ELSE
                    RAISE Error("no such file "&path)
                END;
            END;
        EXCEPT
            Rd.Failure(err)=> FatalNameMapError(err);  <*ASSERT FALSE*>
        END;
    END FileModifyTime;

PROCEDURE FileSize(path: TEXT): CARDINAL RAISES {Error} =
    BEGIN
        TRY
            VAR
                string := M3toC.TtoS (NameMap.GetDos(path));
                ref    := NEW (Ustat.struct_stat_star);
                val    := Ustat.stat (string, ref);
                size  := ref.st_size;
            BEGIN
                M3toC.FreeS (string);
                DISPOSE (ref);
                IF val = 0 THEN
                    RETURN size;
                ELSE
                    RAISE Error("no such file "&path)
                END;
            END;
        EXCEPT
            Rd.Failure(err)=> FatalNameMapError(err);  <*ASSERT FALSE*>
        END;
    END FileSize;

BEGIN
END System.
