use v6.d;
use lib $*PROGRAM.parent(2).add( 'lib' ).absolute;

use Test;
use FileSystem::Parent;

my $verbose 
= %*ENV< VERBOSE > 
?? True 
!! False
;

my $append  = 'lib';
my $filter  = 'dir';

my $pass0  = scan-up :$verbose, :$filter, :$append, :!skip-root;
ok $pass0,  'scan-up with want dir';

my $pass1  = scan-up :$verbose  :$filter, :$append, :skip-root;
ok $pass1,  'scan-up with want dir and skip-root';

my @include   = $pass0.eager;
my @exclude   = $pass1.eager;

ok @include[0] ~~ @exclude[0]       , 'Same first directory.';
ok @include[*-1] !~~ @exclude[*-1]  , 'Different last directory.';
ok 1 == @include - @exclude         , 'Include one more.';

put "# include:\t", @include;
put "# exclude:\t", @exclude;

done-testing;
