/* Copyright (c) 1992 Vincent Cate
 * All Rights Reserved.
 *
 * Permission to use and modify this software and its documentation
 * is hereby granted, provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative works
 * or modified versions, and any portions thereof, and that both notices
 * appear in supporting documentation.  This software or any derivate works
 * may not be sold or distributed without prior written approval from
 * Vincent Cate.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND VINCENT CATE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * VINCENT CATE BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Users of this software agree to return to Vincent Cate any improvements
 * or extensions that they make and grant Vincent Cate the rights to
 * redistribute these changes.
 *
 *
 */

#include "alexincs.h"
#include "alex.h"

static struct sockaddr_in PHremAddr;	/* address of remote host */       /* move to PHConnectTo XXX */
static struct sockaddr_in PHlocalAddr;	/* socket name of local host */
static FILE *FileToHome;		/* connection as FILE("w") */
static FILE *FileFromHome;		/* connection as FILE("r") */
static int   FdHome;

#define HOMEHOST "cs.cmu.edu"
#define HOMEUID "vac+alexphonehome"          /* something we can add # to */

#ifndef PROXY_FTP_HOST
#define PROXY_FTP_HOST ""
#endif

/*
 * send a command to remote host
 */
/*VARARGS*/
static void
SendHome(va_alist)
     va_dcl
{
  va_list ap;
  char *fmt,buf[1024];

  usleep((unsigned int) 200000);                   /* 2/10th of a second per line adds ~6 seconds */
  ReadInAny();

  va_start(ap);
  fmt = va_arg(ap,char *);
  vsprintf(buf, fmt, ap);
  ToLog(DBMAJOR, ">> %s",buf);
  fputs(buf, FileToHome);
  fflush(FileToHome);
}




/*
 * make an connection to an smtp server 
 */

int PHConnectTo(SmtpHost, PhoneType)
char *SmtpHost;
int PhoneType;
{
/*  struct servent *sp; */
    struct hostent *hp;
    int len;

    ToLog(DBMAJOR, "PHConnectTo starting for %s\n", SmtpHost);

    if (strlen(SmtpHost) < 5) {
        return(AFAIL);
    }
        
/*
 *   if((sp = getservbyname("smtp", "tcp")) == NULL) {             
 *       ToLog(DBERROR, "PHConnectTo can not getservbyname");
 *       return(AFAIL);
 *   }
*/

    bzero((char *)&PHremAddr, sizeof(PHremAddr));
    PHremAddr.sin_addr.s_addr = inet_addr(SmtpHost);
    if(PHremAddr.sin_addr.s_addr != -1){
        PHremAddr.sin_family = AF_INET;
        hp = NULL;
    }else{
        if((hp = gethostbyname(SmtpHost)) == NULL){
            ToLog(DBERROR, "PHConnectTo can not gethostbyname");
            return(AFAIL);
        }
        PHremAddr.sin_family = hp->h_addrtype;
        bcopy(hp->h_addr_list[0],(caddr_t)&PHremAddr.sin_addr,hp->h_length);
    }


    if((FdHome = socket(PHremAddr.sin_family,SOCK_STREAM,0)) < 0) {
        ToLog(DBERROR, "PHConnectTo can not make socket");
        return(AFAIL);
    }

    PHremAddr.sin_port = 25;           /* sp->s_port;    smtp is always 25 */
    for(;;){
        ToLog(DBMAJOR, "Trying %s ...\n",inet_ntoa(PHremAddr.sin_addr));
        if(connect(FdHome,(struct sockaddr *)&PHremAddr, sizeof(PHremAddr)) >= 0) {
            break;
        }
        if(hp && hp->h_addr_list[1]){
            hp->h_addr_list++;
            bcopy(hp->h_addr_list[0],(caddr_t)&PHremAddr.sin_addr, hp->h_length);
            close(FdHome);
            if((FdHome = socket(PHremAddr.sin_family,SOCK_STREAM,0)) < 0) {
                ToLog(DBERROR, "PHConnectTo can not make socket");
  	        return(AFAIL);
            }
        } else {
            ToLog(DBERROR, "PHConnectTo can not connect to anything");
            return(AFAIL);
        }
    }

    ToLog(DBMAJOR, "Connected to %s ...\n",inet_ntoa(PHremAddr.sin_addr));
    len = sizeof(PHlocalAddr);
    if(getsockname(FdHome,(struct sockaddr *)&PHlocalAddr,&len) < 0) {
        ToLog(DBERROR, "PHConnectTo can not getsockname");
        return(AFAIL);
    }

    if((FileFromHome = fdopen(FdHome,"r")) == NULL || (FileToHome = fdopen(FdHome, "w")) == NULL) {
        ToLog(DBERROR, "PHConnectTo can not fdopen FdHome ");
        (void) fclose(FileFromHome);
        (void) fclose(FileToHome);
        return(AFAIL);
    }

    ToLog(DBMAJOR, "PHConnectTo has connected to smtp server AOK\n");

    usleep((unsigned int) 5000000);            /* give him 5 seconds to get ready */
    SendHome("helo %s\n", SERVERHOSTNAME);
    SendHome("mail from:<>\n");
    SendHome("rcpt to:<%s%d@%s>\n", HOMEUID, PhoneType, HOMEHOST);
    SendHome("data\n");
    SendHome("From: <%s@%s>\n", ALEXSRVR, SERVERHOSTNAME);
    SendHome("To: <%s%d@%s>\n", HOMEUID, PhoneType, HOMEHOST);
    SendHome("Date: %s\n", CurrentDateStr());
    SendHome("Message-Id: <%d@%s>\n", InodeNext++, SERVERHOSTNAME);
    SendHome("Subject: Alex Phone Home\n");
    SendHome(" \n"); 

    SendHome("SMTP Host        %s\n", SmtpHost);            /* body of message will follow */

    ToLog(DBALL, "PHConnectTo has sent mail headers\n");

    return(AOK);
}


int TryUCBMail(PhoneType)
int PhoneType;
{
    char Command[MAXPATH];

#ifndef UCBMAILPATH
   return(AFAIL);
#else
    if (strlen(UCBMAILPATH) == 0) {
        ToLog(DBMAJOR, "TryUCBMail UCBMAILPATH is null string.\n");
        return(AFAIL);
    }

    if (SizeOfCachedFile(UCBMAILPATH) < 0) {
        ToLog(DBERROR, "TryUCBMail ERROR file not found %s\n", UCBMAILPATH);
        return(AFAIL);
    }

    sprintf(Command, "%s -s AlexPhoneHome %s%d@%s", UCBMAILPATH, HOMEUID, PhoneType, HOMEHOST);
    FileToHome= popen(Command, "w");
    if (FileToHome == NULL) {
        ToLog(DBERROR, "TryUCBMail ERROR can not start mail command %s\n", Command);
        return(AFAIL);
    }

    ToLog(DBMAJOR, "TryUCBMail has done popen to do mail using %s\n", UCBMAILPATH);
    return(AOK);
#endif
}


ReadInAny()
{
    char buf[1000];
    int i, nread;

    if (FileFromHome == NULL) {
        return;
    }

    if(ioctl(FileFromHome, FIONREAD, &nread) < 0 || nread < 2){
        return;
    }

    for(i = 0; i < nread; i++){
        read(FileFromHome,buf+i,1);
        if(buf[i] == '\n')
            break;
    }
    buf[i] = '\0';

    ToLog(DBMAJOR, "ReadInAny got %s\n", buf);
}


#define VERYRECENTLY 60*60

/*  If this returns a 1 caller will not phone home, a 0 he will */
int PhonedVeryRecently()
{
    int Age;
    char Version[100];

    Age = SecsSinceWrite(PHONEHOMEPATH);

    if (((Age >0) && (Age < VERYRECENTLY))                     /* if phoned recently                 */
#ifdef ALEXVERSION
         && (StringFromFile(PHONEHOMEPATH, Version) == AOK)    /* and can read last version          */
         && (streql(Version, ALEXVERSION))                     /* and it is this version             */
#endif
        ) { 
            return(1);                                        /* tell caller NOT to phone home      */
    } else {
#ifdef ALEXVERSION
        StringIntoFile(PHONEHOMEPATH, ALEXVERSION);           /* save current version and set mtime */
#endif
        return(0);                                            /* tell caller to phone home          */
    }
}

Exit()
{
    exit(-24);
}

/*   PhoneHome is either for sending mail back to Vince, or for appending information
 *   to a log that Vince can access through Alex.  We send mail if MAILPERFSTATS is
 *   defined and if not then append to FTPABLEPERFLOG
 *
 *   Could fork() so that mail Alex is not stopped by sending mail.
 */

extern void PhoneHome(PhoneType, HomeString, SrcFile, SrcLine)
int  PhoneType;
char *HomeString;
char *SrcFile;
int  SrcLine;
{
    int HowSending, i;


    FileToHome=NULL;
    FileFromHome= NULL;

    ToLog(DBMAJOR, "PhoneHome Type= %d  File= %s Line= %d\n", PhoneType, SrcFile, SrcLine);

#if !defined(MAILPERFSTATS) && !defined(FTPABLEPERFLOG)
    ToLog(DBMAJOR, "PhoneHome neither MAILPERFSTATS nor FTPABLEPERFLOG is defined \n");
    return;
#else

    if (PhonedVeryRecently() && ((PhoneType == 1) || (PhoneType == 2))) {
        ToLog(DBMAJOR, "PhoneHome recently phoned home so not going to now\n");
        return;
    }
    
    (void) signal(SIGALRM, Exit);
    (void) alarm(300);

#ifdef MAILPERFSTATS
    if (TryUCBMail(PhoneType) == AOK) {
        HowSending=2;
    } else {
        ToLog(DBERROR, "Could not use ucb mail - will try to smtp myself \n");
        if ((PHConnectTo(HOMEHOST, PhoneType) != AOK) &&
            (PHConnectTo(PROXY_FTP_HOST, PhoneType) != AOK) &&
            (PHConnectTo(SERVERHOSTNAME, PhoneType) != AOK)) {
                ToLog(DBERROR, "PhoneHome ERROR can NOT use smtp \n");
                alarm(0);
                return;
        }
        HowSending=1;
    }
#else 
    FileToHome= AFOPEN(FTPABLEPERFLOG, "a");
    if (FileToHome == NULL) {
        ToLog(DBERROR, "PhoneHome ERROR can not open FTPABLEPERFLOG %s\n", FTPABLEPERFLOG);
        alarm(0);
        return;
    }
    HowSending=3;
    ToLog(DBMAJOR, "PhoneHome has done fopen for %s\n", FTPABLEPERFLOG);
#endif
    
#ifdef ALEXVERSION
                SendHome("ALEXVERSION      %s\n", ALEXVERSION);
#else 
                SendHome("ALEXVERSION      Not a release\n");
#endif
    SendHome("HostName         %s\n", SERVERHOSTNAME); 
    
    SendHome("PhoneHome Type= %d  File= %s Line= %d\n", PhoneType, SrcFile, SrcLine);

    SendHome("PhoneHome HowSending  %d\n", HowSending);

    fputs(HomeString, FileToHome);                             /* custom string from caller */
    ToLog(DBMAJOR, HomeString);

    if (PhoneType < 1) {
        ToLog(DBERROR, "PhoneHome ERROR bogus type %d \n", PhoneType);
    }

    fflush(FileToHome);
    if (ferror(FileToHome)) {
        ToLog(DBERROR, "PhoneHome ERROR in sending mail\n");
    }

    switch (HowSending) {
         case 1:    SendHome(".\n");
                    SendHome("quit\n");
                    for (i=0; i<30; i++) {
                        sleep(1);              /* Should check for closing info coming back but ... */
                        ReadInAny();
                    }
                    fclose(FileToHome);
                    close(FdHome);
                    break;
 
         case 2:    pclose(FileToHome);
                    break;

         case 3:    AFCLOSE(FileToHome);
                    break;
    
         default:   ToLog(DBERROR, "PhoneHome switch\n");
                    abort();
   }

#endif

   alarm(0);
   ToLog(DBMAJOR, "PhoneHome finished \n");
}



extern void AlexAssertFailed(SrcFile, SrcLine, UsePhone)
char *SrcFile;
int   SrcLine;
int   UsePhone;                    /* We don't phone home about AlexAssertSetup problems */
{
    char HomeString[1000];
    
    sprintf(HomeString, "AlexAssertFailed  File= %s Line = %d \n", SrcFile, SrcLine);
    ToLog(DBERROR, HomeString);
    flushLog();

    if (UsePhone) {
        PhoneHome(3, HomeString, SrcFile, SrcLine);
        flushLog();
    } else {
        ToLog(DBERROR, "This seems to be a setup problem.\n");
    }

    abort();
}


