/*
 *	nestor.h	1.0	18-Mar-91	EHK
 *	nestor.h	1.1	26-Mar-91	EHK	Changed data structure
 *	nestor.h	1.2	29-Mar-91	EHK	Added program options
 *	nestor.h	1.3	10-Jun-91	EHK	BUFSIZ must be defined
 *	nestor.h	1.4	11-Jun-91	EHK	Use two buffers now
 *	nestor.h	1.5	03-Jan-92	EHK	Extended data structure
 */

#include <stdio.h>
#include <sys/types.h>
#include "defs.h"

/*
 *	This one allows defining global variables here
 */
#ifndef EXTERN
#	define EXTERN	extern
#endif /* EXTERN */

#if defined(SYSV) || defined(hpux)
#	include <string.h>
#	define index(str, chr)		strchr(str, chr)
#	define rindex(str, chr)		strrchr(str, chr)
#	define bcopy(src, dst, n)	memcpy(dst, src, n)
#	define bzero(dst, n)		memset(dst, 0, n)
#else
#	include <strings.h>
#endif	/* SYSV || hpux	*/

#ifndef BUFSIZ
#	define BUFSIZ	1024
#endif /* BUFSIZ */

/*
 *	Commonly used macro definitions
 */
#define NIL_CHAR		(char *) 0
#define NIL_NNTP		(nntp_t *) 0

#define HOSTLEN			64		/* max. hostname length	*/
#define KEYWLEN			32		/* max. keyword length	*/

#define TWENTYFOUR_HOURS	(float) (24 * 60 * 60)

/*
 *	The statistics data structure. The NNTP daemon statistics are
 *	in the 'recv_*' variables; the NNTPXMIT statistics are in the
 *	'xmit_*' variables.
 */
typedef struct nntp_info
{
	char	nntp_host[HOSTLEN];	/* host exchanging data with	*/

					/* NNTPD statistics		*/
	int	recv_n_connect,		/* connections made to server	*/
		recv_n_hostfail,	/* failures due local config	*/
		recv_n_netfail;		/* failures due network trouble	*/
	int	recv_a_acc,		/* articles accepted		*/
		recv_a_rej,		/* articles rejected		*/
		recv_a_fai;		/* articles failed		*/
	int	recv_p_acc,		/* posted articles accepted	*/
		recv_p_rej,		/* posted articles rejected	*/
		recv_p_fai;		/* posted articles failed	*/
	int	recv_rr_art,		/* remote read articles		*/
		recv_rr_grp;		/* remote read groups		*/
	float	recv_u_cpu,		/* user CPU seconds burned	*/
		recv_s_cpu,		/* system CPU seconds burned	*/
		recv_r_cpu;		/* real-time CPU seconds burned	*/

					/* NNTPXMIT statistics		*/
	int	xmit_n_connect,		/* xmit connect attempts made	*/
		xmit_n_hostfail,	/* failures due remote config	*/
		xmit_n_netfail;		/* failures due network trouble	*/
	int	xmit_a_off,		/* articles offered		*/
		xmit_a_acc,		/* articles accepted		*/
		xmit_a_rej,		/* articles rejected		*/
		xmit_a_fai;		/* articles failed		*/
	float	xmit_u_cpu,		/* user CPU seconds burned	*/
		xmit_s_cpu,		/* system CPU seconds burned	*/
		xmit_r_cpu;		/* real-time CPU seconds burned	*/
	
					/* NNTPXFER statistics		*/
	int	xfer_n_connect,		/* xfer connect attempts made	*/
		xfer_a_off,		/* articles offered		*/
		xfer_a_acc;		/* articles accepted		*/
} nntp_t;

/*
 *	Definition of the keyword table
 */
typedef struct key_tab
{
	char	*k_key;
	int	k_mne;
} keytab_t;

/*
 *	Keyword mapping table mnemonics
 */
#define KEY_CONNECT	0x01		/* nntpd connection		*/
#define KEY_IHAVE	0x02		/* nntpd finished transfer	*/
#define KEY_TIMES	0x03		/* nntpd transfer times		*/
#define KEY_GROUP	0x04		/* nntp read newsgroups		*/
#define KEY_EXIT	0x05		/* nntp read articles/groups	*/
#define KEY_UNRECOG	0x06		/* nntp unrecognized command	*/
#define KEY_POST	0x07		/* nntp post			*/
#define KEY_NEWNEWS	0x08		/* nntp newnews command issued	*/
#define KEY_STATS	0x0a		/* nntpxmit article transfer	*/
#define KEY_XMIT	0x0b		/* nntpxmit transmit times	*/
#define KEY_E_RLH	0x0c		/* error receive local host	*/
#define KEY_E_RNET	0x0d		/* error receive network	*/
#define KEY_E_XRH	0x0e		/* error transmit remote host	*/
#define KEY_E_XNET	0x0f		/* error transmit network	*/

/*
 *	Coding of program options - always just a single bit on
 */
#define OPT_ALL		0xff		/* -a  want all you can get	*/
#define OPT_INCOMING	0x01		/* -i  incoming stats		*/
#define OPT_NETWORK	0x02		/* -n  net/host/config errors	*/
#define OPT_OUTGOING	0x04		/* -o  outgoing stats		*/
#define OPT_REMOTE	0x08		/* -r  remote read/post stats	*/
#define OPT_EXTENDED	0x10		/* -x  analyze stats, be smart	*/

/*
 *===========================================================================
 *			G L O B A L    V A R I A B L E S
 *===========================================================================
 */

EXTERN int	opts,			/* program options		*/
		num_nntp_hosts,		/* current number of hosts	*/
		verbose;		/* scream on errors in input	*/

EXTERN int	i1, i2, i3, i4;		/* syslog scanned int's		*/
EXTERN float	f1, f2, f3;		/* syslog scanned float's	*/

EXTERN keytab_t	keytable[];		/* syslog-keyword table		*/

EXTERN nntp_t	nntps[NUM_NNTP_HOSTS];	/* hosts statistics array	*/

EXTERN char	logbuff[2][BUFSIZ],	/* buffers for syslog entries	*/
		*start_date;		/* date/time of logging start	*/

