/*
 * history - handle a news history file
 *
 * Copyright (C) 1992 Stephen Hebditch. All rights reserved.
 * TQM Communications, BCM Box 225, London, WC1N 3XX.
 * steveh@orbital.demon.co.uk  +44 836 825962
 *
 * See README for more information and disclaimers
 *
 * Routines to open and close a C-News style history file and determine
 * whether or not a particular message id exists in the history file.
 *
 * 1.00  30 Sep 92  SH  Initial coding.
 *
 */

#include "slurp.h"

#ifdef DBM
  #undef NULL
  #include <dbm.h>
  #undef NULL
  #define NULL 0
#endif

#ifdef DBZ
  #include <dbz.h>
  #define DBM
#endif

#ifdef NDBM
  #include <ndbm.h>
  #include <fcntl.h>
  static DBM *db = NULL;
#endif


/*
 * open_history - Open history file
 */

	int
open_history ()
	{
#ifdef DBM
	if (dbminit (HISTORY_FILE) < 0)
		return (1);
#endif

#ifdef NDBM
 	if ((db = dbm_open (HISTORY_FILE, O_RDONLY, 0)) == NULL)
		return (1);
#endif

	return (0);
	}


/*
 * close_history - Close history file
 */

	void
close_history ()
	{
#ifdef DBM
	(void) dbmclose ();
#endif

#ifdef NDBM
 	dbm_close (db);
#endif
	}


/*
 * Determine if message id already exists in the history file
 */

	int
check_id (char *message_id)
	{
	datum k, d;

/* Now check for presence with dbm/ndbm */

	k.dptr = message_id;
	k.dsize = strlen (message_id) + 1;

#ifdef DBM
	d = fetch (k);
#else
 	d = dbm_fetch (db, k);
#endif

	return (d.dptr == NULL);
	}

/* END-OF-FILE */
