/*
 * time - obtain the time from the remote server
 *
 * Copyright (C) 1992 Stephen Hebditch. All rights reserved.
 * TQM Communications, BCM Box 225, London, WC1N 3XX.
 * steveh@orbital.demon.co.uk  +44 836 825962
 *
 * See README for more information and disclaimers
 *
 * Obtain the current time from the remote server in standard unix time
 * format for use with the next NEWNEWS. If the client is unable to
 * connect to the time server or the read fails then the error is
 * reported and the program is exited.
 *
 * 1.00   7 Aug 92  SH  Initial coding.
 *
 */

#include "slurp.h"

#include <unistd.h>
#include <netinet/in.h>


	time_t
server_time (char *hostname)
	{
	int server, ret;
	u_long timebuf;

/* First open the socket */

	if ((server = tcp_open (hostname, "time")) < 0)
		return ((time_t) 0);

	ret = read (server, &timebuf, 4);

/* Close the socket and check we got 4 bytes */

	(void) close (server);

	if (ret != 4)
		{
		log_ret ("server_time: Read error on time server socket");
		return ((time_t) 0);
		}

/* Convert byte order if needed */

	timebuf = ntohl (timebuf);

	if (debug_flag)
		(void) fprintf (stderr, "time is currently %ld at server %s\n",
						timebuf, hostname);

/* Convert the time from seconds since 1900 to seconds since 1970 */

	return ((time_t) (timebuf - 2208988800));
	}

/* END-OF-FILE */
