/*
 * slurp.h - common definitions for slurp
 *
 * Copyright (C) 1992 Stephen Hebditch. All rights reserved.
 * TQM Communications, BCM Box 225, London, WC1N 3XX.
 * steveh@orbital.demon.co.uk  +44 836 825962
 *
 * See README for more information and disclaimers
 *
 * 1.00  29 Sep 92  SH  Initial coding.
 * 1.03  15 Dec 92  SH  Added SYS_ERRLIST
 *
 */


/* SLURP CONFIGURATION
   =================== */

/* Set these to the location of the slurp configuration files - NEWSLIB
   is usually a good place for them. */

#define SYSFILE			"/usr/lib/news/slurp.sys"
#define TIMFILE			"/usr/lib/news/slurp.tim"


/* If SPEEDUP is defined then there will always be one ARTICLE request
   stacked up at the NNTP server before the current article has finished
   being received. Although not strictly conforming to the standard this
   allows a much greater article throughput. */

#define SPEEDUP


/* If defined then the number of characters per second transferred during
   the article request phase will be logged. */

#define SPEEDSTATS


/* MAXCACHE sets the maximum number of articles that may be requested in
   any one session. If this is exceeded then this is noted to the log and
   the new time for the next NEWNEWS will not be written. */

#define MAXCACHE		4096


/* NEWS CONFIGURATION
   ================== */

/* The location of the rnews program. */

#define RNEWS           "/usr/bin/rnews"


/* The location of the news history file. */

#define HISTORY_FILE    "/usr/lib/news/history"


/* The database format used by the news history file. For modern C News
   and INN this will almost certainly be DBZ. */

#define DBZ
#undef	DBM
#undef	NDBM


/* The location of the spool directory holding news articles. This is
   needed so we can check if there is enough space before starting to
   build up another batch of articles. */

#define SPOOLDIR        "/var/spool/news"


/* If less then MINFREE blocks are available on the disk containing
   SPOOLDIR then slurp will be aborted. If MINFREE is not defined then
   a space check is not carried out. */

#define MINFREE 4000
                        

/* UNIX VERSION CONFIGURATION
   ========================== */

/* The facility name which syslog reports errors and stats under. If you
   don't want to use syslog for reporting then undefine and the
   information will be written to stderr instead. */

#define SYSLOG			LOG_NEWS


/* If you don't have syslog then you can use the supplied fakesyslog
   instead. Define FAKESYSLOG to be the name of the file to contain the
   log. If your host supports the BSD fdopen() function and the O_APPEND
   flag to open(), you should define FAKEAPPEND with FAKESYSLOG so that
   multiple copies of nntpd don't trash the log with buffered fprintfs. */
   
/* #define FAKESYSLOG      "/usr/lib/news/nntplog" /* */
/* #define FAKEAPPEND /* */


/* Set the below according to whether you're running a BSD or USG
   variant of UNIX. You may need to add some other #defines to set
   the correct options in space.c - see that file for details. */

#define USG				/* USL System V */
#undef BSD_42			/* BSD 4.2 */
#undef BSD_43			/* BSD 4.3 */


/* Change to int if your signal() is old and returns int instead of void */

#define SIGRET			void


/* Define if your system has extern char sys_errlist[], but no strerror() */

#undef SYS_ERRLIST


/* STUFF BELOW PROBABLY DOESN'T NEED ALTERING
   ========================================== */

#define MSGIDMAX		256		/* Maximum size of a message id */

#define BATCHSIZEMAX	300000L	/* Optimum size of a news batch */
#define BATCHARTSMAX	1024	/* Max no of articles per batch */
#define COPYSIZE		16384	/* Articles bigger than this size will
                                   be written to a temporary file while
                                   they are being retrieved, rather than
                                   stored in memory */

#define TIMEOUT			60 * 10	/* Max time to wait for a line from the
                                   server. */

/* END-OF-FILE */
