/*
 * misc - general miscellaneous routines
 *
 * Copyright (C) 1992 Stephen Hebditch. All rights reserved.
 * TQM Communications, BCM Box 225, London, WC1N 3XX.
 * steveh@orbital.demon.co.uk  +44 836 825962
 *
 * See README for more information and disclaimers
 *
 * Assorted miscellaneous routines.
 *
 * 1.00  27 Nov 92  SH  Initial coding.
 *
 */

#include "slurp.h"
#include <errno.h>
#include <stdarg.h>


static void log_doit (int sysflag, const char *fmt, va_list ap);


/*
 * log_ret - Log a message to stderr or syslog related to a system call
 * containing the appropriate system error message and return.
 */

	void
log_ret (const char *fmt, ...)
	{
	va_list ap;

	va_start (ap, fmt);
	log_doit (TRUE, fmt, ap);
	va_end (ap);
	return;
	}


/*
 * log_sys - Log a message to stderr or syslog related to a system call.
 * containing the appropriate system error message and exit program.
 */

	void
log_sys (const char *fmt, ...)
	{
	va_list ap;

	va_start (ap, fmt);
	log_doit (TRUE, fmt, ap);
	va_end (ap);
	exit (1);
	}


/*
 * log_msg - Log a message to stderr or syslog unrelated to a system call.
 */

	void
log_msg (const char *fmt, ...)
	{
	va_list ap;

	va_start (ap, fmt);
	log_doit (FALSE, fmt, ap);
	va_end (ap);
	return;
	}


/*
 * log_doit - Write an error message to stderr if debug_flag is set or
 * syslog if not set. If sysflag is true then the last system error
 * message is appended.
 */

	static void
log_doit (int sysflag, const char *fmt, va_list ap)
	{
	int errnosave;
	char buf [BUFSIZ];

	errnosave = errno;
	(void) vsprintf (buf, fmt, ap);
	if (sysflag)
		(void) sprintf (buf + strlen (buf), ": %s", strerror (errnosave));
	(void) strcat (buf, "\n");
#ifdef SYSLOG
		if (!debug_flag)
			syslog (LOG_ERR, buf);
		else
#endif
			(void) fprintf (stderr, "%s: %s", pname, buf);
	}


/* END-OF-FILE */
