[![Build Status](https://travis-ci.org/allsopp/p6-html-boredom.svg?branch=master)](https://travis-ci.org/allsopp/p6-html-boredom)

# HTML::BoreDOM

Write HTML programmatically:

    > use HTML::BoreDOM;

    > put
    > h("html",
    >  h("body",
    >   h("h1", "Hello, World!"),
    >   h("p", "Lorem ipsum...")));

    <html>
    <body>
    <h1>Hello, World!</h1>
    <p>Lorem ipsum...</p>
    </body>
    </html>    

The `h()` subroutine is imported automatically and returns an object (that
stringifies to escaped HTML):

    > h("span", "foo");
    HTML::BoreDOM::Element.new(tag => "span", attrs => ${}, children => $["foo"])

    > ~h("span", "foo");
    <span>foo</span>

HTML attributes are optionally declared using named arguments:

    > ~h("a", :href<http://www.example.com>, :target<_blank>, "Click Here!")
    <a href="http://www.example.com" target="_blank">Click Here!</a>

Looping is easy:

    > my @items = <foo bar baz>;

    > ~h("ul", 
    >   @items.map({ h("li", $_) }));

    <ul>
    <li>foo</li>
    <li>bar</li>
    <li>baz</li>
    </ul>

Templates are just functions:

    > sub foo ($title, $subtitle, $content) {
    >   ~ h("h1", $title)
    >   ~ h("h2", $subtitle)
    >   ~ h("p", $content)
    > }

    > foo("My Website", "Using templates", "Lorem ipsum ...");

    <h1>My Website</h1>
    <h2>Using templates</h2>
    <p>Lorem ipsum ...</p>

## Caveats

Inline `<script>` and `<style>` won't work because certain characters (i.e.
`&`, `<`, and `>`) are automatically escaped. The fix is trivial but has
intentionally been left unimplemented keep this package simple.

## Copyright and License

Copyright (c) 2019, Owen Allsopp

This package is free software; you can redistribute it and/or modify it under
the terms of the Artistic License 2.0.

## See also

This idea is based on [HyperScript](https://github.com/hyperhype/hyperscript).

Mixing logic and presentation is usually a [Very Bad
Idea](https://en.wikipedia.org/wiki/Separation_of_concerns).

Some alternatives with more features:

* [HTML::Lazy](https://modules.raku.org/dist/HTML::Lazy:cpan:SAMGWISE)
* [HTML::Tag](https://github.com/adaptiveoptics/HTML-Tag)
* [XHTML::Writer](https://github.com/gfldex/perl6-xhtml-writer)
